/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.ArithmeticFunctionNode;
import oracle.toplink.essentials.internal.parsing.AttributeNode;
import oracle.toplink.essentials.internal.parsing.DotNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class SizeNode
extends ArithmeticFunctionNode {
    public void validate(ParseTreeContext context) {
        if (this.left != null) {
            this.left.validate(context);
        }
        TypeHelper typeHelper = context.getTypeHelper();
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext context) {
        DotNode dotNode = (DotNode)this.getLeft();
        Node prefix = dotNode.getLeft();
        String variableName = ((AttributeNode)dotNode.getRight()).getAttributeName();
        if (!dotNode.endsWithCollectionField(context)) {
            throw EJBQLException.invalidSizeArgument(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), variableName);
        }
        Expression whereClause = prefix.generateExpression(context);
        whereClause = whereClause.size(variableName);
        return whereClause;
    }
}

