/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.identitymaps;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;

public abstract class IdentityMap
implements Serializable,
Cloneable {
    protected int maxSize;
    protected CacheKey searchKey;

    public IdentityMap(int size) {
        this.maxSize = size;
        this.searchKey = new CacheKey(new Vector(1), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireDeferredLock(Vector primaryKey) {
        CacheKey key = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            key = this.getCacheKey(primaryKey);
            if (key == null) {
                CacheKey cacheKey = this.createCacheKey(primaryKey, null, null);
                cacheKey.acquireDeferredLock();
                this.put(cacheKey);
                return cacheKey;
            }
        }
        key.acquireDeferredLock();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLock(Vector primaryKey, boolean forMerge) {
        CacheKey key = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            key = this.getCacheKey(primaryKey);
            if (key == null) {
                CacheKey cacheKey = this.createCacheKey(primaryKey, null, null);
                cacheKey.acquire(forMerge);
                this.put(cacheKey);
                return cacheKey;
            }
        }
        key.acquire();
        return key;
    }

    public abstract void collectLocks(HashMap var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLockNoWait(Vector primaryKey, boolean forMerge) {
        CacheKey key = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            key = this.getCacheKey(primaryKey);
            if (key == null) {
                CacheKey cacheKey = this.createCacheKey(primaryKey, null, null);
                cacheKey.acquire(forMerge);
                this.put(cacheKey);
                return cacheKey;
            }
        }
        if (key != null && !key.acquireNoWait(forMerge)) {
            key = null;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey) {
        CacheKey key = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            key = this.getCacheKey(primaryKey);
            if (key == null) {
                CacheKey cacheKey = this.createCacheKey(primaryKey, null, null);
                cacheKey.acquireReadLock();
                return cacheKey;
            }
        }
        key.acquireReadLock();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey) {
        CacheKey key = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            key = this.getCacheKey(primaryKey);
            if (key == null) {
                CacheKey cacheKey = this.createCacheKey(primaryKey, null, null);
                cacheKey.acquireReadLock();
                return cacheKey;
            }
        }
        if (key != null && !key.acquireReadLockNoWait()) {
            key = null;
        }
        return key;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public boolean containsKey(Vector primaryKey) {
        CacheKey wrapper = this.getCacheKeyWithReadLock(primaryKey);
        return wrapper != null;
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue) {
        return this.createCacheKey(primaryKey, object, writeLockValue, 0L);
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        return new CacheKey(primaryKey, object, writeLockValue, readTime);
    }

    public abstract Enumeration elements();

    public Object get(Vector primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheKey getCacheKey(Vector primaryKey) {
        CacheKey key = null;
        IdentityMap identityMap = this;
        synchronized (identityMap) {
            this.getSearchKey().setKey(primaryKey);
            key = this.getCacheKey(this.getSearchKey());
        }
        return key;
    }

    protected abstract CacheKey getCacheKey(CacheKey var1);

    protected CacheKey getCacheKeyWithReadLock(Vector primaryKey) {
        CacheKey key = this.getCacheKey(primaryKey);
        if (key != null) {
            key.acquireReadLock();
            key.releaseReadLock();
        }
        return key;
    }

    public static Class getDefaultIdentityMapClass() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public int getMaxSize() {
        if (this.maxSize == -1) {
            this.maxSize = 100;
        }
        return this.maxSize;
    }

    protected CacheKey getSearchKey() {
        return this.searchKey;
    }

    public abstract int getSize();

    public abstract int getSize(Class var1, boolean var2);

    public Object getWrapper(Vector primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWrapper();
    }

    public Object getWriteLockValue(Vector primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWriteLockValue();
    }

    public void initialize(int size) {
        this.setMaxSize(size);
    }

    public abstract Enumeration keys();

    public abstract CacheKey put(Vector var1, Object var2, Object var3, long var4);

    protected abstract void put(CacheKey var1);

    public Object remove(Vector primaryKey) {
        CacheKey key = this.getCacheKey(primaryKey);
        return this.remove(key);
    }

    public abstract Object remove(CacheKey var1);

    protected void setMaxSize(int size) {
        this.maxSize = size;
    }

    public synchronized void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
    }

    protected void setSearchKey(CacheKey searchKey) {
        this.searchKey = searchKey;
    }

    public void setWrapper(Vector primaryKey, Object wrapper) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey != null) {
            cacheKey.setWrapper(wrapper);
        }
    }

    public void setWriteLockValue(Vector primaryKey, Object writeLockValue) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey != null) {
            cacheKey.acquire();
            cacheKey.setWriteLockValue(writeLockValue);
            cacheKey.release();
        }
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "[" + this.getSize() + "]";
    }

    public void updateCacheKey(CacheKey cacheKey) {
    }
}

