/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.exceptions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class IntegrityChecker
implements Serializable {
    protected Vector caughtExceptions = null;
    protected Vector tables = null;
    protected boolean shouldCatchExceptions = true;
    protected boolean shouldCheckDatabase = false;
    protected boolean shouldCheckInstantiationPolicy = true;

    public void catchExceptions() {
        this.setShouldCatchExceptions(true);
    }

    public void checkDatabase() {
        this.setShouldCheckDatabase(true);
    }

    public void checkInstantiationPolicy() {
        this.setShouldCheckInstantiationPolicy(true);
    }

    public boolean checkTable(DatabaseTable table, AbstractSession session) {
        if (this.getTables().size() == 0) {
            this.initializeTables(session);
        }
        if (session.getPlatform().isMySQL()) {
            return this.getTables().contains(table.getName().toLowerCase());
        }
        return this.getTables().contains(table.getName());
    }

    public void dontCatchExceptions() {
        this.setShouldCatchExceptions(false);
    }

    public void dontCheckDatabase() {
        this.setShouldCheckDatabase(false);
    }

    public void dontCheckInstantiationPolicy() {
        this.setShouldCheckInstantiationPolicy(false);
    }

    public Vector getCaughtExceptions() {
        if (this.caughtExceptions == null) {
            this.caughtExceptions = new Vector();
        }
        return this.caughtExceptions;
    }

    public Vector getTables() {
        if (this.tables == null) {
            this.tables = new Vector();
        }
        return this.tables;
    }

    public void handleError(RuntimeException runtimeException) {
        if (!this.shouldCatchExceptions()) {
            throw runtimeException;
        }
        this.getCaughtExceptions().addElement(runtimeException);
    }

    public boolean hasErrors() {
        return this.caughtExceptions != null && this.caughtExceptions.size() > 0;
    }

    public boolean hasRuntimeExceptions() {
        if (this.hasErrors()) {
            Enumeration exceptionsEnum = this.getCaughtExceptions().elements();
            while (exceptionsEnum.hasMoreElements()) {
                if (!(exceptionsEnum.nextElement() instanceof RuntimeException)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializeTables(AbstractSession session) {
        Vector result = session.getAccessor().getTableInfo(null, null, null, null, session);
        Enumeration resultEnum = result.elements();
        while (resultEnum.hasMoreElements()) {
            AbstractRecord row = (AbstractRecord)resultEnum.nextElement();
            this.tables.addElement(row.get("TABLE_NAME"));
        }
    }

    public void setCaughtExceptions(Vector exceptions) {
        this.caughtExceptions = exceptions;
    }

    public void setShouldCatchExceptions(boolean answer) {
        this.shouldCatchExceptions = answer;
    }

    public void setShouldCheckDatabase(boolean answer) {
        this.shouldCheckDatabase = answer;
    }

    public void setShouldCheckInstantiationPolicy(boolean answer) {
        this.shouldCheckInstantiationPolicy = answer;
    }

    public boolean shouldCatchExceptions() {
        return this.shouldCatchExceptions;
    }

    public boolean shouldCheckDatabase() {
        return this.shouldCheckDatabase;
    }

    public boolean shouldCheckInstantiationPolicy() {
        return this.shouldCheckInstantiationPolicy;
    }
}

