/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.actions;

import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.xml.jaxb.cfg.schema.Binding;
import org.netbeans.modules.xml.jaxb.cfg.schema.Bindings;
import org.netbeans.modules.xml.jaxb.cfg.schema.Catalog;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSource;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSources;
import org.netbeans.modules.xml.jaxb.cfg.schema.XjcOption;
import org.netbeans.modules.xml.jaxb.cfg.schema.XjcOptions;
import org.netbeans.modules.xml.jaxb.ui.JAXBWizardIterator;
import org.netbeans.modules.xml.jaxb.ui.JAXBWizardSchemaNode;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenJAXBCustomizerAction
extends NodeAction {
    private void populateSchemaBindingValues(WizardDescriptor wiz, Project prj, Schema schema) {
        Catalog cat;
        int numBindings;
        Bindings bindings;
        int i;
        String name = ProjectUtils.getInformation((Project)prj).getName();
        wiz.putProperty("schema.name", (Object)schema.getName());
        wiz.putProperty("project.name", (Object)name);
        wiz.putProperty("project.dir", (Object)FileUtil.toFile((FileObject)prj.getProjectDirectory()));
        wiz.putProperty("xsd.package.name", (Object)schema.getPackage());
        wiz.putProperty("jaxb.schema.type", (Object)schema.getType());
        XjcOptions opts = schema.getXjcOptions();
        if (opts != null && (i = opts.sizeXjcOption()) > 0) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            String key = null;
            String value = null;
            Boolean boolVal = null;
            for (int j = 0; j < i; ++j) {
                XjcOption xo = opts.getXjcOption(j);
                key = xo.getName();
                value = xo.getValue();
                boolVal = Boolean.FALSE;
                if (value != null && "true".equals(value.toLowerCase())) {
                    boolVal = Boolean.TRUE;
                }
                options.put(key, boolVal);
            }
            wiz.putProperty("jaxb.xjc.options", options);
        }
        SchemaSources sss = schema.getSchemaSources();
        SchemaSource ss = null;
        if (sss != null) {
            int sssSize = sss.sizeSchemaSource();
            String origSrcLocType = null;
            if (sssSize > 0) {
                ArrayList<String> xsdFileList = new ArrayList<String>();
                for (int i2 = 0; i2 < sssSize; ++i2) {
                    ss = sss.getSchemaSource(i2);
                    xsdFileList.add(ss.getOrigLocation());
                    origSrcLocType = ss.getOrigLocationType();
                }
                wiz.putProperty("xsd.file.list", xsdFileList);
                wiz.putProperty("xsd.locatiom.type", origSrcLocType);
            }
        }
        if ((bindings = schema.getBindings()) != null && (numBindings = bindings.sizeBinding()) > 0) {
            ArrayList<String> bs = new ArrayList<String>();
            Binding binding = null;
            for (int i3 = 0; i3 < numBindings; ++i3) {
                binding = bindings.getBinding(i3);
                bs.add(binding.getOrigLocation());
            }
            wiz.putProperty("jaxb.binding.files", bs);
        }
        if ((cat = schema.getCatalog()) != null && cat.getOrigLocation() != null) {
            wiz.putProperty("jaxb.catalog.file", (Object)cat.getOrigLocation());
        }
    }

    protected void performAction(Node[] activatedNodes) {
        JAXBWizardSchemaNode schemaNode = null;
        Project project = null;
        Schema schema = null;
        if (activatedNodes.length == 1) {
            Node theNode = activatedNodes[0];
            schemaNode = (JAXBWizardSchemaNode)((Object)theNode.getLookup().lookup(JAXBWizardSchemaNode.class));
            project = schemaNode.getProject();
            schema = schemaNode.getSchema();
            if (project != null) {
                JAXBWizardIterator wizardIter = new JAXBWizardIterator(project);
                WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Iterator)wizardIter);
                wd.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
                wd.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
                wd.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
                List<String> schemaNames = ProjectHelper.getSchemaNames(project);
                if (schemaNames != null) {
                    schemaNames.remove(schema.getName());
                }
                wd.putProperty("jaxb.cfg.existingSchemaNames", schemaNames);
                boolean displayDlg = true;
                wizardIter.initialize(wd);
                this.populateSchemaBindingValues(wd, project, schema);
                wd.setTitleFormat(new MessageFormat("{0}"));
                DialogDisplayer dd = DialogDisplayer.getDefault();
                Dialog dlg = dd.createDialog((DialogDescriptor)wd);
                dlg.setTitle(this.getDialogTitle());
                dlg.getAccessibleContext().setAccessibleDescription(this.getDialogTitle());
                while (displayDlg) {
                    dlg.setVisible(true);
                    displayDlg = false;
                    if (wd.getValue() != WizardDescriptor.FINISH_OPTION) continue;
                    try {
                        Schema nSchema = ProjectHelper.importResources(project, wd, schema);
                        schemaNode.setSchema(nSchema);
                        ProjectHelper.changeSchemaInModel(project, schema, nSchema);
                        ProjectHelper.cleanCompileXSDs(project, true);
                    }
                    catch (Throwable ex) {
                        displayDlg = true;
                        wd = new WizardDescriptor((WizardDescriptor.Iterator)wizardIter);
                        String msg = NbBundle.getMessage(JAXBWizardIterator.class, (String)"MSG_ErrorReadingSchema");
                        wd.putProperty("WizardPanel_errorMessage", (Object)msg);
                        wd.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
                        wd.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
                        wd.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
                        wd.putProperty("jaxb.cfg.existingSchemaNames", schemaNames);
                        this.populateSchemaBindingValues(wd, project, schema);
                        wd.setTitleFormat(new MessageFormat("{0}"));
                        wizardIter.initialize(wd);
                        wd.setValid(false);
                        wd.setMessage((Object)msg);
                        dlg = dd.createDialog((DialogDescriptor)wd);
                        dlg.setTitle(this.getDialogTitle());
                        dlg.getAccessibleContext().setAccessibleDescription(this.getDialogTitle());
                    }
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_CustomizeJAXBOptions");
    }

    protected String getDialogTitle() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_DialogTitleChangeBindingOptions");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        DataObject dataobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        if (dataobj != null) {
            FileObject fileObject = dataobj.getPrimaryFile();
        }
        return true;
    }
}

