/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MacrosStorage
implements StorageDescription<String, MacroDescription> {
    private static final Logger LOG = Logger.getLogger(MacrosStorage.class.getName());
    public static final String ID = "Macros";
    private static final String E_ROOT = "editor-macros";
    private static final String E_MACRO = "macro";
    private static final String E_DESCRIPTION = "description";
    private static final String E_CODE = "code";
    private static final String E_SHORTCUT = "shortcut";
    private static final String A_NAME = "name";
    private static final String A_DESCRIPTION_ID = "descriptionId";
    private static final String A_KEYSTROKES = "keystrokes";
    private static final String A_REMOVE = "remove";
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_PRESERVE = "preserve";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Macros settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorMacros-1_1.dtd";
    private static final String MIME_TYPE = "text/x-nbeditor-macrosettings";

    public String getId() {
        return ID;
    }

    public boolean isUsingProfiles() {
        return false;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public String getLegacyFileName() {
        return "macros.xml";
    }

    public StorageReader<String, MacroDescription> createReader(FileObject f, String mimePath) {
        if (MIME_TYPE.equals(f.getMIMEType())) {
            return new Reader(f, mimePath);
        }
        return new LegacyReader(f, mimePath);
    }

    public StorageWriter<String, MacroDescription> createWriter(FileObject f, String mimePath) {
        return new Writer();
    }

    private static final class Writer
    extends StorageWriter<String, MacroDescription> {
        public Document getDocument() {
            Element element;
            Document doc = XMLUtil.createDocument((String)MacrosStorage.E_ROOT, null, (String)MacrosStorage.PUBLIC_ID, (String)MacrosStorage.SYSTEM_ID);
            Node root = doc.getElementsByTagName(MacrosStorage.E_ROOT).item(0);
            for (MacroDescription macro : this.getAdded().values()) {
                String string;
                element = doc.createElement(MacrosStorage.E_MACRO);
                root.appendChild(element);
                element.setAttribute(MacrosStorage.A_NAME, macro.getName());
                List<? extends MultiKeyBinding> shortcuts = macro.getShortcuts();
                if (shortcuts != null && shortcuts.size() > 0) {
                    for (MultiKeyBinding multiKeyBinding : shortcuts) {
                        Element shortcutElement = doc.createElement(MacrosStorage.E_SHORTCUT);
                        shortcutElement.setAttribute(MacrosStorage.A_KEYSTROKES, StorageSupport.keyStrokesToString((Collection)multiKeyBinding.getKeyStrokeList(), (boolean)true));
                        element.appendChild(shortcutElement);
                    }
                }
                element.setAttribute(MacrosStorage.A_XML_SPACE, MacrosStorage.V_PRESERVE);
                String code = macro.getCode();
                if (code.length() > 0) {
                    Element element2 = doc.createElement(MacrosStorage.E_CODE);
                    element2.appendChild(doc.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)code)));
                    element.appendChild(element2);
                }
                if ((string = macro.getDescription()) == null || string.length() <= 0) continue;
                Element descriptionElement = doc.createElement(MacrosStorage.E_DESCRIPTION);
                descriptionElement.appendChild(doc.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)string)));
                element.appendChild(descriptionElement);
            }
            for (String name : this.getRemoved()) {
                element = doc.createElement(MacrosStorage.E_MACRO);
                root.appendChild(element);
                element.setAttribute(MacrosStorage.A_NAME, name);
                element.setAttribute(MacrosStorage.A_REMOVE, Boolean.TRUE.toString());
            }
            return doc;
        }
    }

    private static final class LegacyReader
    extends MacrosReader {
        private static final String EL_ROOT = "macros";
        private static final String EL_MACRO = "macro";
        private static final String AL_NAME = "name";
        private static final String AL_REMOVE = "remove";
        private Map<String, MacroDescription> macrosMap = new HashMap<String, MacroDescription>();
        private Set<String> removedMacros = new HashSet<String>();
        private String name = null;
        private StringBuilder text = null;

        public LegacyReader(FileObject f, String mimePath) {
            super(f, mimePath);
        }

        @Override
        public Map<String, MacroDescription> getAdded() {
            return this.macrosMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedMacros;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals(EL_ROOT) && qName.equals("macro")) {
                boolean removed = Boolean.valueOf(attributes.getValue("remove"));
                if (removed) {
                    String abbrev = attributes.getValue("name");
                    this.removedMacros.add(abbrev);
                    this.name = null;
                    this.text = null;
                } else {
                    this.name = attributes.getValue("name");
                    this.text = new StringBuilder();
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!qName.equals(EL_ROOT) && qName.equals("macro") && this.name != null) {
                MacroDescription macro = new MacroDescription(this.name, CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.text), null, Collections.emptyList());
                this.macrosMap.put(this.name, macro);
            }
        }
    }

    private static final class Reader
    extends MacrosReader {
        private Map<String, MacroDescription> macrosMap = new HashMap<String, MacroDescription>();
        private Set<String> removedMacros = new HashSet<String>();
        private String name = null;
        private String description = null;
        private String code = null;
        private List<MultiKeyBinding> shortcuts = null;
        private StringBuilder text = null;
        private StringBuilder cdataText = null;
        private boolean insideCdata = false;

        public Reader(FileObject f, String mimePath) {
            super(f, mimePath);
        }

        @Override
        public Map<String, MacroDescription> getAdded() {
            return this.macrosMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedMacros;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
                if (this.insideCdata) {
                    this.cdataText.append(ch, start, length);
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals(MacrosStorage.E_ROOT)) {
                if (qName.equals(MacrosStorage.E_MACRO)) {
                    boolean removed = Boolean.valueOf(attributes.getValue(MacrosStorage.A_REMOVE));
                    this.name = null;
                    this.description = null;
                    this.shortcuts = null;
                    this.text = null;
                    this.cdataText = null;
                    if (removed) {
                        String macroName = attributes.getValue(MacrosStorage.A_NAME);
                        this.removedMacros.add(macroName);
                    } else {
                        String localizedDescription;
                        this.name = attributes.getValue(MacrosStorage.A_NAME);
                        this.description = attributes.getValue(MacrosStorage.A_DESCRIPTION_ID);
                        if (this.description != null && (localizedDescription = StorageSupport.getLocalizingBundleMessage((FileObject)this.getProcessedFile(), (String)this.description, null)) != null) {
                            this.description = localizedDescription;
                        }
                        this.shortcuts = new ArrayList<MultiKeyBinding>();
                    }
                } else if (this.name != null && qName.equals(MacrosStorage.E_CODE)) {
                    this.text = new StringBuilder();
                    this.cdataText = new StringBuilder();
                    this.insideCdata = false;
                } else if (this.name != null && qName.equals(MacrosStorage.E_DESCRIPTION)) {
                    this.text = new StringBuilder();
                    this.cdataText = new StringBuilder();
                    this.insideCdata = false;
                } else if (this.name != null && qName.equals(MacrosStorage.E_SHORTCUT)) {
                    int idx;
                    String keystrokes = attributes.getValue(MacrosStorage.A_KEYSTROKES);
                    if (this.isModuleFile() && this.isDefaultProfile() && keystrokes != null && keystrokes.length() > 0 && (idx = keystrokes.indexOf(45)) != -1 && (keystrokes.charAt(0) == 'A' || keystrokes.charAt(0) == 'C')) {
                        LOG.warning("The keybinding '" + keystrokes + "' in " + this.getProcessedFile().getPath() + " may not work correctly on Mac. " + "Keybindings starting with Alt or Ctrl should " + "be coded with latin capital letters 'O' " + "or 'D' respectively. For details see org.openide.util.Utilities.stringToKey().");
                    }
                    KeyStroke[] arr = StorageSupport.stringToKeyStrokes((String)keystrokes, (boolean)true);
                    this.shortcuts.add(new MultiKeyBinding(arr, "run-macro"));
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!qName.equals(MacrosStorage.E_ROOT)) {
                if (qName.equals(MacrosStorage.E_MACRO)) {
                    if (this.name != null) {
                        MacroDescription macro = new MacroDescription(this.name, this.code == null ? "" : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.code), this.description == null ? null : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.description), Collections.unmodifiableList(this.shortcuts));
                        this.macrosMap.put(this.name, macro);
                    }
                } else if (qName.equals(MacrosStorage.E_CODE)) {
                    if (this.text != null) {
                        this.code = this.cdataText.length() > 0 ? this.cdataText.toString() : this.text.toString();
                    }
                } else if (qName.equals(MacrosStorage.E_DESCRIPTION) && this.text != null) {
                    if (this.cdataText.length() > 0) {
                        this.description = this.cdataText.toString();
                    } else if (this.text.length() > 0) {
                        this.description = this.text.toString();
                    }
                }
            }
        }

        public void startCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = true;
            }
        }

        public void endCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = false;
            }
        }
    }

    private static abstract class MacrosReader
    extends StorageReader<String, MacroDescription> {
        protected MacrosReader(FileObject f, String mimePath) {
            super(f, mimePath);
        }

        public abstract Map<String, MacroDescription> getAdded();

        public abstract Set<String> getRemoved();
    }
}

