/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.model;

import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.ProducerDeserializer;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.model.XMLComponentDescriptor;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class XMLComponentProducer
extends ComponentProducer {
    private static final Lookup.Result<? extends ProducerDeserializer> result = Lookup.getDefault().lookupResult(ProducerDeserializer.class);
    public static final String COMPONENT_PRODUCER_NODE = "ComponentProducer";
    public static final String VERSION_ATTR = "version";
    public static final String PRODUCERID_ATTR = "producerID";
    public static final String MAIN_COMPONENT_TYPEID_ATTR = "mainComponentTypeID";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String TOOLTIP_ATTR = "toolTip";
    public static final String SMALL_ICON_ATTR = "smallIcon";
    public static final String LARGE_ICON_ATTR = "largeIcon";
    public static final String PREFERRED_CATEGORYID_ATTR = "preferredCategoryID";
    public static final String VERSION_VALUE_1 = "1";

    protected XMLComponentProducer(String producerID, TypeID typeID, PaletteDescriptor paletteDescriptor) {
        super(producerID, typeID, paletteDescriptor);
    }

    public static XMLComponentProducer deserialize(String projectType, Document document) {
        Node rootNode = document.getFirstChild();
        if (!COMPONENT_PRODUCER_NODE.equals(rootNode.getNodeName())) {
            Debug.warning("Invalid root node");
            return null;
        }
        String version = XMLComponentDescriptor.getAttributeValue(rootNode, VERSION_ATTR);
        if (!VERSION_VALUE_1.equals(version)) {
            Debug.warning("Invalid version", version);
            return null;
        }
        String producerID = XMLComponentDescriptor.getAttributeValue(rootNode, PRODUCERID_ATTR);
        if (producerID == null) {
            Debug.warning("Missing producerID attribute");
            return null;
        }
        String typeID = XMLComponentDescriptor.getAttributeValue(rootNode, MAIN_COMPONENT_TYPEID_ATTR);
        if (typeID == null) {
            Debug.warning("Missing mainComponentTypeID attribute");
            return null;
        }
        PaletteDescriptor paletteDescriptor = new PaletteDescriptor(XMLComponentDescriptor.getAttributeValue(rootNode, PREFERRED_CATEGORYID_ATTR), XMLComponentDescriptor.getAttributeValue(rootNode, DISPLAY_NAME_ATTR), XMLComponentDescriptor.getAttributeValue(rootNode, TOOLTIP_ATTR), XMLComponentDescriptor.getAttributeValue(rootNode, SMALL_ICON_ATTR), XMLComponentDescriptor.getAttributeValue(rootNode, LARGE_ICON_ATTR));
        return new XMLComponentProducer(producerID, TypeID.createFrom(typeID), paletteDescriptor);
    }

    @Override
    public ComponentProducer.Result postInitialize(DesignDocument document, DesignComponent mainComponent) {
        ComponentProducer producer;
        TypeID superTypeID;
        ComponentDescriptor descriptor = document.getDescriptorRegistry().getComponentDescriptor(this.getMainComponentTypeID());
        if (descriptor != null && (superTypeID = descriptor.getTypeDescriptor().getSuperType()) != null && (producer = DocumentSupport.getComponentProducer(document, superTypeID.toString())) != null) {
            producer.postInitialize(document, mainComponent);
        }
        return super.postInitialize(document, mainComponent);
    }

    @Override
    public Boolean checkValidity(final DesignDocument document, boolean useCachedValue) {
        if (!this.checkValidityByDeserializers(document)) {
            return false;
        }
        final ComponentProducer[] producers = new ComponentProducer[1];
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                TypeID superTypeID;
                ComponentDescriptor descriptor = document.getDescriptorRegistry().getComponentDescriptor(XMLComponentProducer.this.getMainComponentTypeID());
                if (descriptor != null && (superTypeID = descriptor.getTypeDescriptor().getSuperType()) != null) {
                    producers[0] = DocumentSupport.getComponentProducer(document, superTypeID.toString());
                }
            }
        });
        if (producers[0] == null) {
            return true;
        }
        return producers[0].checkValidity(document, useCachedValue);
    }

    private boolean checkValidityByDeserializers(DesignDocument document) {
        String projectType = document.getDocumentInterface().getProjectType();
        for (ProducerDeserializer deserializer : result.allInstances()) {
            if (!projectType.equals(deserializer.getProjectType()) || deserializer.checkValidity(document, this)) continue;
            return false;
        }
        return true;
    }
}

