/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionContext;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionItem;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionPresenter;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class AddAction
extends AbstractAction
implements ActionContext,
Presenter.Popup {
    public static final String DISPLAY_NAME = NbBundle.getMessage(AddAction.class, (String)"Name_AddAction");
    private static Map<Collection<TypeID>, AddAction> instances = new HashMap<Collection<TypeID>, AddAction>();
    private JMenu menu;
    private WeakReference<DesignComponent> component;
    private boolean enabled;
    private TypeID[] filtersTypeID = new TypeID[0];

    public static final AddAction getInstance(TypeID ... filters) {
        List<TypeID> filtersList = Arrays.asList(filters);
        for (Collection<TypeID> key : instances.keySet()) {
            if (key.size() != filtersList.size() || !key.containsAll(filtersList)) continue;
            return instances.get(key);
        }
        instances.put(filtersList, new AddAction(filters));
        return instances.get(filtersList);
    }

    private AddAction(TypeID ... filtersTypeID) {
        this.putValue("Name", DISPLAY_NAME);
        if (filtersTypeID != null) {
            this.filtersTypeID = filtersTypeID;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenu getPopupPresenter() {
        return this.getMenu();
    }

    private JMenu getMenu() {
        if (this.component == null || this.component.get() == null) {
            throw new IllegalStateException("This action has to be attached to exisitng DesignComponent");
        }
        if (this.menu == null) {
            this.menu = new JMenu(DISPLAY_NAME);
        } else {
            this.menu.removeAll();
        }
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                AddAction.this.menu.setEnabled(AddAction.this.isEnabled());
            }
        });
        for (Action addAction : ActionsSupport.createAddActionArray((DesignComponent)this.component.get(), this.filtersTypeID)) {
            if (addAction.getValue("#SEPARATOR#") == null) {
                this.menu.add(addAction);
                continue;
            }
            this.menu.add(this.getSeparator((String)addAction.getValue("Name")));
        }
        return this.menu;
    }

    @Override
    public boolean isEnabled() {
        if (this.component == null || this.component.get() == null) {
            throw new IllegalStateException("This action has to be attache to DesignComponent, component can not be null");
        }
        if (((DesignComponent)this.component.get()).getDocument().getSelectedComponents().size() > 1 || ((DesignComponent)this.component.get()).getPresenters(AddActionPresenter.class).isEmpty()) {
            this.enabled = false;
        }
        for (AddActionPresenter presenter : ((DesignComponent)this.component.get()).getPresenters(AddActionPresenter.class)) {
            AddActionItem[] addActionItems = presenter.getAddActionItems();
            if (addActionItems == null || addActionItems.length <= 0) continue;
            this.enabled = true;
        }
        return this.enabled;
    }

    private JComponent getSeparator(String name) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(name);
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "Center");
        return panel;
    }

    @Override
    public void setComponent(DesignComponent component) {
        this.component = new WeakReference<DesignComponent>(component);
    }
}

