/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.openide.ErrorManager;

public class Debug {
    private static int stackTraceFriendIndex = Integer.MIN_VALUE;

    private Debug() {
    }

    private static void init() {
        if (stackTraceFriendIndex >= 0) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int a = 0; a < stackTrace.length; ++a) {
            StackTraceElement stackTraceElement = stackTrace[a];
            if (!Debug.class.getName().equals(stackTraceElement.getClassName()) || !"init".equals(stackTraceElement.getMethodName())) continue;
            stackTraceFriendIndex = a + 2;
            return;
        }
    }

    public static void warning(Object ... messages) {
        Debug.init();
        if (messages.length == 1 && messages[0] instanceof Throwable) {
            ((Throwable)messages[0]).printStackTrace(System.err);
            return;
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("WARNING: ").append(stack[stackTraceFriendIndex - 1]).append('\n');
        if (stackTraceFriendIndex < stack.length) {
            sb.append("         ").append(stack[stackTraceFriendIndex]).append('\n');
        }
        for (Object message : messages) {
            sb.append(" | ").append(message);
        }
        System.err.println(sb.toString());
    }

    public static boolean isFriend(Class clazz) {
        Debug.init();
        StackTraceElement whoCalled = Thread.currentThread().getStackTrace()[stackTraceFriendIndex];
        return whoCalled.getClassName().equals(clazz.getName());
    }

    public static boolean isFriend(Class clazz, String method) {
        Debug.init();
        StackTraceElement whoCalled = Thread.currentThread().getStackTrace()[stackTraceFriendIndex];
        return whoCalled.getClassName().equals(clazz.getName()) && whoCalled.getMethodName().equals(method);
    }

    public static boolean isFriend(String className, String method) {
        Debug.init();
        StackTraceElement whoCalled = Thread.currentThread().getStackTrace()[stackTraceFriendIndex];
        return whoCalled.getClassName().equals(className) && whoCalled.getMethodName().equals(method);
    }

    public static RuntimeException error(Object ... messages) {
        Throwable exception;
        Debug.init();
        if (messages.length == 1 && messages[0] instanceof Throwable) {
            exception = (Throwable)messages[0];
        } else {
            StringBuilder sb = new StringBuilder();
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            sb.append("ERROR: ").append(stack[stackTraceFriendIndex - 1]).append('\n');
            if (stackTraceFriendIndex < stack.length) {
                sb.append("       ").append(stack[stackTraceFriendIndex]).append('\n');
            }
            for (Object message : messages) {
                sb.append(" | ").append(message);
            }
            exception = new RuntimeException(sb.toString());
        }
        ErrorManager.getDefault().notify(65536, exception);
        throw new RuntimeException(exception);
    }

    public static RuntimeException illegalState(Object ... messages) {
        Throwable exception;
        Debug.init();
        if (messages.length == 1 && messages[0] instanceof Throwable) {
            exception = (Throwable)messages[0];
        } else {
            StringBuilder sb = new StringBuilder("ILLEGAL STATE: ");
            sb.append(Thread.currentThread().getStackTrace()[stackTraceFriendIndex - 1]);
            sb.append('\n');
            for (Object message : messages) {
                sb.append(" | ").append(message);
            }
            exception = new IllegalStateException(sb.toString());
        }
        ErrorManager.getDefault().notify(65536, exception);
        throw new RuntimeException(exception);
    }

    public static RuntimeException illegalArgument(Object ... messages) {
        Throwable exception;
        Debug.init();
        if (messages.length == 1 && messages[0] instanceof Throwable) {
            exception = (Throwable)messages[0];
        } else {
            StringBuilder sb = new StringBuilder("ILLEGAL ARGUMENT: ");
            sb.append(Thread.currentThread().getStackTrace()[stackTraceFriendIndex - 1]);
            sb.append('\n');
            for (Object message : messages) {
                sb.append(" | ").append(message);
            }
            exception = new IllegalArgumentException(sb.toString());
        }
        ErrorManager.getDefault().notify(65536, exception);
        throw new RuntimeException(exception);
    }

    public static void dumpDocument(DesignDocument document) {
        assert (document != null);
        Debug.dumpComponent(document.getRootComponent());
    }

    public static void dumpComponent(DesignComponent component) {
        if (component == null) {
            System.out.println("No component to dump");
            return;
        }
        System.out.println("Dumping component: " + component.getComponentID());
        component.dumpComponent("");
    }

    public static void collectAllComponentReferences(PropertyValue propertyValue, Collection<DesignComponent> references) {
        propertyValue.collectAllComponentReferences(references);
    }

    public static boolean isComponentReferencedInRootTree(DesignComponent referenceComponent) {
        assert (referenceComponent != null);
        return Debug.isComponentReferencedInRootTree(referenceComponent.getDocument().getRootComponent(), referenceComponent);
    }

    private static boolean isComponentReferencedInRootTree(DesignComponent treeComponent, DesignComponent referenceComponent) {
        ArrayList<DesignComponent> referenced = new ArrayList<DesignComponent>();
        ComponentDescriptor descriptor = treeComponent.getComponentDescriptor();
        if (descriptor != null) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                PropertyValue propertyValue = treeComponent.readProperty(propertyDescriptor.getName());
                referenced.clear();
                Debug.collectAllComponentReferences(propertyValue, referenced);
                if (!referenced.contains(referenceComponent)) continue;
                return true;
            }
        }
        for (DesignComponent child : treeComponent.getComponents()) {
            if (!Debug.isComponentReferencedInRootTree(child, referenceComponent)) continue;
            return true;
        }
        return false;
    }
}

