/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class DictionaryInstallerPanel
extends JPanel {
    public JButton bBrowse;
    public JComboBox cEncoding;
    public JLabel encoding;
    public JLabel file;
    public JPanel jPanel1;
    public JPanel jPanel2;
    public JLabel locale;
    public JTextField tDictionary;
    public JTextField tLocale;
    private static String homedir = System.getProperty("netbeans.home");
    private static String userdir = System.getProperty("netbeans.user");
    private static boolean availHomedir = new File(homedir).canWrite();
    private static boolean availUserdir = new File(userdir).canWrite();
    private static final int BUFFER_LENGTH = 65536;

    public DictionaryInstallerPanel() {
        this.initComponents();
        this.initValues();
    }

    private void initComponents() {
        this.file = new JLabel();
        this.tDictionary = new JTextField();
        this.bBrowse = new JButton();
        this.encoding = new JLabel();
        this.cEncoding = new JComboBox();
        this.locale = new JLabel();
        this.jPanel1 = new JPanel();
        this.tLocale = new JTextField();
        this.jPanel2 = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        this.setLayout(new GridBagLayout());
        this.file.setLabelFor(this.tDictionary);
        Mnemonics.setLocalizedText((JLabel)this.file, (String)NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"DictionaryInstallerPanel.file.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.file, gridBagConstraints);
        this.tDictionary.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tDictionary, gridBagConstraints);
        this.tDictionary.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"tDictionary_ACSN"));
        this.tDictionary.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"tDictionary_ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"bBrowse"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DictionaryInstallerPanel.this.bBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"bBrowse_ACSN"));
        this.bBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"bBrowse_ACSD"));
        this.encoding.setLabelFor(this.cEncoding);
        Mnemonics.setLocalizedText((JLabel)this.encoding, (String)NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"DictionaryInstallerPanel.encoding.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.encoding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cEncoding, gridBagConstraints);
        this.cEncoding.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"cEncoding_ACSN"));
        this.cEncoding.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"cEncoding_ACSD"));
        this.locale.setLabelFor(this.tLocale);
        Mnemonics.setLocalizedText((JLabel)this.locale, (String)NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"DictionaryInstallerPanel.locale.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.locale, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.tLocale.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.tLocale, gridBagConstraints);
        this.tLocale.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"tLocale_ACSN"));
        this.tLocale.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DictionaryInstallerPanel.class, (String)"tLocale_ACSD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void bBrowseActionPerformed(ActionEvent evt) {
        JFileChooser filechooser = new JFileChooser(this.tDictionary.getText());
        int ret = filechooser.showOpenDialog(null);
        if (ret == 0) {
            this.tDictionary.setText(filechooser.getSelectedFile().getAbsolutePath());
        }
    }

    public static String getMessage(String key) {
        return NbBundle.getMessage(DictionaryInstallerPanel.class, (String)key);
    }

    public final void initValues() {
        this.tDictionary.setText(System.getProperty("user.home"));
        Set<String> set = Charset.availableCharsets().keySet();
        this.cEncoding.setModel(new DefaultComboBoxModel<String>(set.toArray(new String[set.size()])));
        this.cEncoding.setSelectedItem("ISO-8859-1");
        this.tLocale.setText("");
    }

    private static File dictionaryFile(String loc, boolean shared) {
        String filename = shared ? homedir : userdir;
        filename = filename + File.separator + "modules" + File.separator + "dict";
        filename = filename + File.separator + "dictionary";
        if (loc != null && !"".equals(loc)) {
            filename = filename + "_" + loc;
        }
        return new File(filename + ".txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInstall(DictionaryDescription description) {
        InputStreamReader input = null;
        OutputStreamWriter output = null;
        try {
            boolean shared;
            if (description.rAllUsers) {
                shared = true;
            } else if (description.rCurrentUser) {
                shared = false;
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DictionaryInstallerPanel.getMessage("MSG_NoInstallDirectoryAvailable"), 0));
                return;
            }
            File file = DictionaryInstallerPanel.dictionaryFile(description.targetLocale, shared);
            file.getParentFile().mkdirs();
            input = new InputStreamReader((InputStream)new FileInputStream(description.dictionaryFile), description.fileEncoding);
            output = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            char[] buffer = new char[65536];
            int len = 65536;
            do {
                len = input.read(buffer);
                output.write(buffer, 0, len);
            } while (len == 65536);
            StatusDisplayer.getDefault().setStatusText(DictionaryInstallerPanel.getMessage("MSG_DictionaryWasInstalled"));
        }
        catch (FileNotFoundException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DictionaryInstallerPanel.getMessage("MSG_InputFileNotFound"), 0));
        }
        catch (UnsupportedEncodingException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DictionaryInstallerPanel.getMessage("MSG_UnsupportedEncoding"), 0));
        }
        catch (IOException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)DictionaryInstallerPanel.getMessage("MSG_IOErrorDuringInstallation"), 0));
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public DictionaryDescription createDescription() {
        return new DictionaryDescription(false, true, this.tDictionary.getText(), (String)this.cEncoding.getSelectedItem(), this.tLocale.getText());
    }

    public static void removeDictionary(Locale remove) {
        File toRemove = DictionaryInstallerPanel.dictionaryFile(remove.toString(), false);
        toRemove.delete();
        toRemove = DictionaryInstallerPanel.dictionaryFile(remove.toString(), true);
        toRemove.delete();
    }

    public static class DictionaryDescription {
        private boolean rAllUsers;
        private boolean rCurrentUser;
        private String dictionaryFile;
        private String fileEncoding;
        private String targetLocale;

        public DictionaryDescription(boolean rAllUsers, boolean rCurrentUser, String dictionaryFile, String fileEncoding, String targetLocale) {
            this.rAllUsers = rAllUsers;
            this.rCurrentUser = rCurrentUser;
            this.dictionaryFile = dictionaryFile;
            this.fileEncoding = fileEncoding;
            this.targetLocale = targetLocale;
        }

        public Locale getLocale() {
            return new Locale(this.targetLocale);
        }
    }
}

