/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints.customizers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ConditionsPanel
extends JPanel {
    private final CndBreakpoint breakpoint;
    private final JTextComponent conditionPane;
    private final JScrollPane conditionSP;
    private JCheckBox cbCondition;
    private JCheckBox cbSkipCount;
    private JPanel panelHitCountFilter;
    private JTextField tfSkipCount;

    public ConditionsPanel(CndBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
        this.initComponents();
        FileObject file = EditorContextDispatcher.getDefault().getMostRecentFile();
        int line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
        String mimeType = file != null ? file.getMIMEType() : "text/plain";
        JComponent[] editorComponents = Utilities.createSingleLineEditor((String)mimeType);
        this.conditionPane = (JTextComponent)editorComponents[1];
        if (file != null && line >= 0) {
            DialogBinding.bindComponentToFile((FileObject)file, (int)line, (int)0, (int)0, (JTextComponent)this.conditionPane);
        }
        this.conditionSP = (JScrollPane)editorComponents[0];
        this.conditionSP.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.conditionSP, gridBagConstraints);
        this.setCondition(breakpoint.getCondition());
        this.setHitCount(breakpoint.getSkipCount());
        this.conditionPane.setText(breakpoint.getCondition());
    }

    public void ok() {
        if (this.cbCondition.isSelected()) {
            this.breakpoint.setCondition(this.conditionPane.getText());
        } else {
            this.breakpoint.setCondition("");
        }
        if (this.cbSkipCount.isSelected()) {
            try {
                this.breakpoint.setSkipCount(Integer.valueOf(this.tfSkipCount.getText()));
            }
            catch (Exception ex) {
                this.breakpoint.setSkipCount(0);
            }
        } else {
            this.breakpoint.setSkipCount(0);
        }
    }

    public void showCondition(boolean show) {
        this.cbCondition.setVisible(show);
        if (show) {
            this.cbConditionActionPerformed(null);
        } else {
            this.conditionSP.setVisible(show);
        }
    }

    public final void setCondition(String condition) {
        this.conditionPane.setText(condition);
        this.cbCondition.setSelected(condition.length() > 0);
        this.cbConditionActionPerformed(null);
    }

    public final void setHitCount(int hitCount) {
        if (hitCount != 0) {
            this.cbSkipCount.setSelected(true);
            this.tfSkipCount.setText(Integer.toString(hitCount));
        } else {
            this.cbSkipCount.setSelected(false);
            this.tfSkipCount.setText("");
        }
        this.cbSkipCountActionPerformed(null);
    }

    public String getCondition() {
        if (this.cbCondition.isSelected()) {
            return this.conditionPane.getText().trim();
        }
        return "";
    }

    public int getHitCount() {
        if (!this.cbSkipCount.isSelected()) {
            return 0;
        }
        String hcfStr = this.tfSkipCount.getText().trim();
        try {
            return Integer.parseInt(hcfStr);
        }
        catch (NumberFormatException nfex) {
            return 0;
        }
    }

    public String valiadateMsg() {
        String hcfStr = this.tfSkipCount.getText().trim();
        if (this.cbSkipCount.isSelected()) {
            if (hcfStr.length() > 0) {
                int hitCountFilter;
                try {
                    hitCountFilter = Integer.parseInt(hcfStr);
                }
                catch (NumberFormatException e) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_Bad_Hit_Count_Filter_Spec", (Object)hcfStr);
                }
                if (hitCountFilter <= 0) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_NonPositive_Hit_Count_Filter_Spec");
                }
            } else {
                return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Hit_Count_Filter_Spec");
            }
        }
        if (this.cbCondition.isSelected() && this.conditionPane.getText().trim().length() == 0) {
            return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Condition_Spec");
        }
        return null;
    }

    private void initComponents() {
        this.cbCondition = new JCheckBox();
        this.panelHitCountFilter = new JPanel();
        this.cbSkipCount = new JCheckBox();
        this.tfSkipCount = new JTextField();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ConditionsPanel.class, (String)"L_Conditions_Breakpoint_BorderTitle")));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbCondition, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"L_cbCondition"));
        this.cbCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TT_cbCondition"));
        this.cbCondition.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbCondition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionsPanel.this.cbConditionActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbCondition, gridBagConstraints);
        this.panelHitCountFilter.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipCount, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"L_SkipCount"));
        this.cbSkipCount.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TT_SkiptCount"));
        this.cbSkipCount.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSkipCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionsPanel.this.cbSkipCountActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.cbSkipCount, gridBagConstraints);
        this.tfSkipCount.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TT_SkipCount"));
        this.tfSkipCount.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.tfSkipCount, gridBagConstraints);
        this.tfSkipCount.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_HitCountTF"));
        this.tfSkipCount.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_HitCountTF"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelHitCountFilter, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"L_Conditions_Breakpoint_BorderTitle"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_Conditions"));
    }

    private void cbSkipCountActionPerformed(ActionEvent evt) {
        boolean isSelected = this.cbSkipCount.isSelected();
        this.tfSkipCount.setEnabled(isSelected);
        if (isSelected) {
            this.tfSkipCount.requestFocusInWindow();
        }
    }

    private void cbConditionActionPerformed(ActionEvent evt) {
        boolean isSelected = this.cbCondition.isSelected();
        if (isSelected) {
            this.conditionPane.setEnabled(true);
            this.conditionPane.requestFocusInWindow();
        } else {
            this.conditionPane.setEnabled(false);
        }
        this.revalidate();
        this.repaint();
    }
}

