/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends CndBreakpoint {
    public static LineBreakpoint create(String url, int lineNumber) {
        LineBreakpointComparable b = new LineBreakpointComparable(url);
        b.setLineNumber(lineNumber);
        b.setPrintText(NbBundle.getBundle(LineBreakpoint.class).getString("CTL_Line_Breakpoint_Print_Text"));
        return b;
    }

    public static LineBreakpoint create() {
        return new LineBreakpointComparable();
    }

    public String toString() {
        return "LineBreakpoint " + this.getURL() + " : " + this.getLineNumber();
    }

    private static class LineBreakpointComparable
    extends LineBreakpoint
    implements Comparable,
    FileChangeListener,
    ChangeListener {
        private FileObject fo;

        private LineBreakpointComparable() {
        }

        private LineBreakpointComparable(String url) {
            this.setURL(url);
            try {
                this.fo = URLMapper.findFileObject((URL)new URL(this.getURL()));
                if (this.fo != null) {
                    this.fo.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.fo));
                }
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public int compareTo(Object o) {
            if (o instanceof LineBreakpointComparable) {
                LineBreakpointComparable lbthis = this;
                LineBreakpoint lb = (LineBreakpoint)((Object)o);
                int uc = lbthis.getURL().compareTo(lb.getURL());
                if (uc != 0) {
                    return uc;
                }
                return lbthis.getLineNumber() - lb.getLineNumber();
            }
            return -1;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this);
            this.fo = null;
        }

        public void fileRenamed(FileRenameEvent fe) {
            try {
                this.setURL(((FileObject)fe.getSource()).getURL().toString());
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        public void stateChanged(ChangeEvent chev) {
            Object source = chev.getSource();
            if (!(source instanceof Breakpoint.VALIDITY)) {
                throw new UnsupportedOperationException(chev.toString());
            }
            this.setValidity((Breakpoint.VALIDITY)source, chev.toString());
        }
    }
}

