/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.support;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.openide.util.Exceptions;

public final class ValidateableSupport<T> {
    private final Validateable<T> validatable;
    private ValidationStatus currentStatus;

    public ValidateableSupport(Validateable<T> validatable) {
        this.validatable = validatable;
        this.currentStatus = validatable.getValidationStatus();
    }

    public Future<ValidationStatus> asyncValidate(final T target, final boolean performRequiredActions) {
        Future task = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

            @Override
            public ValidationStatus call() throws Exception {
                return ValidateableSupport.this.syncValidate(target, performRequiredActions);
            }
        }, (String)("ValidateableSupport asyncValidate" + this.validatable + " validation"));
        return task;
    }

    public ValidationStatus syncValidate(final T target, boolean performRequiredActions) {
        boolean willReiterate = true;
        while (willReiterate) {
            willReiterate = false;
            try {
                boolean thisValidatableStateChaged;
                Future task = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                    @Override
                    public ValidationStatus call() throws Exception {
                        return ValidateableSupport.this.validatable.validate(target);
                    }
                }, (String)(this.validatable + " validation"));
                ValidationStatus vNewStatus = (ValidationStatus)task.get();
                boolean bl = thisValidatableStateChaged = !vNewStatus.equals(this.currentStatus);
                if (!performRequiredActions) continue;
                if (!vNewStatus.isKnown()) {
                    Collection<AsynchronousAction> actions = vNewStatus.getRequiredActions();
                    if (actions != null) {
                        for (AsynchronousAction a : actions) {
                            try {
                                a.invoke();
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    boolean bl2 = thisValidatableStateChaged = !(vNewStatus = (ValidationStatus)(task = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                        @Override
                        public ValidationStatus call() throws Exception {
                            return ValidateableSupport.this.validatable.validate(target);
                        }
                    }, (String)("ValidateableSupport syncValidate" + this.validatable + " validation"))).get()).equals(this.currentStatus);
                }
                if (vNewStatus.isKnown() || !thisValidatableStateChaged) continue;
                this.currentStatus = vNewStatus;
                willReiterate = true;
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.currentStatus;
    }
}

