/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.modules.csl.core.GsfDataNode;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.CloneableOpenSupport;

public class GsfDataObject
extends MultiDataObject {
    private static Language templateLanguage;
    private GenericEditorSupport jes;
    private final Language language;

    public GsfDataObject(FileObject pf, MultiFileLoader loader, Language language) throws DataObjectExistsException {
        super(pf, loader);
        if (language == null) {
            language = templateLanguage;
        }
        this.language = language;
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                GsfDataObject.this.createEditorSupport().saveAs(folder, fileName);
            }
        }});
        this.getCookieSet().add((Node.Cookie)this.createEditorSupport());
    }

    public Node createNodeDelegate() {
        return new GsfDataNode(this, this.language);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        return (T)this.getCookieSet().getCookie(type);
    }

    protected DataObject handleCopyRename(DataFolder df, String name, String ext) throws IOException {
        FileObject fo = this.getPrimaryEntry().copyRename(df.getPrimaryFile(), name, ext);
        DataObject dob = DataObject.find((FileObject)fo);
        return dob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        if (name == null && this.language != null && this.language.getGsfLanguage().getPreferredExtension() != null) {
            name = FileUtil.findFreeFileName((FileObject)df.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.language.getGsfLanguage().getPreferredExtension());
        }
        try {
            templateLanguage = this.language;
            DataObject retValue = super.handleCreateFromTemplate(df, name);
            FileObject fo = retValue.getPrimaryFile();
            assert (fo != null);
            DataObject dataObject = retValue;
            return dataObject;
        }
        finally {
            templateLanguage = null;
        }
    }

    private synchronized GenericEditorSupport createEditorSupport() {
        if (this.jes == null) {
            this.jes = new GenericEditorSupport(this, this.language);
        }
        return this.jes;
    }

    public static final class GenericEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie,
    EditorCookie.Observable {
        private Language language;

        public GenericEditorSupport(GsfDataObject dataObject, Language language) {
            super((DataObject)dataObject, (CloneableEditorSupport.Env)new Environment(dataObject));
            this.setMIMEType(language.getMimeType());
            this.language = language;
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((Environment)this.env).addSaveCookie();
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((Environment)this.env).removeSaveCookie();
        }

        public boolean close(boolean ask) {
            return super.close(ask);
        }

        protected StyledDocument createStyledDocument(EditorKit kit) {
            StyledDocument doc = super.createStyledDocument(kit);
            InputAttributes attributes = new InputAttributes();
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)doc);
            attributes.setValue(this.language.getGsfLanguage().getLexerLanguage(), FileObject.class, (Object)fileObject, false);
            doc.putProperty(InputAttributes.class, attributes);
            return doc;
        }

        private static class Environment
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = -1L;
            private transient SaveSupport saveCookie = null;

            public Environment(GsfDataObject obj) {
                super((DataObject)obj);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableEditorSupport)((GsfDataObject)this.getDataObject()).getCookie(EditorCookie.class);
            }

            public void addSaveCookie() {
                GsfDataObject javaData = (GsfDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) == null) {
                    if (this.saveCookie == null) {
                        this.saveCookie = new SaveSupport();
                    }
                    javaData.getCookieSet().add((Node.Cookie)this.saveCookie);
                    javaData.setModified(true);
                }
            }

            public void removeSaveCookie() {
                GsfDataObject javaData = (GsfDataObject)this.getDataObject();
                if (javaData.getCookie(SaveCookie.class) != null) {
                    javaData.getCookieSet().remove((Node.Cookie)this.saveCookie);
                    javaData.setModified(false);
                }
            }

            private class SaveSupport
            implements SaveCookie {
                private SaveSupport() {
                }

                public void save() throws IOException {
                    ((GenericEditorSupport)Environment.this.findCloneableOpenSupport()).saveDocument();
                    Environment.this.getDataObject().setModified(false);
                }
            }
        }
    }
}

