/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.LazyProjectInitializing;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;

final class LazyProject
implements Project,
ProjectInformation,
SearchInfo,
LogicalViewProvider,
RecommendedTemplates {
    URL url;
    String displayName;
    ExtIcon icon;

    public LazyProject(URL url, String displayName, ExtIcon icon) {
        this.url = url;
        this.displayName = displayName;
        this.icon = icon;
    }

    public FileObject getProjectDirectory() {
        FileObject fo = URLMapper.findFileObject((URL)this.url);
        if (fo == null) {
            OpenProjectList.LOGGER.warning("Project dir with " + this.url + " not found!");
            fo = FileUtil.createMemoryFileSystem().getRoot();
        }
        return fo;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public String getName() {
        return this.displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon.getIcon();
    }

    public Project getProject() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public boolean canSearch() {
        return false;
    }

    public Iterator<DataObject> objectsToSearch() {
        return Collections.emptyList().iterator();
    }

    public Node createLogicalView() {
        return new ProjNode(Lookups.singleton((Object)this));
    }

    public Node findPath(Node root, Object target) {
        return null;
    }

    public String[] getRecommendedTypes() {
        return new String[]{"simple-files"};
    }

    private final class ProjCh
    extends Children.Array {
        private ProjCh() {
        }

        protected Collection<Node> initCollection() {
            AbstractNode n = new AbstractNode(Children.LEAF);
            n.setName("init");
            n.setDisplayName(NbBundle.getMessage(ProjCh.class, (String)"MSG_ProjChInit"));
            n.setIconBaseWithExtension("org/netbeans/modules/project/ui/resources/wait.gif");
            return Collections.singletonList(n);
        }

        protected void addNotify() {
            super.addNotify();
            OpenProjectList.preferredProject(LazyProject.this);
        }
    }

    private final class ProjNode
    extends AbstractNode {
        public ProjNode(Lookup lookup) {
            super((Children)new ProjCh(), lookup);
            this.setName(LazyProject.this.url.toExternalForm());
            this.setDisplayName(LazyProject.this.displayName);
        }

        public Image getIcon(int type) {
            return ImageUtilities.icon2Image((Icon)LazyProject.this.icon.getIcon());
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action getPreferredAction() {
            OpenProjectList.preferredProject(LazyProject.this);
            return super.getPreferredAction();
        }

        public boolean hasCustomizer() {
            return false;
        }

        public Action[] getActions(boolean context) {
            OpenProjectList.preferredProject(LazyProject.this);
            return new Action[]{SystemAction.get(LazyProjectInitializing.class), CommonProjectActions.closeProjectAction()};
        }
    }
}

