/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FolderEntry;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SourceFilesPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SourceFoldersDescriptorPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SourceFoldersPanel
extends JPanel
implements HelpCtx.Provider {
    private SourceFoldersDescriptorPanel sourceFoldersDescriptorPanel;
    private SourceFilesPanel sourceFilesPanel;
    private boolean firstTime = true;
    private JPanel headerFoldersOuterPanel;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;

    public SourceFoldersPanel(SourceFoldersDescriptorPanel sourceFoldersDescriptorPanel) {
        this.initComponents();
        this.sourceFoldersDescriptorPanel = sourceFoldersDescriptorPanel;
        this.sourceFilesPanel = new SourceFilesPanel(sourceFoldersDescriptorPanel, true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.headerFoldersOuterPanel.add((Component)this.sourceFilesPanel, gridBagConstraints);
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.getAccessibleContext().setAccessibleDescription(SourceFoldersPanel.getString("SourceFoldersPanel_AD"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SourceFoldersPanel.class);
    }

    void read(WizardDescriptor settings) {
        if (this.firstTime) {
            String workingdir = (String)settings.getProperty("buildCommandWorkingDirTextField");
            File wd = new File(workingdir);
            this.sourceFilesPanel.getSourceListData().add(new FolderEntry(wd, wd.getPath()));
            this.sourceFilesPanel.setFoldersFilter("^(nbproject|build|test|tests)$");
            this.firstTime = false;
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("sourceFolders", this.sourceFilesPanel.getSourceListData().iterator());
        wizardDescriptor.putProperty("sourceFoldersList", new ArrayList<FolderEntry>(this.sourceFilesPanel.getSourceListData()));
        if (this.sourceFilesPanel.getFoldersFilter().trim().length() == 0) {
            wizardDescriptor.putProperty("sourceFoldersFilter", (Object)"^$");
        } else {
            wizardDescriptor.putProperty("sourceFoldersFilter", (Object)this.sourceFilesPanel.getFoldersFilter());
        }
        wizardDescriptor.putProperty("testFolders", this.sourceFilesPanel.getTestListData().iterator());
        wizardDescriptor.putProperty("testFoldersList", new ArrayList<FolderEntry>(this.sourceFilesPanel.getTestListData()));
    }

    boolean valid(WizardDescriptor settings) {
        String regex = this.sourceFilesPanel.getFoldersFilter();
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            settings.putProperty("WizardPanel_errorMessage", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.headerFoldersOuterPanel = new JPanel();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(323, 223));
        this.setLayout(new GridBagLayout());
        this.headerFoldersOuterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.headerFoldersOuterPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.instructionsTextArea.setText(bundle.getString("SourceFilesInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.instructionsTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceFoldersPanel.class, (String)"SourceFoldersInfo_AN"));
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceFoldersPanel.class, (String)"SourceFoldersInfo_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    private static String getString(String s) {
        return NbBundle.getBundle(PanelProjectLocationVisual.class).getString(s);
    }
}

