/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class Item
implements NativeFileItem,
PropertyChangeListener {
    private final String path;
    private Folder folder;
    private File file = null;
    private DataObject lastDataObject = null;
    private static final SpiAccessor SPI_ACCESSOR = new SpiAccessor();

    public Item(String path) {
        this.path = path;
        this.folder = null;
    }

    private void rename(String newname, boolean nameWithoutExtension) {
        String oldname;
        if (newname == null || newname.length() == 0 || this.getFolder() == null) {
            return;
        }
        if (this.path.equals(newname)) {
            return;
        }
        int indexName = this.path.lastIndexOf(47);
        indexName = indexName < 0 ? 0 : ++indexName;
        int indexDot = this.path.lastIndexOf(46);
        if (indexDot < indexName || !nameWithoutExtension) {
            indexDot = -1;
        }
        if ((oldname = indexDot >= 0 ? this.path.substring(indexName, indexDot) : this.path.substring(indexName)).equals(newname)) {
            return;
        }
        String newPath = "";
        if (indexName > 0) {
            newPath = this.path.substring(0, indexName);
        }
        newPath = newPath + newname;
        if (indexDot >= 0) {
            newPath = newPath + this.path.substring(indexDot);
        }
        this.renameTo(newPath);
    }

    private void renameTo(String newPath) {
        Folder f = this.getFolder();
        String oldPath = this.getAbsPath();
        Item item = f.addItem(new Item(newPath));
        if (item != null && item.getFolder() != null) {
            if (item.getFolder().isProjectFiles()) {
                Item.copyItemConfigurations(this, item);
            }
            f.removeItem(this);
            f.renameItemAction(oldPath, item);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getSortName() {
        return this.getName();
    }

    public String getName() {
        return CndPathUtilitities.getBaseName((String)this.path);
    }

    public String getPath(boolean norm) {
        String pat = "./";
        if (norm && this.getPath().startsWith(pat)) {
            return this.getPath().substring(2);
        }
        return this.getPath();
    }

    public String getAbsPath() {
        String retPath = null;
        if (CndPathUtilitities.isPathAbsolute((String)this.getPath())) {
            retPath = this.getPath();
        } else if (this.getFolder() != null) {
            retPath = this.getFolder().getConfigurationDescriptor().getBaseDir() + '/' + this.getPath();
        }
        return retPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolder(Folder folder) {
        if (folder == null && this.file == null) {
            this.getCanonicalFile();
        }
        if (folder == null) {
            Item item = this;
            synchronized (item) {
                if (this.lastDataObject != null) {
                    this.lastDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                    this.lastDataObject = null;
                }
            }
        } else {
            this.folder = folder;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            boolean nameWithoutExtension = true;
            Object o = evt.getSource();
            if (o instanceof DataObject) {
                String fileName;
                String nodeName = ((DataObject)o).getName();
                FileObject fo = ((DataObject)o).getPrimaryFile();
                if (fo != null && nodeName.equals(fileName = fo.getNameExt())) {
                    nameWithoutExtension = false;
                }
            }
            this.rename((String)evt.getNewValue(), nameWithoutExtension);
        } else if (evt.getPropertyName().equals("valid")) {
            Folder containingFolder;
            if (!((Boolean)evt.getNewValue()).booleanValue() && (containingFolder = this.getFolder()) != null) {
                containingFolder.refresh(this);
            }
        } else if (evt.getPropertyName().equals("primaryFile") && this.getFolder() != null) {
            FileObject fo = (FileObject)evt.getNewValue();
            String newPath = FileUtil.toFile((FileObject)fo).getPath();
            if (!CndPathUtilitities.isPathAbsolute((String)this.getPath())) {
                newPath = CndPathUtilitities.toRelativePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)newPath);
            }
            newPath = CndPathUtilitities.normalize((String)newPath);
            this.renameTo(newPath);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public File getNormalizedFile() {
        String aPath = this.getAbsPath();
        if (aPath != null) {
            return CndFileUtils.normalizeFile((File)new File(aPath));
        }
        return this.file;
    }

    public File getFile() {
        return this.getNormalizedFile();
    }

    public File getCanonicalFile() {
        if (this.file == null) {
            try {
                this.file = new File(this.getAbsPath()).getCanonicalFile();
            }
            catch (IOException ioe) {
                this.file = CndFileUtils.normalizeFile((File)new File(this.getAbsPath()));
            }
        }
        return this.file;
    }

    public String getId() {
        return this.getPath();
    }

    public ItemConfiguration getItemConfiguration(Configuration configuration) {
        if (configuration != null) {
            return (ItemConfiguration)configuration.getAuxObject(this.getId());
        }
        return null;
    }

    public ItemConfiguration[] getItemConfigurations() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return new ItemConfiguration[0];
        }
        Configuration[] configurations = makeConfigurationDescriptor.getConfs().toArray();
        ItemConfiguration[] itemConfigurations = new ItemConfiguration[configurations.length];
        for (int i = 0; i < configurations.length; ++i) {
            itemConfigurations[i] = this.getItemConfiguration(configurations[i]);
        }
        return itemConfigurations;
    }

    public void copyConfigurations(Item src) {
        if (src.getFolder() == null) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = src.getFolder().getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
            ItemConfiguration srcItemConfiguration = src.getItemConfiguration(conf);
            ItemConfiguration dstItemConfiguration = this.getItemConfiguration(conf);
            if (srcItemConfiguration == null || dstItemConfiguration == null) continue;
            dstItemConfiguration.assignValues(srcItemConfiguration);
        }
    }

    private static void copyItemConfigurations(Item src, Item dst) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = src.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
                ItemConfiguration newConf = new ItemConfiguration(conf, dst);
                newConf.assignValues(src.getItemConfiguration(conf));
                conf.addAuxObject(newConf);
            }
        }
    }

    public FileObject getFileObject() {
        File curFile = this.getNormalizedFile();
        FileObject fo = FileUtil.toFileObject((File)curFile);
        if (fo == null) {
            fo = FileUtil.toFileObject((File)this.getCanonicalFile());
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getDataObject() {
        Item item = this;
        synchronized (item) {
            if (this.lastDataObject != null && this.lastDataObject.isValid()) {
                return this.lastDataObject;
            }
        }
        DataObject dataObject = null;
        FileObject fo = this.getFileObject();
        if (fo != null) {
            try {
                dataObject = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        Item item2 = this;
        synchronized (item2) {
            if (dataObject != this.lastDataObject) {
                if (this.lastDataObject != null) {
                    this.lastDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                if (dataObject != null) {
                    dataObject.addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.lastDataObject = dataObject;
            }
        }
        return dataObject;
    }

    public final String getMIMEType() {
        DataObject dataObject = this.getDataObject();
        FileObject fo = dataObject == null ? null : dataObject.getPrimaryFile();
        String mimeType = "";
        mimeType = fo == null ? MIMESupport.getFileMIMEType((File)this.getNormalizedFile()) : MIMESupport.getFileMIMEType((FileObject)fo);
        return mimeType;
    }

    public PredefinedToolKind getDefaultTool() {
        PredefinedToolKind tool;
        String mimeType = this.getMIMEType();
        if ("text/x-c".equals(mimeType)) {
            tool = PredefinedToolKind.CCompiler;
        } else if ("text/x-h".equals(mimeType)) {
            tool = PredefinedToolKind.CustomTool;
        } else if ("text/x-c++".equals(mimeType)) {
            tool = PredefinedToolKind.CCCompiler;
        } else if ("text/x-fortran".equals(mimeType)) {
            tool = PredefinedToolKind.FortranCompiler;
        } else if ("text/x-asm".equals(mimeType)) {
            FileObject fo;
            DataObject dataObject = this.getDataObject();
            FileObject fileObject = fo = dataObject == null ? null : dataObject.getPrimaryFile();
            tool = fo != null && "il".equals(fo.getExt()) ? PredefinedToolKind.CustomTool : PredefinedToolKind.Assembler;
        } else {
            tool = PredefinedToolKind.CustomTool;
        }
        return tool;
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        if (this.getFolder() == null) {
            return null;
        }
        return this.getFolder().getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return null;
        }
        return makeConfigurationDescriptor.getActiveConfiguration();
    }

    public NativeProject getNativeProject() {
        Project project;
        Folder curFolder = this.getFolder();
        if (curFolder != null && (project = curFolder.getProject()) != null) {
            return (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return null;
    }

    public List<String> getSystemIncludePaths() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            vec.addAll(compiler.getSystemIncludeDirectories());
        }
        return vec;
    }

    public List<String> getUserIncludePaths() {
        List<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            ArrayList<String> vec2 = new ArrayList<String>();
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            CCCCompilerConfiguration master = (CCCCompilerConfiguration)cccCompilerConfiguration.getMaster();
            while (master != null && cccCompilerConfiguration.getInheritIncludes().getValue()) {
                vec2.addAll(master.getIncludeDirectories().getValue());
                if (master.getInheritIncludes().getValue()) {
                    master = (CCCCompilerConfiguration)master.getMaster();
                    continue;
                }
                master = null;
            }
            vec2.addAll(cccCompilerConfiguration.getIncludeDirectories().getValue());
            Iterator iter = vec2.iterator();
            while (iter.hasNext()) {
                vec.add(CndPathUtilitities.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)((String)iter.next())));
            }
            vec = Item.SPI_ACCESSOR.getItemUserIncludePaths(vec, cccCompilerConfiguration, compiler, makeConfiguration);
        }
        return vec;
    }

    public List<String> getSystemMacroDefinitions() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            vec.addAll(compiler.getSystemPreprocessorSymbols());
        }
        return vec;
    }

    public List<String> getUserMacroDefinitions() {
        List<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            CCCCompilerConfiguration master = (CCCCompilerConfiguration)cccCompilerConfiguration.getMaster();
            while (master != null && cccCompilerConfiguration.getInheritPreprocessor().getValue()) {
                vec.addAll(master.getPreprocessorConfiguration().getValue());
                if (master.getInheritIncludes().getValue()) {
                    master = (CCCCompilerConfiguration)master.getMaster();
                    continue;
                }
                master = null;
            }
            vec.addAll(cccCompilerConfiguration.getPreprocessorConfiguration().getValue());
            vec = Item.SPI_ACCESSOR.getItemUserMacros(vec, cccCompilerConfiguration, compiler, makeConfiguration);
        }
        return vec;
    }

    public boolean hasHeaderOrSourceExtension(boolean cFiles, boolean ccFiles) {
        String mimeType = this.getMIMEType();
        return "text/x-h".equals(mimeType) || ccFiles && "text/x-c++".equals(mimeType) || cFiles && "text/x-c".equals(mimeType);
    }

    public NativeFileItem.Language getLanguage() {
        PredefinedToolKind tool;
        ItemConfiguration itemConfiguration = null;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            itemConfiguration = this.getItemConfiguration(makeConfiguration);
        }
        NativeFileItem.Language language = (tool = itemConfiguration != null ? itemConfiguration.getTool() : this.getDefaultTool()) == PredefinedToolKind.CCompiler ? NativeFileItem.Language.C : (tool == PredefinedToolKind.CCCompiler ? NativeFileItem.Language.CPP : (tool == PredefinedToolKind.FortranCompiler ? NativeFileItem.Language.FORTRAN : (this.hasHeaderOrSourceExtension(true, true) ? NativeFileItem.Language.C_HEADER : NativeFileItem.Language.OTHER)));
        return language;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor() {
        return NativeFileItem.LanguageFlavor.GENERIC;
    }

    public boolean isExcluded() {
        ItemConfiguration itemConfiguration = this.getItemConfiguration(this.getMakeConfiguration());
        if (itemConfiguration != null) {
            return itemConfiguration.getExcluded().getValue();
        }
        return true;
    }

    public String toString() {
        return this.path;
    }

    private static final class SpiAccessor {
        private UserOptionsProvider provider;

        private synchronized UserOptionsProvider getProvider() {
            if (this.provider == null) {
                this.provider = (UserOptionsProvider)Lookup.getDefault().lookup(UserOptionsProvider.class);
            }
            return this.provider;
        }

        private SpiAccessor() {
        }

        private List<String> getItemUserIncludePaths(List<String> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (this.getProvider() != null) {
                return this.getProvider().getItemUserIncludePaths(includes, compilerOptions, compiler, makeConfiguration);
            }
            return includes;
        }

        private List<String> getItemUserMacros(List<String> macros, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
            if (this.getProvider() != null) {
                return this.getProvider().getItemUserMacros(macros, compilerOptions, compiler, makeConfiguration);
            }
            return macros;
        }
    }
}

