/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.File;
import java.util.Date;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.filesystems.FileObject;

public class ProjectSupport {
    private ProjectSupport() {
    }

    public static boolean saveAllProjects(String extraMessage) {
        boolean ok = true;
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < openProjects.length; ++i) {
            MakeConfigurationDescriptor projectDescriptor = MakeConfigurationDescriptor.getMakeConfigurationDescriptor(openProjects[i]);
            if (projectDescriptor == null) continue;
            ok = ok && projectDescriptor.save(extraMessage);
        }
        return ok;
    }

    public static Date lastModified(Project project) {
        FileObject projectFile = null;
        try {
            projectFile = project.getProjectDirectory().getFileObject("nbproject" + File.separator + "Makefile-impl.mk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (projectFile == null) {
            projectFile = project.getProjectDirectory();
        }
        return projectFile.lastModified();
    }

    public static void executeCustomAction(Project project, ProjectActionHandler customProjectActionHandler) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null) {
            return;
        }
        MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = projectDescriptor.getActiveConfiguration();
        if (conf == null) {
            return;
        }
        MakeActionProvider ap = (MakeActionProvider)project.getLookup().lookup(MakeActionProvider.class);
        if (ap == null) {
            return;
        }
        ap.invokeCustomAction(projectDescriptor, conf, customProjectActionHandler);
    }
}

