/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.maven;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputProcessorFactory;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class JettyOutputProcessorFactory
implements OutputProcessorFactory {
    public Set<OutputProcessor> createProcessorsSet(Project project) {
        return Collections.singleton(new JettyOutputProcessor());
    }

    private static final class JettyOutputProcessor
    implements OutputProcessor {
        private static final Pattern LINE = Pattern.compile(".*Started SelectChannelConnector @ 0[.]0[.]0[.]0:(\\d+)");

        private JettyOutputProcessor() {
        }

        public String[] getRegisteredOutputSequences() {
            return new String[]{"mojo-execute#jetty:run", "mojo-execute#hpi:run"};
        }

        public void processLine(String string, OutputVisitor outputVisitor) {
            Matcher matcher = LINE.matcher(string);
            if (matcher.matches()) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://localhost:" + matcher.group(1) + "/"));
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
        }

        public void sequenceStart(String string, OutputVisitor outputVisitor) {
        }

        public void sequenceEnd(String string, OutputVisitor outputVisitor) {
        }

        public void sequenceFail(String string, OutputVisitor outputVisitor) {
        }
    }
}

