/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.registration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.registration.NbConnection;
import org.netbeans.modules.registration.RegisterAction;
import org.netbeans.modules.reglib.NbServiceTagSupport;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class NbInstaller
extends ModuleInstall {
    private static final String KEY_ENABLED = "nb.registration.enabled";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.registration.NbInstaller");
    private static boolean moduleEnabled = true;

    public void restored() {
        String value = System.getProperty(KEY_ENABLED);
        if (value != null) {
            if ("false".equals(value)) {
                moduleEnabled = false;
                LOG.log(Level.FINE, "Set moduleEnabled: " + moduleEnabled);
            } else if ("true".equals(value)) {
                moduleEnabled = true;
                LOG.log(Level.FINE, "Set moduleEnabled: " + moduleEnabled);
            }
        } else {
            String s = NbBundle.getMessage(NbInstaller.class, (String)KEY_ENABLED);
            if ("false".equals(s)) {
                moduleEnabled = false;
                LOG.log(Level.FINE, "Set moduleEnabled: " + moduleEnabled);
            } else if ("true".equals(s)) {
                moduleEnabled = true;
                LOG.log(Level.FINE, "Set moduleEnabled: " + moduleEnabled);
            }
        }
        RegisterAction a = (RegisterAction)SharedClassObject.findObject(RegisterAction.class, (boolean)true);
        a.setEnabled(moduleEnabled);
        if (!NbInstaller.isModuleEnabled()) {
            LOG.log(Level.FINE, "Module is disabled.");
            return;
        }
        try {
            NbServiceTagSupport.createNbServiceTag((String)NbServiceTagSupport.getProductName(), (String)System.getProperty("java.version"));
            if (NbInstaller.isCndShouldBeRegistered()) {
                NbServiceTagSupport.createCndServiceTag((String)NbServiceTagSupport.getProductName(), (String)System.getProperty("java.version"));
            }
            NbConnection.init();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error: Cannot create service tag:", ex);
        }
    }

    private static boolean isCndShouldBeRegistered() {
        File f = new File(System.getProperty("netbeans.home"));
        File nbInstallDir = f.getParentFile();
        String[] cndlist = nbInstallDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("cnd");
            }
        });
        if (cndlist != null && cndlist.length != 0) {
            LOG.log(Level.FINE, "cnd cluster should be registered");
            return true;
        }
        return false;
    }

    static boolean isModuleEnabled() {
        return moduleEnabled;
    }
}

