/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.timer;

import java.util.LinkedList;
import java.util.Queue;
import org.netbeans.modules.cnd.debugger.gdb.timer.GdbTimer;
import org.netbeans.modules.cnd.debugger.gdb.timer.TimerRecord;

class GdbTimerImpl
extends GdbTimer {
    private Queue<TimerRecord> queue = new LinkedList<TimerRecord>();
    private int skipCount = 0;
    private boolean in_use = false;

    GdbTimerImpl() {
    }

    @Override
    public void reset() {
        this.skipCount = 0;
        this.in_use = false;
    }

    @Override
    public void start(String msg) {
        this.start(msg, 0);
    }

    @Override
    public void start(String msg, int skipCount) {
        if (this.queue.isEmpty() && this.skipCount == 0 && !this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Start, msg));
            this.skipCount = skipCount;
            this.in_use = true;
        } else {
            --this.skipCount;
        }
    }

    @Override
    public void mark(String msg) {
        if (this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Mark, msg));
        }
    }

    @Override
    public void stop(String msg) {
        if (this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Stop, msg));
        }
    }

    @Override
    public void restart(String msg) {
        if (this.in_use) {
            this.queue.add(new TimerRecord(TimerRecord.RecordType.Restart, msg));
        }
    }

    @Override
    public void free() {
        if (this.in_use) {
            this.queue.clear();
        }
    }

    @Override
    public void report(String msg) {
        if (this.in_use) {
            long starttime = -1L;
            if (!this.queue.isEmpty()) {
                TimerRecord first = this.queue.peek();
                starttime = first.getTime();
            }
            for (TimerRecord record : this.queue) {
                System.err.println(record.toString(starttime));
            }
            this.free();
        }
    }

    @Override
    public int getSkipCount() {
        return this.skipCount;
    }
}

