/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.timer;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.gdb.timer.GdbDummyTimer;
import org.netbeans.modules.cnd.debugger.gdb.timer.GdbTimerImpl;

public abstract class GdbTimer {
    private static GdbTimer dummy = new GdbDummyTimer();
    private static Map<String, GdbTimer> map = new HashMap<String, GdbTimer>();

    public static GdbTimer getTimer(String name) {
        if (Boolean.getBoolean("org.netbeans.modules.cnd.gdb.timer.GdbTimer." + name)) {
            GdbTimer timer = map.get(name);
            if (timer == null) {
                timer = new GdbTimerImpl();
                map.put(name, timer);
            }
            return timer;
        }
        return dummy;
    }

    public static void release(String name) {
        map.remove(name);
    }

    public abstract void start(String var1);

    public abstract void start(String var1, int var2);

    public abstract void reset();

    public abstract void mark(String var1);

    public abstract void stop(String var1);

    public abstract void restart(String var1);

    public abstract void free();

    public abstract void report(String var1);

    public abstract int getSkipCount();

    public static enum TimerType {
        Dummy,
        Default,
        Custom;

    }
}

