/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.common.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.ValuePresenter;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class CallStackNodeModel
implements NodeModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private static final int POINTER_CLASS_MAX_LENGTH = 8;
    private final GdbDebugger debugger;
    private final Session session;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public CallStackNodeModel(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        new Listener(this, this.debugger);
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Name");
        }
        if (o instanceof GdbCallStackFrame) {
            GdbCallStackFrame sf = (GdbCallStackFrame)((Object)o);
            GdbCallStackFrame ccsf = this.debugger.getCurrentCallStackFrame();
            if (ccsf != null && ((Object)((Object)ccsf)).equals((Object)sf)) {
                return BoldVariablesTableModelFilterFirst.toHTML((String)CallStackNodeModel.getCSFName(this.session, sf, false), (boolean)true, (boolean)false, null);
            }
            return CallStackNodeModel.getCSFName(this.session, sf, false);
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Desc");
        }
        if (o instanceof GdbCallStackFrame) {
            GdbCallStackFrame sf = (GdbCallStackFrame)((Object)o);
            return CallStackNodeModel.getCSFName(this.session, sf, true);
        }
        if ("No current thread" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == o) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return null;
        }
        if (node instanceof GdbCallStackFrame) {
            GdbCallStackFrame ccsf = this.debugger.getCurrentCallStackFrame();
            if (ccsf != null && ((Object)((Object)ccsf)).equals(node)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged(null);
        }
    }

    public static String getCSFName(Session s, GdbCallStackFrame csf, boolean useFullName) {
        String fileName;
        String csfName;
        String functionName = csf.getFunctionName();
        if (functionName != null && !functionName.equals("??")) {
            csfName = functionName;
            Collection<GdbVariable> args = csf.getArguments();
            if (args != null) {
                StringBuilder sb = new StringBuilder(csfName);
                sb.append('(');
                Iterator<GdbVariable> iter = args.iterator();
                while (iter.hasNext()) {
                    int end;
                    GdbVariable arg = iter.next();
                    sb.append(arg.getName());
                    sb.append('=');
                    String value = ValuePresenter.getValue(arg.getValue());
                    if (value.length() > 2 && value.charAt(0) == '{' && value.charAt(value.length() - 1) == '}') {
                        value = "{...}";
                    }
                    if (value.length() > 8 && value.charAt(0) == '(' && (end = GdbUtils.findMatchingParen(value, 0)) != -1 && end < value.length() - 1) {
                        value = value.substring(end + 1);
                    }
                    sb.append(value.trim());
                    if (!iter.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(')');
                csfName = sb.toString();
            }
        } else {
            csfName = csf.getAddr() != null ? NbBundle.getMessage(CallStackNodeModel.class, (String)"CTL_CallstackModel_Msg_Format", (Object)csf.getAddr()) : "";
        }
        int ln = csf.getLineNumber();
        if (csfName.length() == 0) {
            String string = fileName = useFullName ? csf.getFullname() : csf.getFileName();
            if (ln < 0) {
                csfName = fileName == null ? "??" : fileName;
            }
        } else {
            fileName = csf.getFileName();
            if (fileName != null && ln >= 0) {
                csfName = NbBundle.getMessage(CallStackNodeModel.class, (String)"FMT_StackFrame", (Object[])new Object[]{csfName, fileName, String.valueOf(ln)});
            }
        }
        return csfName;
    }

    private static class Listener
    implements PropertyChangeListener {
        private final WeakReference<CallStackNodeModel> ref;
        private final GdbDebugger debugger;

        private Listener(CallStackNodeModel rm, GdbDebugger debugger) {
            this.ref = new WeakReference<CallStackNodeModel>(rm);
            this.debugger = debugger;
            debugger.addPropertyChangeListener("currentCallStackFrame", this);
        }

        private CallStackNodeModel getModel() {
            CallStackNodeModel rm = (CallStackNodeModel)this.ref.get();
            if (rm == null) {
                this.debugger.removePropertyChangeListener("currentCallStackFrame", this);
            }
            return rm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            CallStackNodeModel rm = this.getModel();
            if (rm == null) {
                return;
            }
            rm.fireTreeChanged();
        }
    }
}

