/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.common.utils.GeneralUtils;
import org.netbeans.modules.cnd.debugger.gdb.Field;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbErrorException;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.TypeInfo;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public abstract class AbstractVariable
implements LocalVariable {
    public static final String PROP_VALUE = "var_value";
    private final GdbDebugger debugger;
    protected String value = null;
    protected final List<Field> fields = new CopyOnWriteArrayList<Field>();
    protected TypeInfo tinfo = null;
    private static final Logger log = Logger.getLogger("gdb.logger");
    private final Set<PropertyChangeListener> listeners = Collections.synchronizedSet(new HashSet());

    protected AbstractVariable(GdbDebugger debugger, String value) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        this.debugger = debugger;
        this.value = debugger != null && debugger.getPlatform() == 4 ? GdbUtils.mackHack(value) : value;
    }

    protected TypeInfo getTypeInfo() {
        if (this.tinfo == null) {
            this.tinfo = TypeInfo.getTypeInfo(this.getDebugger(), this);
        }
        return this.tinfo;
    }

    protected void emptyFields() {
        for (Field field : this.fields) {
            if (!(field instanceof AbstractField)) continue;
            ((AbstractField)field).destroy();
        }
        this.fields.clear();
    }

    @Override
    public String getValue() {
        if (this.value != null && this.value.length() > 0) {
            if (this.value.charAt(0) == '>' && this.value.endsWith(".\"<")) {
                return '>' + this.value.substring(2, this.value.length() - 3).replace("\\\"", "\"") + '<';
            }
            return this.value.replace("\\\"", "\"");
        }
        return "";
    }

    protected String getResolvedType() {
        return this.getTypeInfo().getResolvedType(this);
    }

    @Override
    public void setValue(String value) {
        if (value.equals(this.value)) {
            return;
        }
        String msg = null;
        String rt = this.getResolvedType();
        if (this.getDebugger() != null) {
            int pos;
            if (!(value = value.trim()).isEmpty() && value.charAt(0) == '(' && (pos = GdbUtils.findMatchingParen(value, 0)) != -1) {
                value = value.substring(pos + 1).trim();
            }
            if (rt.equals("char") || rt.equals("unsigned char")) {
                if ((value = AbstractVariable.setValueChar(value)) == null) {
                    msg = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char");
                }
            } else if (rt.equals("char *") || rt.equals("unsigned char *") || rt.equals("const char *")) {
                if (value.replace("\"", "\\\"").equals(this.value)) {
                    return;
                }
                if ((value = AbstractVariable.setValueCharStar(value)) == null) {
                    msg = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char*");
                }
            } else if (rt.equals("int") || rt.equals("long") || rt.endsWith("int")) {
                if ((value = AbstractVariable.setValueNumber(value)) == null) {
                    msg = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Number");
                }
            } else if (rt.equals("bool") || !this.debugger.isCplusPlus() && rt.equals("_Bool")) {
                if (!(value.equals("true") || value.equals("false") || AbstractVariable.isNumberInRange(value, 0L, 1L))) {
                    msg = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_CplusPlus_Bool");
                }
            } else if (rt.startsWith("enum ")) {
                if ((value = this.setValueEnum(value)) == null) {
                    msg = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Enum");
                }
            } else if (!value.isEmpty() && value.charAt(0) == '\"' || value.startsWith("0x") && value.endsWith("\"")) {
                if (value.replace("\"", "\\\"").equals(this.value)) {
                    return;
                }
                if ((value = AbstractVariable.setValueCharStar(value)) == null) {
                    msg = NbBundle.getMessage(AbstractVariable.class, (String)"ERR_SetValue_Invalid_Char*");
                }
            } else if (GdbUtils.isPointer(rt)) {
                // empty if block
            }
            if (value != null && !value.isEmpty() && value.charAt(0) == '(' && (pos = GdbUtils.findMatchingParen(value, 0)) != -1) {
                value = value.substring(pos + 1).trim();
            }
            if (msg == null) {
                String fullname = this instanceof GdbWatchVariable ? ((GdbWatchVariable)this).getWatch().getExpression() : this.getFullName();
                if (!this.debugger.isCplusPlus() && rt.equals("_Bool") && !AbstractVariable.isNumber(value)) {
                    value = value.equals("true") ? "1" : "0";
                }
                this.value = this.getDebugger().updateVariable(fullname, value);
                this.getDebugger().variableChanged(this);
                if (this instanceof AbstractField) {
                    AbstractVariable parent = ((AbstractField)this).parent;
                    while (parent instanceof AbstractField) {
                        parent.updateVariable();
                        parent = ((AbstractField)parent).parent;
                    }
                    parent.updateVariable();
                    this.getDebugger().updateGdbVariable(parent.getName(), parent.value);
                }
            }
        }
        if (msg != null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message(msg);
            nd.setTitle(NbBundle.getMessage(AbstractVariable.class, (String)"TITLE_SetValue_Warning"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private synchronized void setModifiedValue(String value) {
        String oldVal = this.value;
        this.value = value;
        if (this.fields.size() > 0) {
            this.emptyFields();
            if (value.length() > 0) {
                this.expandChildren();
            }
        }
        this.notifyValueChanged(oldVal, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyValueChanged(String oldVal, String newVal) {
        ArrayList<PropertyChangeListener> ls;
        PropertyChangeEvent evt = new PropertyChangeEvent(this, PROP_VALUE, oldVal, newVal);
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            ls = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        for (PropertyChangeListener l : ls) {
            l.propertyChange(evt);
        }
    }

    private static String setValueChar(String value) {
        int pos;
        if (value.startsWith("0x") && (pos = value.indexOf(" '")) != -1 && value.endsWith("'")) {
            value = value.substring(pos + 1);
        } else if (value.charAt(0) != '\'' || value.charAt(value.length() - 1) != '\'') {
            value = null;
        }
        return value;
    }

    private static String setValueCharStar(String value) {
        int pos;
        value = value.startsWith("0x") && (pos = value.indexOf(" \\\"")) != -1 && value.endsWith("\\\"") ? '\"' + value.substring(pos + 3, value.length() - 2) + '\"' : (value.startsWith("0x") && (pos = value.indexOf(" \"")) != -1 && value.endsWith("\"") ? value.substring(pos + 1).replace("\"", "\\\"") : (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.replace("\"", "\\\"") : null));
        return value;
    }

    private String setValueEnum(String value) {
        block3: {
            int pos2;
            int pos1;
            String info;
            block2: {
                info = this.getResolvedType();
                pos1 = info.indexOf(123);
                pos2 = info.indexOf(125);
                if (pos1 <= 0 || pos2 <= 0) break block2;
                String enum_values = info.substring(pos1 + 1, pos2);
                for (String frag : enum_values.split(", ")) {
                    if (!value.equals(frag)) continue;
                    return value;
                }
                break block3;
            }
            info = this.getTypeInfo().getDetailedType(this);
            pos1 = info.indexOf(123);
            pos2 = info.indexOf(125);
            if (pos1 <= 0 || pos2 <= 0) break block3;
            String enum_values = info.substring(pos1 + 1, pos2);
            for (String frag : enum_values.split(", ")) {
                if (!value.equals(frag)) continue;
                return value;
            }
        }
        return null;
    }

    private static String setValueNumber(String value) {
        if (!AbstractVariable.isNumber(value)) {
            value = null;
        }
        return value;
    }

    public int getFieldsCount() {
        if (this.getDebugger() == null || !this.getDebugger().isStopped()) {
            return 0;
        }
        if (this.fields.size() > 0) {
            return this.fields.size();
        }
        if (this.mightHaveFields()) {
            return this.estimateFieldCount();
        }
        return 0;
    }

    private boolean mightHaveFields() {
        this.getValue();
        String rt = this.getResolvedType();
        if (rt != null && rt.length() > 0) {
            if (GdbUtils.isArray(rt) && !AbstractVariable.isCharString(rt) && this.value != null && this.value.length() > 0) {
                return true;
            }
            if (this.isValidPointerAddress()) {
                return !GdbUtils.isFunctionPointer(rt) && !rt.equals("void *") && (!AbstractVariable.isCharString(rt) || GdbUtils.isMultiPointer(rt));
            }
        }
        return this.value != null && this.value.length() > 0 && (this.value.charAt(0) == '{' || this.value.charAt(this.value.length() - 1) == '}');
    }

    private int estimateFieldCount() {
        return 100;
    }

    private boolean isValidPointerAddress() {
        String frag = "";
        if (this.value != null) {
            if (this.value.length() > 0 && this.value.charAt(0) == '(') {
                int pos1 = this.value.indexOf("*) 0x");
                if (pos1 == -1) {
                    pos1 = this.value.indexOf("* const) 0x");
                    if (pos1 != -1) {
                        frag = this.value.substring(pos1 + 11);
                    }
                } else {
                    frag = this.value.substring(pos1 + 5);
                }
                if (pos1 != -1) {
                    long i;
                    try {
                        i = Long.parseLong(frag, 16);
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                    return i > 0L;
                }
            } else if (this.value.startsWith("0x")) {
                long i;
                try {
                    i = Long.parseLong(this.value.substring(2), 16);
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                return i > 0L;
            }
        }
        return false;
    }

    public Field[] getFields() {
        if (this.fields.size() == 0) {
            this.expandChildren();
        }
        return this.fields.toArray(new Field[this.fields.size()]);
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected final GdbDebugger getDebugger() {
        return this.debugger;
    }

    private synchronized boolean expandChildren() {
        if (this.fields.size() == 0) {
            this.createChildren();
        }
        return this.fields.size() > 0;
    }

    private void createChildren() {
        String resolvedType = this.getResolvedType();
        String t = null;
        String v = null;
        this.getValue();
        if (GdbUtils.isPointer(resolvedType) && !AbstractVariable.isCharString(resolvedType) && !GdbUtils.isMultiPointer(resolvedType)) {
            if (this.value.endsWith(" 0") || this.value.endsWith(" 0x0")) {
                t = null;
                v = null;
            } else {
                t = GdbUtils.getBaseType(resolvedType);
                try {
                    v = this.getDebugger().requestValueEx('*' + this.getFullName(false));
                }
                catch (GdbErrorException e) {
                    this.fields.add(new ErrorField(e.getMessage()));
                    return;
                }
            }
        } else {
            t = resolvedType;
            v = this.value;
        }
        if (v != null) {
            if (GdbUtils.isArray(t)) {
                this.createChildrenForArray(t, v);
            } else if (GdbUtils.isMultiPointer(t)) {
                this.createChildrenForMultiPointer(t);
            } else {
                Map<String, Object> map = this.getTypeInfo().getMap();
                if (map != null) {
                    if (v.indexOf(123) == -1) {
                        this.fields.add(new AbstractField(this, '*' + this.getName(), t, v));
                    } else if (v.equals("<incomplete type>")) {
                        this.fields.add(new AbstractField(this, "", t, v));
                    } else if (v.length() > 0) {
                        int pos = v.indexOf(123);
                        assert (pos != -1);
                        String val = v.substring(pos + 1, v.length() - 1);
                        int start = 0;
                        int end = GdbUtils.findNextComma(val, 0);
                        int anon = 1;
                        while (end != -1) {
                            String vfrag = val.substring(start, end).trim();
                            anon = this.completeFieldDefinition(this, map, vfrag, anon);
                            start = end + 1;
                            end = GdbUtils.findNextComma(val, end + 1);
                        }
                        this.completeFieldDefinition(this, map, val.substring(start).trim(), anon);
                    } else {
                        log.fine("AV.createChildren: 0 length value for " + this.getFullName(false));
                    }
                }
            }
        }
    }

    private void createChildrenForMultiPointer(String t) {
        int i = 0;
        String fullname = this.getFullName(false);
        String t2 = t.substring(0, t.length() - 1);
        int max_fields = t2.startsWith("char *") ? 20 : 10;
        int maxIndexLog = GeneralUtils.log10((int)(max_fields - 1));
        while (max_fields-- > 0) {
            String v = this.getDebugger().requestValue(fullname + '[' + i + ']');
            if (v == null || v.length() < 1 || v.endsWith("0x0")) {
                return;
            }
            this.fields.add(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(maxIndexLog, i++), t2, v));
        }
    }

    private static boolean isCharString(String t) {
        return t != null && t.endsWith("*") && !t.endsWith("**") && ((t = GdbUtils.getBaseType(t)).equals("char") || t.equals("unsigned char"));
    }

    private int completeFieldDefinition(AbstractVariable parent, Map<String, Object> map, String info, int anon_count) {
        if (info.charAt(0) == '{') {
            Map typeMap = (Map)map.get("<anonymous" + anon_count + ">");
            if (typeMap != null) {
                String fType = (String)typeMap.get("<name>");
                this.fields.add(new AbstractField(parent, "", fType, info));
                return ++anon_count;
            }
            log.warning("GdbDebugger.completeFieldDefinition: Missing type information for " + info);
        } else {
            int pos = info.indexOf(61);
            if (pos != -1) {
                String fType;
                String fName;
                String fValue = info.substring(pos + 1).trim();
                if (info.charAt(0) == '<') {
                    fName = NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass");
                    fType = info.substring(1, pos - 2).trim();
                    if (fType.length() == 0) {
                        fType = (String)map.get("<super1>");
                    }
                    if (fName.startsWith("_vptr")) {
                        return anon_count;
                    }
                } else {
                    fName = info.substring(0, pos - 1).trim();
                    if (fName.startsWith("_vptr")) {
                        return anon_count;
                    }
                    Object o = map.get(fName);
                    if (o instanceof String) {
                        fType = o.toString();
                    } else if (o instanceof Map) {
                        fType = (String)((Map)o).get("<name>");
                        if (fType == null) {
                            log.warning("GdbDebugger.completeFieldDefinition: Missing <name> from map");
                            return anon_count;
                        }
                    } else {
                        fType = AbstractVariable.isNumber(fValue) ? "int" : null;
                    }
                }
                this.fields.add(new AbstractField(parent, fName, fType, fValue));
            } else if (info.trim().equals("<No data fields>")) {
                this.fields.add(new AbstractField(parent, "", "", info.trim()));
            }
        }
        return anon_count;
    }

    private void parseCharArray(String type, int size, String value) {
        int idx = 0;
        boolean truncated = false;
        int maxIndexLog = GeneralUtils.log10((int)(size - 1));
        String bareType = type.substring(0, type.indexOf(91)).trim();
        while (idx < value.length()) {
            String frag;
            int pos;
            if (value.substring(idx).startsWith("\\\"")) {
                String high;
                pos = value.indexOf("\\\",", idx);
                if (pos >= 0) {
                    frag = value.substring(idx + 2, pos);
                    idx += frag.length() + 4;
                } else {
                    if (value.endsWith("\\\"...")) {
                        frag = value.substring(idx + 2, value.length() - 5);
                        truncated = true;
                    } else {
                        frag = value.substring(idx + 2, value.length() - 2);
                    }
                    idx = value.length();
                }
                AbstractVariable.parseCharArrayFragment(this, this.getName(), bareType, maxIndexLog, frag);
                if (this.fields.size() < size && idx >= value.length()) {
                    this.fields.add(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(maxIndexLog, size - 1), bareType, "'\\000'"));
                }
                if (!truncated) continue;
                try {
                    high = type.substring(type.indexOf(91) + 1, type.indexOf(93));
                    Integer.parseInt(high);
                }
                catch (Exception ex) {
                    high = "...";
                }
                this.fields.add(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(maxIndexLog, this.fields.size(), "-" + high), "", "..."));
                continue;
            }
            if (value.charAt(idx) == ' ' || value.charAt(idx) == ',') {
                ++idx;
                continue;
            }
            pos = GdbUtils.findNextComma(value, idx);
            frag = pos > 0 ? value.substring(idx, pos) : value.substring(idx);
            this.addArrayElement(bareType, maxIndexLog, frag);
            idx += frag.length();
        }
    }

    private static void parseRepeatArrayFragment(AbstractVariable var, String basename, String type, int maxIndexLog, String value) {
        int count;
        String t = type.substring(0, type.indexOf(91)).trim();
        int idx = var.fields.size();
        int pos = value.indexOf(32);
        String val = value.substring(0, pos).replace("\\\\", "\\");
        int pos1 = value.indexOf("<repeats ");
        int pos2 = value.indexOf(" times>");
        try {
            count = Integer.parseInt(value.substring(pos1 + 9, pos2));
        }
        catch (Exception ex) {
            return;
        }
        while (--count >= 0) {
            var.fields.add(new AbstractField(var, basename + AbstractVariable.getIndexStr(maxIndexLog, idx++), t, val));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseCharArrayFragment(AbstractVariable var, String basename, String type, int maxIndexLog, String value) {
        int idx = 0;
        value = value.replace("\\\\", "\\");
        int count = value.length();
        int fcount = var.fields.size();
        while (true) {
            String val;
            block8: {
                int i;
                StringBuilder sb;
                char ch;
                block12: {
                    block11: {
                        int vstart;
                        block9: {
                            block10: {
                                if (idx >= count) {
                                    return;
                                }
                                vstart = idx;
                                if ((ch = value.charAt(idx++)) != '\\' || idx >= count) break block9;
                                if ((ch = value.charAt(idx++)) < '0' || ch > '7') break block10;
                                sb = new StringBuilder();
                                sb.append('\\');
                                sb.append(ch);
                                break block11;
                            }
                            if (ch == 'x' || ch == 'X') {
                                sb = new StringBuilder();
                                sb.append('\\');
                                sb.append(ch);
                                break block12;
                            } else if (value.substring(idx - 1, idx).matches("['\"?abfnrt]") || ch == '\\') {
                                val = '\\' + value.substring(idx - 1, idx);
                                break block8;
                            } else {
                                log.warning("AV.parseCharArrayFragment: Ignoring invalid character array fragment");
                                continue;
                            }
                        }
                        val = value.substring(vstart, idx);
                        break block8;
                    }
                    for (i = 0; i < 2 && idx < count && (ch = value.charAt(idx)) >= '0' && ch <= '7'; ++idx, ++i) {
                        sb.append(ch);
                    }
                    val = sb.toString();
                    break block8;
                }
                for (i = 0; !(i >= 2 || idx >= count || (ch = value.charAt(idx)) >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F'); ++idx, ++i) {
                    sb.append(ch);
                }
                val = sb.toString();
            }
            var.fields.add(new AbstractField(var, basename + AbstractVariable.getIndexStr(maxIndexLog, fcount++), type, '\'' + val + '\''));
        }
    }

    private void createChildrenForArray(String type, String value) {
        int size;
        int lbpos;
        if (value.length() == 0) {
            return;
        }
        int cbrace = type.lastIndexOf(125);
        if (cbrace == -1) {
            lbpos = type.indexOf(91);
        } else {
            lbpos = type.indexOf(91, cbrace);
            cbrace = type.indexOf(123);
        }
        int rbpos = GdbUtils.findMatchingBrace(type, lbpos);
        assert (rbpos != -1);
        int vstart = 0;
        int nextbrace = type.indexOf(91, rbpos);
        String extra = nextbrace == -1 ? "" : type.substring(nextbrace);
        String t = cbrace == -1 ? type.substring(0, lbpos).trim() + extra : type.substring(0, cbrace).trim() + extra;
        try {
            size = Integer.valueOf(type.substring(lbpos + 1, rbpos));
        }
        catch (Exception ex) {
            size = 0;
        }
        if (t.equals("char") || t.equals("unsigned char")) {
            this.parseCharArray(type, size, value);
        } else {
            value = value.substring(1, value.length() - 1);
            int maxIndexLog = GeneralUtils.log10((int)(size - 1));
            for (int i = 0; i < size && vstart != -1; ++i) {
                int vend = value.charAt(vstart) == '{' ? GdbUtils.findNextComma(value, GdbUtils.findMatchingCurly(value, vstart)) : GdbUtils.findNextComma(value, vstart);
                this.addArrayElement(t, maxIndexLog, vend == -1 ? value.substring(vstart) : value.substring(vstart, vend));
                vstart = vend == -1 ? -1 : GdbUtils.firstNonWhite(value, vend + 1);
            }
        }
    }

    private int addArrayElement(String type, int maxIndexLog, String value) {
        int pos1 = value.indexOf("<repeats ");
        int pos2 = value.indexOf(" times>");
        int count = 1;
        String bareValue = value;
        if (pos1 != -1 && pos2 != -1) {
            try {
                count = Integer.parseInt(value.substring(pos1 + 9, pos2));
                bareValue = value.substring(0, pos1 - 1).replace("\\\\", "\\");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        while (--count >= 0) {
            this.fields.add(new AbstractField(this, this.getName() + AbstractVariable.getIndexStr(maxIndexLog, this.fields.size()), type, bareValue));
        }
        return count;
    }

    private static String getIndexStr(int maxIndexLog, int index) {
        return AbstractVariable.getIndexStr(maxIndexLog, index, "");
    }

    private static String getIndexStr(int maxIndexLog, int index, String postfix) {
        int num0 = maxIndexLog - GeneralUtils.log10((int)index);
        String data = index + postfix;
        if (num0 > 0) {
            data = GeneralUtils.zeros((int)num0) + data;
        }
        return "[" + data + "]";
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    protected final void onValueChange(PropertyChangeEvent evt) {
        assert ("valueChanged".equals(evt.getPropertyName()));
        assert (evt.getNewValue() instanceof AbstractVariable);
        AbstractVariable av = (AbstractVariable)evt.getNewValue();
        if (av != this && av.getFullName().equals(this.getFullName())) {
            if (av instanceof AbstractField) {
                final AbstractVariable ancestor = ((AbstractField)this).getAncestor();
                this.debugger.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        ancestor.updateVariable();
                    }
                });
            } else {
                this.setModifiedValue(av.getValue());
            }
        }
    }

    private void updateVariable() {
        String newValue = this.getDebugger().requestValue("\"" + this.getFullName() + "\"");
        this.setModifiedValue(newValue);
    }

    public String toString() {
        return this.getFullName(false);
    }

    private static boolean isNumber(String value) {
        try {
            Long.decode(value);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static boolean isNumberInRange(String value, long low, long high) {
        try {
            long val = Long.parseLong(value);
            return val >= low && val <= high;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public final String getFullName() {
        return this.getFullName(false);
    }

    protected String getFullName(boolean showBase) {
        return this.getName();
    }

    protected abstract void selfDestroy();

    public void destroy() {
        this.selfDestroy();
        for (Field field : this.fields) {
            if (!(field instanceof AbstractField)) continue;
            ((AbstractField)field).destroy();
        }
    }

    public static class ErrorField
    implements Field {
        private final String msg;

        public ErrorField(String msg) {
            this.msg = msg.substring(1, msg.length() - 1);
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(AbstractVariable.class, (String)"LBL_Error");
        }

        @Override
        public void setValue(String value) {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public String getType() {
            return "";
        }

        @Override
        public String getValue() {
            return this.msg;
        }
    }

    static class AbstractField
    extends AbstractVariable
    implements Field,
    PropertyChangeListener {
        private AbstractVariable parent;
        private final String name;
        private final String type;

        public AbstractField(AbstractVariable parent, String name, String type, String value) {
            super(parent.debugger, null);
            assert (name != null) : "AbstractField with null name";
            this.name = name.startsWith("static ") ? name.substring(7) : name;
            if (type == null) {
                this.type = "";
            } else {
                int lcurly = type.indexOf(123);
                if (lcurly == -1) {
                    this.type = type;
                } else {
                    int rcurly = type.indexOf(125, lcurly);
                    this.type = type.substring(0, lcurly).trim() + type.substring(rcurly + 1);
                }
            }
            this.parent = parent;
            this.value = parent.debugger.getPlatform() == 4 ? GdbUtils.mackHack(value) : value;
            parent.debugger.addPropertyChangeListener("valueChanged", this);
        }

        @Override
        protected void selfDestroy() {
            this.getDebugger().removePropertyChangeListener("valueChanged", this);
        }

        protected AbstractVariable getAncestor() {
            if (this.parent instanceof AbstractField) {
                return ((AbstractField)this.parent).getAncestor();
            }
            return this.parent;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        protected String getFullName(boolean showBaseClass) {
            int pos;
            String pname;
            if (this.parent instanceof AbstractField) {
                pname = ((AbstractField)this.parent).getFullName(showBaseClass);
            } else {
                pname = this.parent.getName();
                if (pname.charAt(0) == '*') {
                    pname = '(' + pname + ')';
                }
            }
            String fullname = this.name.equals(NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass")) ? (showBaseClass ? pname + ".<" + this.type + ">" : pname) : (this.name.indexOf(91) != -1 ? ((pos = pname.lastIndexOf(46)) != -1 ? pname.substring(0, pos) + '.' + this.name : this.name) : (GdbUtils.isSimplePointer(this.parent.getType()) && this.name.charAt(0) == '*' ? '*' + pname : (GdbUtils.isPointer(this.parent.getType()) ? pname + "->" + this.name : (this.name.length() > 0 ? pname + '.' + this.name : pname))));
            return fullname;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.onValueChange(evt);
        }
    }
}

