/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.SecurityMechanismHelper;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.ClassLoaderManager;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.TrustAuthorityConfigImpl;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;
import org.netbeans.modules.identity.profile.api.configurator.spi.TrustAuthorityConfig;

public class ProviderConfigImpl
implements ProviderConfig {
    private static final String WSP = "WSP";
    private static final String AM_PROVIDER_CONFIG_CLASS = "com.sun.identity.wss.provider.ProviderConfig";
    private static final String AM_PASSWORD_CREDENTIAL_CLASS = "com.sun.identity.wss.security.PasswordCredential";
    private static final String AM_GET_PROVIDER_METHOD = "getProvider";
    private static final String AM_IS_RESPONSE_SIGN_ENABLED_METHOD = "isResponseSignEnabled";
    private static final String AM_SET_RESPONSE_SIGN_ENABLED_METHOD = "setResponseSignEnabled";
    private static final String AM_GET_KEY_ALIAS_METHOD = "getKeyAlias";
    private static final String AM_SET_KEY_ALIAS_METHOD = "setKeyAlias";
    private static final String AM_GET_KEY_PASSWORD_METHOD = "getKeyPassword";
    private static final String AM_GET_KEY_STORE_FILE_METHOD = "getKeyStoreFile";
    private static final String AM_GET_KEY_STORE_PASSWORD_METHOD = "getKeyStorePassword";
    private static final String AM_SET_KEY_STORE_METHOD = "setKeyStore";
    private static final String AM_GET_PROPERTY_METHOD = "getProperty";
    private static final String AM_SET_PROPERTY_METHOD = "setProperty";
    private static final String AM_GET_SECURITY_MECHANISMS_METHOD = "getSecurityMechanisms";
    private static final String AM_SET_SECURITY_MECHANISMS_METHOD = "setSecurityMechanisms";
    private static final String AM_GET_ALL_SUPPORT_SECURITY_MECH_METHOD = "getAllSupportedSecurityMech";
    private static final String AM_GET_ALL_MESSAGE_LEVEL_SECURITY_MECH_METHOD = "getAllMessageLevelSecurityMech";
    private static final String AM_SAVE_PROVIDER_METHOD = "saveProvider";
    private static final String AM_DELETE_PROVIDER_METHOD = "deleteProvider";
    private static final String AM_GET_WSP_ENDPOINT_METHOD = "getWSPEndpoint";
    private static final String AM_SET_WSP_ENDPOINT_METHOD = "setWSPEndpoint";
    private static final String AM_IS_PROVIDER_EXISTS_METHOD = "isProviderExists";
    private static final String AM_GET_USERS_METHOD = "getUsers";
    private static final String AM_SET_USERS_METHOD = "setUsers";
    private static final String AM_GET_USERNAME_METHOD = "getUserName";
    private static final String AM_GET_PASSWORD_METHOD = "getPassword";
    private static final String AM_SET_SERVICE_TYPE_METHOD = "setServiceType";
    private static final String AM_GET_SERVICE_TYPE_METHOD = "getServiceType";
    private static final String AM_SET_DEFAULT_KEY_STORE_METHOD = "setDefaultKeyStore";
    private static final String AM_USE_DEFAULT_KEY_STORE_METHOD = "useDefaultKeyStore";
    private static final String AM_SET_TRUST_AUTHORITY_CONFIG_LIST_METHOD = "setTrustAuthorityConfigList";
    private static final String DEFAULT_RELATIVE_KEYSTORE_LOCATION = "/domains/domain1/config/keystore.jks";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "adminadmin";
    private static final String DEFAULT_KEY_ALIAS = "s1as";
    private static final String AM_CONFIG_FILE_RELATIVE_PATH = "/addons/amserver/AMConfig.properties";
    private static final String DEFAULT_APPSERVER_LOCATION = "{sjsas.root}";
    private Class providerConfigClass;
    private Class passwordCredentialClass;
    private Object providerConfig;
    private String providerName;
    private String providerType;
    private ServerProperties properties;
    private SecurityMechanismHelper secMechHelper;

    public ProviderConfigImpl(String providerName, String type, ServerProperties properties) {
        this.providerName = providerName;
        this.providerType = type;
        this.properties = properties;
        this.secMechHelper = new SecurityMechanismHelper(properties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
        this.getProviderConfig();
    }

    Class getProviderConfigClass() {
        if (this.providerConfigClass == null) {
            try {
                ClassLoader loader = ClassLoaderManager.getDefault().getClassLoader(this.properties);
                this.providerConfigClass = loader.loadClass(AM_PROVIDER_CONFIG_CLASS);
            }
            catch (Exception ex) {
                throw ConfiguratorException.create(ex);
            }
        }
        return this.providerConfigClass;
    }

    Object getProviderConfig() {
        if (this.providerConfig == null) {
            try {
                Method method = this.getProviderConfigClass().getMethod(AM_GET_PROVIDER_METHOD, String.class, String.class);
                this.providerConfig = method.invoke(null, this.providerName, this.providerType);
                if (this.providerType.equals(WSP) && !this.isProviderExists()) {
                    this.createProvider();
                }
            }
            catch (Exception ex) {
                ClassLoaderManager.getDefault().removeClassLoader(this.properties);
                throw ConfiguratorException.create(ex);
            }
        }
        return this.providerConfig;
    }

    private void createProvider() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.providerName);
        Collection<String> uris = this.secMechHelper.getSecurityMechanismURIsFromNames(names);
        this.setSecurityMechanisms(uris);
        this.setDefaultKeyStore(true);
        this.saveProvider();
        this.providerConfig = null;
        this.getProviderConfig();
    }

    @Override
    public boolean isResponseSignEnabled() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_IS_RESPONSE_SIGN_ENABLED_METHOD, new Class[0]);
            return (Boolean)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setResponseSignEnabled(boolean flag) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_RESPONSE_SIGN_ENABLED_METHOD, Boolean.TYPE);
            method.invoke(this.getProviderConfig(), flag);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public String getKeyAlias() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_ALIAS_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setKeyAlias(String keyAlias) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_KEY_ALIAS_METHOD, String.class);
            method.invoke(this.getProviderConfig(), keyAlias);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public String getKeyPassword() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_PASSWORD_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public String getKeyStoreFile() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_STORE_FILE_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public String getKeyStorePassword() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_KEY_STORE_PASSWORD_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setKeyStore(String location, String password, String keyPassword) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_KEY_STORE_METHOD, String.class, String.class, String.class);
            method.invoke(this.getProviderConfig(), location, password, keyPassword);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public Object getProperty(String propName) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_PROPERTY_METHOD, String.class);
            return method.invoke(this.getProviderConfig(), propName);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setProperty(String propName, Object value) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_PROPERTY_METHOD, String.class, Object.class);
            method.invoke(this.getProviderConfig(), propName, value);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public Collection<String> getSecurityMechanisms() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_SECURITY_MECHANISMS_METHOD, new Class[0]);
            return (Collection)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setSecurityMechanisms(Collection<String> securityMechs) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_SECURITY_MECHANISMS_METHOD, List.class);
            method.invoke(this.getProviderConfig(), new ArrayList<String>(securityMechs));
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void saveProvider() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SAVE_PROVIDER_METHOD, this.getProviderConfigClass());
            method.invoke(null, this.getProviderConfig());
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void deleteProvider() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_DELETE_PROVIDER_METHOD, String.class);
            method.invoke(null, this.providerName);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public String getWSPEndpoint() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_WSP_ENDPOINT_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setWSPEndpoint(String endpoint) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_WSP_ENDPOINT_METHOD, String.class);
            method.invoke(this.getProviderConfig(), endpoint);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public boolean isProviderExists() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_IS_PROVIDER_EXISTS_METHOD, String.class, String.class);
            return (Boolean)method.invoke(null, this.providerName, this.providerType);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public ServerProperties getServerProperties(String id) {
        return this.properties;
    }

    @Override
    public void setServerProperties(ServerProperties properties) {
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public void setUserName(String userName) {
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public void setPassword(String password) {
    }

    @Override
    public void setUserNamePasswordPairs(Collection<Vector<String>> pairs) {
        List credentials = this.convertToPasswordCredentials(pairs);
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_USERS_METHOD, List.class);
            method.invoke(this.getProviderConfig(), credentials);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public Collection<Vector<String>> getUserNamePasswordPairs() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_USERS_METHOD, new Class[0]);
            List credentials = (List)method.invoke(this.getProviderConfig(), new Object[0]);
            return this.convertToUserNamePasswordPairs(credentials);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    private Class getPasswordCredentialClass() {
        if (this.passwordCredentialClass == null) {
            try {
                ClassLoader loader = ClassLoaderManager.getDefault().getClassLoader(this.properties);
                this.passwordCredentialClass = loader.loadClass(AM_PASSWORD_CREDENTIAL_CLASS);
            }
            catch (Exception ex) {
                throw ConfiguratorException.create(ex);
            }
        }
        return this.passwordCredentialClass;
    }

    private List convertToPasswordCredentials(Collection<Vector<String>> pairs) {
        ArrayList<Object> credentials = new ArrayList<Object>();
        for (Vector<String> pair : pairs) {
            credentials.add(this.convertToPasswordCredential(pair));
        }
        return credentials;
    }

    private Object convertToPasswordCredential(Vector<String> pair) {
        try {
            Constructor constructor = this.getPasswordCredentialClass().getConstructor(String.class, String.class);
            String userName = pair.get(0);
            if (userName == null || userName.length() == 0) {
                userName = " ";
            }
            return constructor.newInstance(userName, pair.get(1));
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    private Collection<Vector<String>> convertToUserNamePasswordPairs(List credentials) {
        Vector<Vector<String>> pairs = new Vector<Vector<String>>();
        if (credentials != null) {
            Iterator iter = credentials.iterator();
            while (iter.hasNext()) {
                pairs.add(this.convertToUserNamePasswordPair(iter.next()));
            }
        }
        return pairs;
    }

    private Vector<String> convertToUserNamePasswordPair(Object credential) {
        try {
            Method method = this.getPasswordCredentialClass().getMethod(AM_GET_USERNAME_METHOD, new Class[0]);
            String userName = (String)method.invoke(credential, new Object[0]);
            method = this.getPasswordCredentialClass().getMethod(AM_GET_PASSWORD_METHOD, new Class[0]);
            String password = (String)method.invoke(credential, new Object[0]);
            Vector<String> pair = new Vector<String>();
            pair.add(userName);
            pair.add(password);
            return pair;
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public Collection<String> getAllProviderNames() {
        return Collections.emptyList();
    }

    @Override
    public void setServiceType(String serviceType) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_SERVICE_TYPE_METHOD, String.class);
            method.invoke(this.getProviderConfig(), serviceType);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public String getServiceType() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_GET_SERVICE_TYPE_METHOD, new Class[0]);
            return (String)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setDefaultKeyStore(boolean flag) {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_DEFAULT_KEY_STORE_METHOD, Boolean.TYPE);
            method.invoke(this.getProviderConfig(), flag);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public boolean useDefaultKeyStore() {
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_USE_DEFAULT_KEY_STORE_METHOD, new Class[0]);
            return (Boolean)method.invoke(this.getProviderConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void setTrustAuthorityConfigList(List<TrustAuthorityConfig> trustAuthConfigs) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (TrustAuthorityConfig config : trustAuthConfigs) {
            TrustAuthorityConfigImpl configImpl = (TrustAuthorityConfigImpl)config;
            list.add(configImpl.getTrustAuthorityConfig());
        }
        try {
            Method method = this.getProviderConfigClass().getMethod(AM_SET_TRUST_AUTHORITY_CONFIG_LIST_METHOD, new Class[0]);
            method.invoke(this.getProviderConfig(), list);
        }
        catch (Exception ex) {
            throw ConfiguratorException.create(ex);
        }
    }

    @Override
    public void close() {
    }
}

