/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.identity.profile.api.configurator.Configurator;
import org.netbeans.modules.identity.profile.api.configurator.Modifier;

class TextFieldModifier
extends Modifier {
    private JTextField textField;

    public TextFieldModifier(final Enum configurable, final JTextField textField, final Configurator configurator) {
        super(configurable, textField, configurator);
        this.textField = textField;
        this.setValue(configurator.getValue(configurable));
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                String text = textField.getText();
                configurator.setValue(configurable, text);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.changedUpdate(event);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                this.changedUpdate(event);
            }
        });
    }

    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.textField.setText(value.toString());
        } else {
            this.textField.setText("");
        }
    }

    @Override
    public Object getValue() {
        return this.textField.getText();
    }
}

