/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class VariablesTreeModelFilterSI
implements TreeModelFilter,
NodeModel,
TableModel,
NodeActionsProvider {
    public static final String INHERITED = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    public static final String STATIC = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    private static final Set ignore = new HashSet<String>(Arrays.asList("java.lang.String", "java.lang.StringBuffer", "java.lang.Character", "java.lang.Integer", "java.lang.Float", "java.lang.Byte", "java.lang.Boolean", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.Stack", "java.util.TreeSet", "java.util.Vector", "java.util.Hashtable", "java.util.Hashtable$Entry", "java.util.HashMap", "java.util.HashMap$Entry", "java.util.IdentityHashMap", "java.util.AbstractMap$SimpleEntry", "java.util.TreeMap", "java.util.TreeMap$Entry", "java.util.WeakHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry"));
    private ContextProvider lookupProvider;

    public VariablesTreeModelFilterSI(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
    }

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
        if (object instanceof ObjectVariable) {
            ObjectVariable objectVariable = (ObjectVariable)object;
            if (ignore.contains(objectVariable.getType())) {
                return treeModel.getChildren(object, n, n2);
            }
            int n3 = Math.min(n2, treeModel.getChildrenCount(object));
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(treeModel.getChildren(object, n, n3)));
            if (arrayList.size() < n2 && objectVariable.getAllStaticFields(0, 0).length > 0) {
                arrayList.add(new StaticNode(objectVariable));
            }
            if (arrayList.size() < n2 && objectVariable.getInheritedFields(0, 0).length > 0) {
                arrayList.add(new InheritedNode(objectVariable));
            }
            return arrayList.toArray();
        }
        if (object instanceof SpecialNode) {
            return ((SpecialNode)object).getChildren(0, 0);
        }
        return treeModel.getChildren(object, n, n2);
    }

    public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object instanceof ObjectVariable) {
            ObjectVariable objectVariable = (ObjectVariable)object;
            if (ignore.contains(objectVariable.getType())) {
                return treeModel.getChildrenCount(object);
            }
            int n = treeModel.getChildrenCount(object);
            if (n == Integer.MAX_VALUE) {
                return n;
            }
            if (objectVariable.getAllStaticFields(0, 0).length > 0) {
                ++n;
            }
            if (objectVariable.getInheritedFields(0, 0).length > 0) {
                ++n;
            }
            return n;
        }
        if (object instanceof SpecialNode) {
            return ((SpecialNode)object).getChildren(0, 0).length;
        }
        return treeModel.getChildrenCount(object);
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        return object instanceof SpecialNode ? false : treeModel.isLeaf(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return ((SpecialNode)object).getDisplayName();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return ((SpecialNode)object).getIconBase();
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return new Action[0];
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return "";
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof SpecialNode) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    private static abstract class SpecialNode {
        protected ObjectVariable object;

        protected SpecialNode(ObjectVariable objectVariable) {
            this.object = objectVariable;
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        abstract Field[] getChildren(int var1, int var2);

        abstract String getDisplayName();

        abstract String getIconBase();
    }

    private static class InheritedNode
    extends SpecialNode {
        InheritedNode(ObjectVariable objectVariable) {
            super(objectVariable);
        }

        @Override
        Field[] getChildren(int n, int n2) {
            return this.object.getInheritedFields(0, 0);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof InheritedNode)) {
                return false;
            }
            return this.object.equals(((InheritedNode)object).object);
        }

        @Override
        String getDisplayName() {
            return NbBundle.getBundle(VariablesTreeModelFilterSI.class).getString("MSG_VariablesFilter_InheritedNode");
        }

        @Override
        String getIconBase() {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
        }
    }

    private static class StaticNode
    extends SpecialNode {
        StaticNode(ObjectVariable objectVariable) {
            super(objectVariable);
        }

        @Override
        Field[] getChildren(int n, int n2) {
            return this.object.getAllStaticFields(0, 0);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof StaticNode)) {
                return false;
            }
            return this.object.equals(((StaticNode)object).object);
        }

        @Override
        String getDisplayName() {
            return NbBundle.getBundle(VariablesTreeModelFilterSI.class).getString("MSG_VariablesFilter_StaticNode");
        }

        @Override
        String getIconBase() {
            return "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
        }
    }
}

