/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LineBreakpointPanel
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private static final Logger logger = Logger.getLogger(LineBreakpointPanel.class.getName());
    private static final String HELP_ID = "NetbeansDebuggerBreakpointLineJPDA";
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private LBController controller = new LBController();
    private final DocumentListener validityDocumentListener = new ValidityDocumentListener();
    private URL fileURL;
    private JPanel cPanel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    private static LineBreakpoint createBreakpoint() {
        LineBreakpoint lineBreakpoint = LineBreakpoint.create((String)EditorContextDispatcher.getDefault().getMostRecentURLAsString(), (int)EditorContextDispatcher.getDefault().getMostRecentLineNumber());
        lineBreakpoint.setPrintText(NbBundle.getBundle(LineBreakpointPanel.class).getString("CTL_Line_Breakpoint_Print_Text"));
        return lineBreakpoint;
    }

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint(), true);
    }

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint) {
        this(lineBreakpoint, false);
    }

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint, boolean bl) {
        this.createBreakpoint = bl;
        this.breakpoint = lineBreakpoint;
        this.initComponents();
        if (bl) {
            this.tfFileName.setEditable(true);
        }
        String string = lineBreakpoint.getURL();
        logger.fine("LineBreakpointPanel(" + string + ")");
        try {
            String string2;
            URL uRL = new URL(string);
            String string3 = uRL.getProtocol();
            if ("file".equalsIgnoreCase(string3)) {
                string2 = uRL.toURI().getPath();
                if (string2.length() == 0) {
                    string2 = string;
                } else {
                    this.fileURL = uRL;
                }
            } else {
                string2 = string;
            }
            logger.fine("Path/URL = " + string2);
            this.tfFileName.setText(string2);
        }
        catch (Exception exception) {
            this.tfFileName.setText(string);
        }
        this.tfFileName.setPreferredSize(new Dimension(30 * this.tfFileName.getFontMetrics(this.tfFileName.getFont()).charWidth('W'), this.tfFileName.getPreferredSize().height));
        this.tfLineNumber.setText(Integer.toString(lineBreakpoint.getLineNumber()));
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.setupConditionPane();
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.setCondition(lineBreakpoint.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(lineBreakpoint.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(lineBreakpoint.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)lineBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.tfFileName.getDocument().addDocumentListener(this.validityDocumentListener);
        this.tfLineNumber.getDocument().addDocumentListener(this.validityDocumentListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineBreakpointPanel.this.controller.checkValid();
            }
        });
    }

    private static int findNumLines(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return 0;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return 0;
        }
        editorCookie.prepareDocument().waitFinished();
        StyledDocument styledDocument = editorCookie.getDocument();
        if (!(styledDocument instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument styledDocument2 = styledDocument;
        return NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getLength());
    }

    private void setupConditionPane() {
        this.conditionsPanel.setupConditionPaneContext(this.breakpoint.getURL(), this.breakpoint.getLineNumber());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.tfFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfLineNumber = new JTextField();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Line_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.tfFileName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)resourceBundle.getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_File_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.jLabel1.setLabelFor(this.tfLineNumber);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName("Line number");
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LineBreakpointPanel.class, (String)"ACSN_LineBreakpoint"));
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            LineBreakpointPanel.this.controller.checkValid();
        }
    }

    private class LBController
    implements Controller {
        private boolean valid;
        private String errMsg = null;

        private LBController() {
        }

        public boolean ok() {
            if (!this.valid) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.errMsg));
                return false;
            }
            LineBreakpointPanel.this.actionsPanel.ok();
            String string = LineBreakpointPanel.this.tfFileName.getText().trim();
            logger.fine("O.K.: path = '" + string + "'");
            URL uRL = this.getURL(string);
            logger.fine("      => URL = '" + uRL + "'");
            LineBreakpointPanel.this.breakpoint.setURL(uRL != null ? uRL.toString() : string);
            LineBreakpointPanel.this.breakpoint.setLineNumber(Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim()));
            LineBreakpointPanel.this.breakpoint.setCondition(LineBreakpointPanel.this.conditionsPanel.getCondition());
            LineBreakpointPanel.this.breakpoint.setHitCountFilter(LineBreakpointPanel.this.conditionsPanel.getHitCount(), LineBreakpointPanel.this.conditionsPanel.getHitCountFilteringStyle());
            if (LineBreakpointPanel.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)LineBreakpointPanel.this.breakpoint);
            }
            return true;
        }

        public boolean cancel() {
            return true;
        }

        private void checkValid() {
            int n;
            String string = LineBreakpointPanel.this.tfFileName.getText().trim();
            logger.fine("checkValid: path = '" + string + "'");
            if (string.length() == 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_File_Spec"));
                this.setValid(false);
                return;
            }
            URL uRL = this.getURL(string);
            logger.fine("  url = '" + uRL + "'");
            FileObject fileObject = null;
            if (uRL != null) {
                fileObject = URLMapper.findFileObject((URL)uRL);
            }
            logger.fine("  => FileObject = '" + fileObject + "'");
            if (fileObject == null) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonExistent_File_Spec"));
                this.setValid(false);
                return;
            }
            if (!"text/x-java".equals(fileObject.getMIMEType())) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonJava_File_Spec"));
                this.setValid(false);
                return;
            }
            try {
                n = Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            if (n <= 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            int n2 = LineBreakpointPanel.findNumLines(fileObject);
            logger.fine("  => maxLine = '" + n2 + "'");
            if (n2 == 0) {
                n2 = 0x7FFFFFFE;
            }
            if (n > n2 + 1) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(n), (Object)Integer.toString(n2 + 1)));
                this.setValid(false);
                return;
            }
            this.setErrorMessage(null);
            this.setValid(true);
        }

        private URL getURL(String string) {
            URL uRL = null;
            if (LineBreakpointPanel.this.fileURL != null) {
                String string2 = LineBreakpointPanel.this.fileURL.getQuery();
                try {
                    URI uRI = new URI(LineBreakpointPanel.this.fileURL.getProtocol(), null, LineBreakpointPanel.this.fileURL.getHost(), LineBreakpointPanel.this.fileURL.getPort(), string, string2, null);
                    try {
                        uRL = uRI.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.log(Level.INFO, "Malformed url protocol '" + LineBreakpointPanel.this.fileURL.getProtocol() + "', from " + LineBreakpointPanel.this.fileURL + ", path = '" + string + "', uri = " + uRI, malformedURLException);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.log(Level.INFO, "Malformed URI: scheme '" + LineBreakpointPanel.this.fileURL.getProtocol() + "', from " + LineBreakpointPanel.this.fileURL + ", path = '" + string + "'", uRISyntaxException);
                }
            }
            if (uRL == null) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.log(Level.INFO, "Malformed url '" + string + "'", malformedURLException);
                }
            }
            return uRL;
        }

        private void setValid(boolean bl) {
            this.valid = bl;
            LineBreakpointPanel.this.firePropertyChange("valid", !bl, bl);
        }

        public boolean isValid() {
            return this.valid;
        }

        private void setErrorMessage(String string) {
            this.errMsg = string;
            LineBreakpointPanel.this.firePropertyChange("errorNotification", null, string);
        }

        private void setInformationMessage(String string) {
            LineBreakpointPanel.this.firePropertyChange("infoNotification", null, string);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            LineBreakpointPanel.this.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            LineBreakpointPanel.this.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

