/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private static final int ANNOTATION_SCHEDULE_TIME = 100;
    private transient Object currentPC;
    private final transient Object currentPCLock = new Object();
    private transient boolean currentPCSet = false;
    private JPDAThread currentThread;
    private JPDADebugger currentDebugger;
    private SourcePath currentSourcePath;
    private AllThreadsAnnotator allThreadsAnnotator;
    private HashMap stackAnnotations = new HashMap();
    private final RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private CallStackFrame[] stackToAnnotate;
    private SourcePath sourcePathToAnnotate;

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("currentEngine".equals(string)) {
            this.updateCurrentDebugger((DebuggerEngine)propertyChangeEvent.getNewValue());
            this.updateCurrentThread();
            this.annotate();
        } else if ("currentThread".equals(string)) {
            this.updateCurrentThread((JPDAThread)propertyChangeEvent.getNewValue());
            this.annotate();
        } else if ("currentCallStackFrame".equals(string)) {
            this.showCurrentFrame((CallStackFrame)propertyChangeEvent.getNewValue());
        } else if ("state".equals(string)) {
            this.annotate();
        } else if ("threadStarted".equals(string)) {
            CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
            synchronized (currentThreadAnnotationListener) {
                if (this.allThreadsAnnotator != null) {
                    this.allThreadsAnnotator.add((JPDAThread)propertyChangeEvent.getNewValue());
                }
            }
        }
    }

    private synchronized void updateCurrentDebugger(DebuggerEngine debuggerEngine) {
        JPDADebugger jPDADebugger = debuggerEngine == null ? null : (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (this.currentDebugger == jPDADebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (this.allThreadsAnnotator != null) {
            this.allThreadsAnnotator.cancel();
            this.allThreadsAnnotator = null;
        }
        this.currentSourcePath = null;
        if (jPDADebugger != null) {
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.allThreadsAnnotator = new AllThreadsAnnotator(jPDADebugger);
            this.currentSourcePath = this.getCurrentSourcePath(jPDADebugger);
        }
        this.currentDebugger = jPDADebugger;
        if (this.currentThread != null && this.allThreadsAnnotator != null) {
            this.allThreadsAnnotator.remove(this.currentThread);
            this.currentThread = null;
        }
        this.updateCurrentThread();
    }

    private synchronized void updateCurrentThread() {
        this.updateCurrentThread(this.currentDebugger != null ? this.currentDebugger.getCurrentThread() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateCurrentThread(JPDAThread jPDAThread) {
        JPDAThread jPDAThread2 = null;
        JPDAThread jPDAThread3 = null;
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            jPDAThread2 = this.currentThread;
            if (this.currentDebugger != null) {
                jPDAThread3 = this.currentThread = jPDAThread;
            } else {
                this.currentThread = null;
            }
            AllThreadsAnnotator allThreadsAnnotator = this.allThreadsAnnotator;
            if (allThreadsAnnotator != null) {
                if (jPDAThread2 != null) {
                    allThreadsAnnotator.annotate(jPDAThread2, false);
                }
                if (jPDAThread3 != null) {
                    allThreadsAnnotator.annotate(jPDAThread3, true);
                }
            }
        }
    }

    private SourcePath getCurrentSourcePath(JPDADebugger jPDADebugger) {
        Session session = null;
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            if (sessionArray[i].lookupFirst(null, JPDADebugger.class) != jPDADebugger) continue;
            session = sessionArray[i];
            break;
        }
        DebuggerEngine debuggerEngine = session == null ? null : session.getCurrentEngine();
        SourcePath sourcePath = debuggerEngine == null ? null : (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
        return sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate() {
        JPDAThread jPDAThread;
        SourcePath sourcePath;
        JPDADebugger jPDADebugger;
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            jPDADebugger = this.currentDebugger;
            if (this.currentThread == null || jPDADebugger.getState() != 3) {
                Object object = this.currentPCLock;
                synchronized (object) {
                    this.currentPCSet = false;
                }
                this.removeAnnotations();
                return;
            }
            sourcePath = this.currentSourcePath;
            jPDAThread = this.currentThread;
        }
        try {
            currentThreadAnnotationListener = (Session)jPDADebugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)jPDADebugger, new Object[0]);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            currentThreadAnnotationListener = null;
        }
        RequestProcessor requestProcessor = null;
        if (currentThreadAnnotationListener != null) {
            requestProcessor = (RequestProcessor)currentThreadAnnotationListener.lookupFirst(null, RequestProcessor.class);
        }
        if (requestProcessor == null) {
            requestProcessor = this.rp;
        }
        requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                CurrentThreadAnnotationListener.this.annotate(jPDADebugger, jPDAThread, sourcePath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate(JPDADebugger jPDADebugger, final JPDAThread jPDAThread, final SourcePath sourcePath) {
        Session session;
        CallStackFrame[] callStackFrameArray;
        try {
            callStackFrameArray = jPDAThread.getCallStack();
        }
        catch (AbsentInformationException absentInformationException) {
            Object object = this.currentPCLock;
            synchronized (object) {
                this.currentPCSet = false;
            }
            this.removeAnnotations();
            return;
        }
        final CallStackFrame callStackFrame = jPDADebugger.getCurrentCallStackFrame();
        try {
            session = (Session)jPDADebugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)jPDADebugger, new Object[0]);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            session = null;
        }
        final String string = session != null ? session.getCurrentLanguage() : null;
        Object object = this.currentPCLock;
        synchronized (object) {
            this.currentPCSet = true;
        }
        if (callStackFrame != null && sourcePath != null && jPDAThread != null) {
            object = callStackFrame;
            int n = object.getLineNumber(string);
            if (n < 1) {
                block10: for (int i = 0; i < callStackFrameArray.length; ++i) {
                    if (!callStackFrame.equals(callStackFrameArray[i])) continue;
                    for (int j = i + 1; j < callStackFrameArray.length; ++j) {
                        if (callStackFrameArray[j].getLineNumber(string) < 1) continue;
                        object = callStackFrameArray[j];
                        break block10;
                    }
                    break;
                }
            }
            sourcePath.showSource((CallStackFrame)object, string);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CurrentThreadAnnotationListener.this.currentPCLock;
                synchronized (object) {
                    if (CurrentThreadAnnotationListener.this.currentPC != null) {
                        EditorContextBridge.getContext().removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                    }
                    if (callStackFrame != null && sourcePath != null && jPDAThread != null) {
                        CurrentThreadAnnotationListener.this.currentPC = sourcePath.annotate(jPDAThread, string);
                    }
                }
            }
        });
        this.annotateCallStack(callStackFrameArray, sourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCurrentFrame(CallStackFrame callStackFrame) {
        JPDADebugger jPDADebugger;
        SourcePath sourcePath;
        if (callStackFrame == null) {
            return;
        }
        CurrentThreadAnnotationListener currentThreadAnnotationListener = this;
        synchronized (currentThreadAnnotationListener) {
            sourcePath = this.currentSourcePath;
            jPDADebugger = this.currentDebugger;
        }
        if (sourcePath != null && jPDADebugger != null) {
            try {
                currentThreadAnnotationListener = (Session)jPDADebugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)jPDADebugger, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return;
            }
            sourcePath.showSource(callStackFrame, currentThreadAnnotationListener.getCurrentLanguage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create((Runnable)new RemoveAnnotationsTask());
            }
        }
        this.taskRemove.schedule(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(CallStackFrame[] callStackFrameArray, SourcePath sourcePath) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = callStackFrameArray;
            this.sourcePathToAnnotate = sourcePath;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.create((Runnable)new AnnotateCallStackTask());
            }
        }
        this.taskAnnotate.schedule(100);
    }

    static /* synthetic */ CallStackFrame[] access$902(CurrentThreadAnnotationListener currentThreadAnnotationListener, CallStackFrame[] callStackFrameArray) {
        currentThreadAnnotationListener.stackToAnnotate = callStackFrameArray;
        return callStackFrameArray;
    }

    private class AllThreadsAnnotator
    implements Runnable,
    PropertyChangeListener {
        private boolean active = true;
        private final JPDADebugger debugger;
        private final Map<JPDAThread, Object> threadAnnotations = new HashMap<JPDAThread, Object>();
        private final Set<JPDAThread> threadsToAnnotate = new HashSet<JPDAThread>();
        private final Map<JPDAThread, FutureAnnotation> futureAnnotations = new HashMap<JPDAThread, FutureAnnotation>();
        private final Set<Object> annotationsToRemove = new HashSet<Object>();
        private final RequestProcessor.Task task;

        public AllThreadsAnnotator(JPDADebugger jPDADebugger) {
            RequestProcessor requestProcessor;
            this.debugger = jPDADebugger;
            try {
                requestProcessor = (RequestProcessor)((Session)jPDADebugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)jPDADebugger, new Object[0])).lookupFirst(null, RequestProcessor.class);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                requestProcessor = null;
            }
            this.task = requestProcessor != null ? requestProcessor.create((Runnable)this) : CurrentThreadAnnotationListener.this.rp.create((Runnable)this);
            for (JPDAThread jPDAThread : jPDADebugger.getThreadsCollector().getAllThreads()) {
                this.add(jPDAThread);
            }
        }

        public void add(JPDAThread jPDAThread) {
            ((Customizer)jPDAThread).addPropertyChangeListener(this);
            this.annotate(jPDAThread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(JPDAThread jPDAThread) {
            ((Customizer)jPDAThread).removePropertyChangeListener(this);
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                Object object = this.threadAnnotations.remove(jPDAThread);
                if (object != null) {
                    this.threadsToAnnotate.remove(jPDAThread);
                    this.annotationsToRemove.add(object);
                    this.task.schedule(100);
                }
            }
        }

        public synchronized void cancel() {
            this.active = false;
            for (JPDAThread jPDAThread : new HashSet<JPDAThread>(this.threadAnnotations.keySet())) {
                this.remove(jPDAThread);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                if (!this.active) {
                    ((Customizer)propertyChangeEvent.getSource()).removePropertyChangeListener(this);
                    return;
                }
            }
            allThreadsAnnotator = (JPDAThread)propertyChangeEvent.getSource();
            this.annotate((JPDAThread)allThreadsAnnotator);
        }

        private void annotate(JPDAThread jPDAThread) {
            this.annotate(jPDAThread, jPDAThread == this.debugger.getCurrentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void annotate(JPDAThread jPDAThread, boolean bl) {
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                Object object = this.threadAnnotations.remove(jPDAThread);
                if (object != null) {
                    this.threadsToAnnotate.remove(jPDAThread);
                    this.annotationsToRemove.add(object);
                    this.task.schedule(100);
                }
                if (!bl) {
                    this.threadsToAnnotate.add(jPDAThread);
                    FutureAnnotation futureAnnotation = this.futureAnnotations.get(jPDAThread);
                    if (futureAnnotation == null) {
                        futureAnnotation = new FutureAnnotation(jPDAThread);
                    }
                    this.threadAnnotations.put(jPDAThread, futureAnnotation);
                    this.futureAnnotations.put(jPDAThread, futureAnnotation);
                    this.task.schedule(100);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Session session;
            SourcePath sourcePath;
            HashMap<JPDAThread, FutureAnnotation> hashMap;
            HashSet<JPDAThread> hashSet;
            HashSet<Object> hashSet2;
            HashMap<JPDAThread, Object> hashMap2 = this;
            synchronized (hashMap2) {
                hashSet2 = new HashSet<Object>(this.annotationsToRemove);
                this.annotationsToRemove.clear();
                hashSet = new HashSet<JPDAThread>(this.threadsToAnnotate);
                this.threadsToAnnotate.clear();
                hashMap = new HashMap<JPDAThread, FutureAnnotation>(this.futureAnnotations);
                this.futureAnnotations.clear();
                sourcePath = CurrentThreadAnnotationListener.this.currentSourcePath;
            }
            for (Object e : hashSet2) {
                void object2;
                Object object;
                if (e instanceof FutureAnnotation && (object = ((FutureAnnotation)e).getAnnotation()) == null) continue;
                EditorContextBridge.getContext().removeAnnotation((Object)object2);
            }
            hashMap2 = new HashMap<JPDAThread, Object>();
            HashSet<JPDAThread> hashSet3 = new HashSet<JPDAThread>();
            try {
                session = (Session)this.debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)this.debugger, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                session = null;
            }
            String string = session != null ? session.getCurrentLanguage() : null;
            for (JPDAThread jPDAThread : hashSet) {
                Object object = sourcePath != null ? sourcePath.annotate(jPDAThread, string, false) : null;
                if (object != null) {
                    hashMap2.put(jPDAThread, object);
                    ((FutureAnnotation)hashMap.get(jPDAThread)).setAnnotation(object);
                    continue;
                }
                hashSet3.add(jPDAThread);
            }
            AllThreadsAnnotator allThreadsAnnotator = this;
            synchronized (allThreadsAnnotator) {
                this.threadAnnotations.keySet().removeAll(hashSet3);
                this.threadAnnotations.putAll(hashMap2);
            }
        }

        private final class FutureAnnotation {
            private JPDAThread thread;
            private Object annotation;

            public FutureAnnotation(JPDAThread jPDAThread) {
                this.thread = jPDAThread;
            }

            public JPDAThread getThread() {
                return this.thread;
            }

            public void setAnnotation(Object object) {
                this.annotation = object;
            }

            public Object getAnnotation() {
                return this.annotation;
            }

            public String toString() {
                return "Future annotation (" + this.annotation + ") for " + this.thread;
            }
        }
    }

    private class AnnotateCallStackTask
    implements Runnable {
        private AnnotateCallStackTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            SourcePath sourcePath;
            CallStackFrame[] callStackFrameArray;
            Object object2 = CurrentThreadAnnotationListener.this.rp;
            synchronized (object2) {
                if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                    return;
                }
                callStackFrameArray = CurrentThreadAnnotationListener.this.stackToAnnotate;
                sourcePath = CurrentThreadAnnotationListener.this.sourcePathToAnnotate;
                CurrentThreadAnnotationListener.access$902(CurrentThreadAnnotationListener.this, null);
                CurrentThreadAnnotationListener.this.sourcePathToAnnotate = null;
            }
            object2 = new HashMap();
            int n = callStackFrameArray.length;
            for (int i = 1; i < n; ++i) {
                object = callStackFrameArray[i].getDefaultStratum();
                String string = EditorContextBridge.getRelativePath(callStackFrameArray[i], (String)object);
                int n2 = callStackFrameArray[i].getLineNumber((String)object);
                String string2 = string + n2;
                if (((HashMap)object2).containsKey(string2)) continue;
                Object object3 = CurrentThreadAnnotationListener.this.stackAnnotations.remove(string2);
                if (object3 == null) {
                    object3 = sourcePath.annotate(callStackFrameArray[i], (String)object);
                }
                if (object3 == null) continue;
                ((HashMap)object2).put(string2, object3);
            }
            object = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
            while (object.hasNext()) {
                EditorContextBridge.getContext().removeAnnotation(object.next());
            }
            CurrentThreadAnnotationListener.this.stackAnnotations = (HashMap)object2;
        }
    }

    private class RemoveAnnotationsTask
    implements Runnable {
        private RemoveAnnotationsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator iterator = CurrentThreadAnnotationListener.this.currentPCLock;
            synchronized (iterator) {
                if (CurrentThreadAnnotationListener.this.currentPCSet) {
                    return;
                }
                if (CurrentThreadAnnotationListener.this.currentPC != null) {
                    EditorContextBridge.getContext().removeAnnotation(CurrentThreadAnnotationListener.this.currentPC);
                }
                CurrentThreadAnnotationListener.this.currentPC = null;
            }
            iterator = CurrentThreadAnnotationListener.this.stackAnnotations.values().iterator();
            while (iterator.hasNext()) {
                EditorContextBridge.getContext().removeAnnotation(iterator.next());
            }
            CurrentThreadAnnotationListener.this.stackAnnotations.clear();
        }
    }
}

