/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.NbBundle;

public final class SVGStatusBar
extends JPanel {
    public static final int CELL_POSITION = 0;
    public static final int CELL_MODE = 1;
    public static final int CELL_MAIN = 2;
    public static final String LOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"LBL_STATUS_BAR_LOCKED");
    public static final String UNLOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"LBL_STATUS_BAR_UNLOCKED");
    public static final String TOOLTIP_LOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"HINT_STATUS_BAR_LOCKED");
    public static final String TOOLTIP_UNLOCKED = NbBundle.getMessage(SVGStatusBar.class, (String)"HINT_STATUS_BAR_UNLOCKED");
    private static final String[] POS_MAX_STRINGS = new String[]{"-99999.9:-99999.9"};
    private final Cell[] cells = new Cell[3];

    public SVGStatusBar() {
        super(new GridBagLayout());
        Cell cell = this.cells[0] = new Cell(POS_MAX_STRINGS);
        cell.setHorizontalAlignment(0);
        cell.setToolTipText("SVG coordinates");
        this.setText(0, "[-,-]");
        cell = this.cells[1] = new Cell(new String[]{LOCKED, UNLOCKED});
        cell.setHorizontalAlignment(0);
        this.cells[2] = new Cell(null);
        this.refreshPanel();
    }

    public void setText(int cellIndex, String text) {
        Cell cell = this.cells[cellIndex];
        if (cell != null) {
            cell.setText(text);
            switch (cellIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    cell.setToolTipText(text.equals(UNLOCKED) ? TOOLTIP_UNLOCKED : TOOLTIP_LOCKED);
                    break;
                }
                default: {
                    cell.setToolTipText("".equals(text) ? null : text);
                }
            }
        }
    }

    private void refreshPanel() {
        this.removeAll();
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = -1;
        gc.gridy = 0;
        gc.gridwidth = this.cells.length;
        gc.gridheight = 1;
        gc.weighty = 1.0;
        for (Cell c : this.cells) {
            boolean main = this.cells[2] == c;
            gc.fill = main ? 2 : 0;
            gc.weightx = main ? 1.0 : 0.0;
            this.add((Component)c, gc);
        }
        this.updateCellBorders();
    }

    private void updateCellBorders() {
        int cellCount = this.cells.length;
        Border innerBorder = (Border)UIManager.get("Nb.Editor.Status.innerBorder");
        Border leftBorder = (Border)UIManager.get("Nb.Editor.Status.leftBorder");
        Border rightBorder = (Border)UIManager.get("Nb.Editor.Status.rightBorder");
        Border onlyOneBorder = (Border)UIManager.get("Nb.Editor.Status.onlyOneBorder");
        if (cellCount == 0 || innerBorder == null || leftBorder == null || rightBorder == null || onlyOneBorder == null) {
            return;
        }
        if (cellCount == 1) {
            this.cells[0].setBorder(onlyOneBorder);
            return;
        }
        this.cells[0].setBorder(leftBorder);
        for (int i = 1; i < cellCount - 1; ++i) {
            this.cells[i].setBorder(innerBorder);
        }
        this.cells[cellCount - 1].setBorder(rightBorder);
    }

    private static class Cell
    extends JLabel {
        private final Dimension maxDimension = new Dimension();
        private final String[] widestStrings;
        private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
        static final Border CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getDefaults().getColor("controlHighlight")), BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlDkShadow")))), BorderFactory.createEmptyBorder(0, 2, 0, 2));

        Cell(String[] widestStrings) {
            this.setBorder(CELL_BORDER);
            this.setOpaque(true);
            this.widestStrings = widestStrings;
            this.setForeground((Color)UIManager.get("Label.foreground"));
            this.setBackground((Color)UIManager.get("Label.background"));
            this.updateSize();
        }

        private void updateSize() {
            Font f = this.getFont();
            if (f != null) {
                Border b = this.getBorder();
                Insets ins = b != null ? b.getBorderInsets(this) : NULL_INSETS;
                FontMetrics fm = this.getFontMetrics(f);
                int mw = fm.stringWidth(this.getText());
                this.maxDimension.height = fm.getHeight() + ins.top + ins.bottom;
                if (this.widestStrings != null) {
                    for (int i = 0; i < this.widestStrings.length; ++i) {
                        String widestString = this.widestStrings[i];
                        if (widestString == null) continue;
                        mw = Math.max(mw, fm.stringWidth(widestString));
                    }
                }
                this.maxDimension.width = mw + ins.left + ins.right;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.maxDimension);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.maxDimension);
        }
    }
}

