/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

public final class ShrinkPalette {
    private static final int MAX_RGB = 255;
    private static final int MAX_NODES = 266817;
    private static final int MAX_TREE_DEPTH = 8;
    private static final int[] SQUARES;
    private static final int[] SHIFT;

    public static int[] quantizeImage(int[][] pixels, int max_colors) {
        ColorCube cube = new ColorCube(pixels, max_colors);
        cube.clasify();
        cube.reduce();
        cube.assign();
        return cube.getColorMap();
    }

    static {
        int i;
        SQUARES = new int[511];
        for (i = -255; i <= 255; ++i) {
            ShrinkPalette.SQUARES[i + 255] = i * i;
        }
        SHIFT = new int[9];
        for (i = 0; i < 9; ++i) {
            ShrinkPalette.SHIFT[i] = 1 << 15 - i;
        }
    }

    private static class ColorCube {
        private final Node m_root;
        private final int[][] m_pixels;
        private final int m_max_colors;
        private int[] m_colormap;
        private int m_depth;
        private int m_colors;
        private int m_nodes;

        ColorCube(int[][] pixels, int max_colors) {
            this.m_pixels = pixels;
            this.m_max_colors = max_colors;
            this.m_colors = 1;
            int i = max_colors;
            this.m_depth = 1;
            while (i != 0) {
                i /= 4;
                ++this.m_depth;
            }
            if (this.m_depth > 1) {
                --this.m_depth;
            }
            if (this.m_depth > 8) {
                this.m_depth = 8;
            } else if (this.m_depth < 2) {
                this.m_depth = 2;
            }
            this.m_root = new Node(this);
        }

        void clasify() {
            int[][] pixels = this.m_pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int pixel = pixels[x][y];
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (alpha <= 0) continue;
                    if (this.m_nodes > 266817) {
                        this.m_root.removeLevel();
                        --this.m_depth;
                    }
                    Node node = this.m_root;
                    for (int level = 1; level <= this.m_depth; ++level) {
                        int id = (red > node.m_mid_red ? 1 : 0) << 0 | (green > node.m_mid_green ? 1 : 0) << 1 | (blue > node.m_mid_blue ? 1 : 0) << 2;
                        if (node.m_child[id] == null) {
                            new Node(node, id, level);
                        }
                        node = node.m_child[id];
                        node.m_number_pixels += SHIFT[level];
                    }
                    ++node.m_unique;
                    node.m_total_alpha += alpha;
                    node.m_total_red += red;
                    node.m_total_green += green;
                    node.m_total_blue += blue;
                }
            }
        }

        void reduce() {
            int threshold = 1;
            while (this.m_colors > this.m_max_colors) {
                this.m_colors = 1;
                threshold = this.m_root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        void assign() {
            this.m_colormap = new int[this.m_colors];
            this.m_colormap[0] = 0x800000;
            this.m_colors = 1;
            this.m_root.fillColorMaps();
            int[][] pixels = this.m_pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            Search search = new Search();
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int pixel = pixels[x][y];
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (alpha > 0) {
                        Node node = this.m_root;
                        while (true) {
                            int id = (red > node.m_mid_red ? 1 : 0) << 0 | (green > node.m_mid_green ? 1 : 0) << 1 | (blue > node.m_mid_blue ? 1 : 0) << 2;
                            if (node.m_child[id] == null) break;
                            node = node.m_child[id];
                        }
                        search.distance = Integer.MAX_VALUE;
                        node.m_parent.findNearestColor(red, green, blue, search);
                        pixels[x][y] = search.color_number;
                        continue;
                    }
                    pixels[x][y] = 0;
                }
            }
        }

        public int[] getColorMap() {
            return this.m_colormap;
        }
    }

    private static class Node {
        private ColorCube m_cube;
        private Node m_parent;
        private Node[] m_child;
        private int m_nchild;
        private int m_id;
        private int m_level;
        private int m_mid_red;
        private int m_mid_green;
        private int m_mid_blue;
        private int m_number_pixels;
        private int m_unique;
        private int m_total_alpha;
        private int m_total_red;
        private int m_total_green;
        private int m_total_blue;
        private int m_color_number;

        Node(ColorCube cube) {
            this.m_cube = cube;
            this.m_parent = this;
            this.m_child = new Node[8];
            this.m_id = 0;
            this.m_level = 0;
            this.m_number_pixels = Integer.MAX_VALUE;
            this.m_mid_red = 128;
            this.m_mid_green = 128;
            this.m_mid_blue = 128;
        }

        Node(Node parent, int id, int level) {
            this.m_cube = parent.m_cube;
            this.m_parent = parent;
            this.m_child = new Node[8];
            this.m_id = id;
            this.m_level = level;
            ++this.m_cube.m_nodes;
            if (level == this.m_cube.m_depth) {
                ++this.m_cube.m_colors;
            }
            ++parent.m_nchild;
            parent.m_child[id] = this;
            int bi = 1 << 8 - level >> 1;
            this.m_mid_red = parent.m_mid_red + ((id & 1) > 0 ? bi : -bi);
            this.m_mid_green = parent.m_mid_green + ((id & 2) > 0 ? bi : -bi);
            this.m_mid_blue = parent.m_mid_blue + ((id & 4) > 0 ? bi : -bi);
        }

        void removeChild() {
            --this.m_parent.m_nchild;
            this.m_parent.m_unique += this.m_unique;
            this.m_parent.m_total_alpha += this.m_total_alpha;
            this.m_parent.m_total_red += this.m_total_red;
            this.m_parent.m_total_green += this.m_total_green;
            this.m_parent.m_total_blue += this.m_total_blue;
            this.m_parent.m_child[this.m_id] = null;
            --this.m_cube.m_nodes;
            this.m_cube = null;
            this.m_parent = null;
        }

        void removeLevel() {
            if (this.m_nchild != 0) {
                for (int id = 0; id < 8; ++id) {
                    if (this.m_child[id] == null) continue;
                    this.m_child[id].removeLevel();
                }
            }
            if (this.m_level == this.m_cube.m_depth) {
                this.removeChild();
            }
        }

        int reduce(int threshold, int next_threshold) {
            if (this.m_nchild != 0) {
                for (int id = 0; id < 8; ++id) {
                    if (this.m_child[id] == null) continue;
                    next_threshold = this.m_child[id].reduce(threshold, next_threshold);
                }
            }
            if (this.m_number_pixels <= threshold) {
                this.removeChild();
            } else {
                if (this.m_unique != 0) {
                    this.m_cube.m_colors++;
                }
                if (this.m_number_pixels < next_threshold) {
                    next_threshold = this.m_number_pixels;
                }
            }
            return next_threshold;
        }

        void fillColorMaps() {
            if (this.m_nchild != 0) {
                for (int id = 0; id < 8; ++id) {
                    if (this.m_child[id] == null) continue;
                    this.m_child[id].fillColorMaps();
                }
            }
            if (this.m_unique != 0) {
                int a = (this.m_total_alpha + (this.m_unique >> 1)) / this.m_unique;
                int r = (this.m_total_red + (this.m_unique >> 1)) / this.m_unique;
                int g = (this.m_total_green + (this.m_unique >> 1)) / this.m_unique;
                int b = (this.m_total_blue + (this.m_unique >> 1)) / this.m_unique;
                ((ColorCube)this.m_cube).m_colormap[((ColorCube)this.m_cube).m_colors] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
                this.m_color_number = this.m_cube.m_colors++;
            }
        }

        void findNearestColor(int red, int green, int blue, Search search) {
            int color;
            int distance;
            if (this.m_nchild != 0) {
                for (int id = 0; id < 8; ++id) {
                    if (this.m_child[id] == null) continue;
                    this.m_child[id].findNearestColor(red, green, blue, search);
                }
            }
            if (this.m_unique != 0 && (distance = Node.getDistance(color = this.m_cube.m_colormap[this.m_color_number], red, green, blue)) < search.distance) {
                search.distance = distance;
                search.color_number = this.m_color_number;
            }
        }

        static final int getDistance(int color, int r, int g, int b) {
            return SQUARES[(color >> 16 & 0xFF) - r + 255] + SQUARES[(color >> 8 & 0xFF) - g + 255] + SQUARES[(color >> 0 & 0xFF) - b + 255];
        }
    }

    private static class Search {
        private int distance;
        private int color_number;

        private Search() {
        }
    }
}

