/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.ModelNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.ComponentGroup;
import org.netbeans.modules.mobility.svgcore.export.ScreenSizeHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGRasterizerPanel
extends JPanel
implements AnimationRasterizer.Params {
    protected final SVGDataObject m_dObj;
    protected final String m_elementId;
    protected final J2MEProject m_project;
    protected final Dimension m_dim;
    protected double m_ratio;
    protected int m_overrideWidth = -1;
    protected int m_overrideHeight = -1;
    protected volatile boolean m_updateInProgress = false;
    protected volatile SVGImage m_svgImage;
    private SVGLocatableElement m_exportedElement = null;
    private boolean m_isDialogValid = true;
    private static final String CONFIRM_REWRITE_TITLE = "LBL_Confirm_Rewrite_Title";
    private static final String CONFIRM_REWRITE_MESSAGE = "LBL_Confirm_Rewrite_Msg";

    protected SVGRasterizerPanel(SVGDataObject dObj, String elementId) throws IOException, BadLocationException {
        SVGImage svgImage;
        this.m_dObj = dObj;
        this.m_elementId = elementId;
        FileObject primaryFile = this.m_dObj.getPrimaryFile();
        Project p = FileOwnerQuery.getOwner((FileObject)primaryFile);
        this.m_project = p != null && p instanceof J2MEProject ? (J2MEProject)p : null;
        this.m_dim = this.m_elementId == null && this.isInProject() ? ScreenSizeHelper.getCurrentDeviceScreenSize(primaryFile, null) : ((svgImage = this.getSVGImage()) != null ? new Dimension(this.m_svgImage.getViewportWidth(), this.m_svgImage.getViewportHeight()) : new Dimension());
    }

    protected ComponentGroup createTimeGroup(JSpinner spinner, JSlider slider, boolean isStart) {
        float duration = this.m_dObj.getSceneManager().getAnimationDuration();
        return this.createTimeGroup(spinner, slider, duration, isStart);
    }

    protected ComponentGroup createTimeGroup(JSpinner spinner, JSlider slider, final float duration, boolean isStart) {
        ComponentGroup.ComponentWrapper sliderWrapper;
        int p = Math.round(duration * 100.0f);
        slider.setMinimum(0);
        slider.setMaximum(p);
        slider.setValue(0);
        if (!isStart) {
            slider.setInverted(true);
            sliderWrapper = new ComponentGroup.SliderWrapper(slider){

                @Override
                public float getValue() {
                    return duration - super.getValue();
                }

                @Override
                public void setValue(float value) {
                    super.setValue(duration - value);
                }
            };
        } else {
            sliderWrapper = ComponentGroup.ComponentWrapper.wrap(slider);
        }
        SpinnerNumberModel model = new SpinnerNumberModel(isStart ? 0.0f : duration, 0.0, duration, 1.0);
        spinner.setModel(model);
        return new SVGRasterizerComponentGroup(spinner, sliderWrapper);
    }

    protected boolean isDialogValid() {
        return this.m_isDialogValid;
    }

    private void setDialogValid(boolean valid) {
        if (this.m_isDialogValid != valid) {
            boolean oldValid = this.m_isDialogValid;
            this.m_isDialogValid = valid;
            this.firePropertyChange("valid", oldValid, valid);
        }
    }

    protected ComponentGroup createCompressionGroup(JComboBox combo, JSpinner spinner) {
        spinner.setModel(new SpinnerNumberModel(0, 0, 99, 1));
        AnimationRasterizer.CompressionLevel defLevel = AnimationRasterizer.CompressionLevel.HIGH;
        spinner.setValue(new Integer(defLevel.getRate()));
        combo.setSelectedItem((Object)defLevel);
        return new SVGRasterizerComponentGroup(this.createComboWrapper(combo), spinner);
    }

    protected final boolean isInProject() {
        return this.m_project != null;
    }

    protected ComponentGroup.ComponentWrapper createComboWrapper(JComboBox combo) {
        return new ComponentGroup.ComponentWrapper(combo){

            @Override
            public float getValue() {
                Object obj = ((JComboBox)this.m_delegate).getSelectedItem();
                return ((AnimationRasterizer.CompressionLevel)((Object)obj)).getRate();
            }

            @Override
            public void setValue(float value) {
                int q = Math.round(value);
                ((JComboBox)this.m_delegate).setSelectedItem((Object)AnimationRasterizer.CompressionLevel.getLevel(q));
            }
        };
    }

    protected static float roundTime(float f) {
        return (float)Math.round(f * 100.0f) / 100.0f;
    }

    @Override
    public final void setImageWidth(int w) {
        this.m_overrideWidth = w;
    }

    @Override
    public final void setImageHeight(int h) {
        this.m_overrideHeight = h;
    }

    @Override
    public float getEndTime() {
        return 0.0f;
    }

    @Override
    public float getFramesPerSecond() {
        return 1.0f;
    }

    @Override
    public double getRatio() {
        return this.m_ratio;
    }

    private void loadSVGImage() {
        try {
            this.m_svgImage = this.m_dObj.getModel().parseSVGImage();
        }
        catch (Exception ex) {
            this.setDialogValid(false);
            SceneManager.log(Level.INFO, "Load of SVG image failed", ex);
        }
    }

    @Override
    public final synchronized SVGImage getSVGImage() throws IOException, BadLocationException {
        if (this.m_svgImage == null) {
            SVGSVGElement svg;
            SVGElement elem;
            if (SwingUtilities.isEventDispatchThread()) {
                Thread th = new Thread(){

                    @Override
                    public void run() {
                        SVGRasterizerPanel.this.loadSVGImage();
                    }
                };
                th.start();
                try {
                    th.join();
                }
                catch (InterruptedException e) {}
            } else {
                this.loadSVGImage();
            }
            if (this.m_svgImage != null && this.m_elementId != null && (elem = PerseusController.hideAllButSubtree((ModelNode)(svg = (SVGSVGElement)this.m_svgImage.getDocument().getDocumentElement()), this.m_elementId)) != null && elem instanceof SVGLocatableElement) {
                this.m_exportedElement = (SVGLocatableElement)elem;
                SVGRect bBox = this.m_exportedElement.getBBox();
                SVGMatrix svgCTM = svg.getScreenCTM();
                SVGMatrix eltCTM = this.m_exportedElement.getScreenCTM();
                SVGMatrix svgICTM = svgCTM.inverse();
                SVGMatrix eltToSvg = svgICTM.mMultiply(eltCTM);
                float[][] coords = SVGObjectOutline.transformRectangle(this.m_exportedElement.getBBox(), (Transform)eltToSvg, new float[4][2]);
                Rectangle rect2 = SVGObjectOutline.getShapeBoundingBox(coords);
                bBox = new Box((float)(rect2.x - 1), (float)(rect2.y - 1), (float)(rect2.width + 2), (float)(rect2.height + 2));
                svg.setRectTrait("viewBox", bBox);
                this.m_svgImage.setViewportWidth(Math.round(bBox.getWidth()));
                this.m_svgImage.setViewportHeight(Math.round(bBox.getHeight()));
            }
        }
        return this.m_svgImage;
    }

    @Override
    public final J2MEProject getProject() {
        return this.m_project;
    }

    @Override
    public final String getElementId() {
        return this.m_elementId;
    }

    protected static ComboBoxModel createImageTypeComboBoxModel() {
        DefaultComboBoxModel<AnimationRasterizer.ImageType> model = new DefaultComboBoxModel<AnimationRasterizer.ImageType>(AnimationRasterizer.ImageType.values());
        return model;
    }

    protected boolean isExportConfirmed() {
        String fileName = this.getPreviewFileName();
        File file = new File(fileName);
        if (!file.exists()) {
            return true;
        }
        return SVGRasterizerPanel.userConfirmRewrite(fileName);
    }

    private static boolean userConfirmRewrite(String file) {
        String title = NbBundle.getMessage(SVGRasterizerPanel.class, (String)CONFIRM_REWRITE_TITLE, (Object)file);
        String msg = NbBundle.getMessage(SVGRasterizerPanel.class, (String)CONFIRM_REWRITE_MESSAGE, (Object)file);
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, title, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.OK_OPTION;
    }

    protected abstract void updateImage(JComponent var1, boolean var2);

    protected abstract String getPreviewFileName();

    protected class SVGRasterizerComponentGroup
    extends ComponentGroup {
        public SVGRasterizerComponentGroup(Object ... comps) {
            super(comps);
        }

        @Override
        public void refresh(JComponent source) {
            if (!this.componentIsAdjustingSlider(source)) {
                SVGRasterizerPanel.this.updateImage(source, true);
            }
        }

        private boolean componentIsAdjustingSlider(JComponent comp) {
            return comp instanceof JSlider && ((JSlider)comp).getValueIsAdjusting();
        }
    }
}

