/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;

public class ComponentGroup
implements ActionListener,
ChangeListener {
    private final ComponentWrapper[] m_wrappers;
    private boolean m_isUpdateInProgress = false;

    public ComponentGroup(Object ... objects) {
        this.m_wrappers = new ComponentWrapper[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            if (o instanceof JComponent) {
                this.m_wrappers[i] = ComponentWrapper.wrap((JComponent)o);
            } else if (o instanceof ComponentWrapper) {
                this.m_wrappers[i] = (ComponentWrapper)o;
            } else {
                throw new IllegalArgumentException("Illegal object");
            }
            this.m_wrappers[i].addListener(this);
        }
    }

    public ComponentWrapper findWrapper(JComponent comp) {
        for (ComponentWrapper wrapper : this.m_wrappers) {
            if (wrapper.m_delegate != comp) continue;
            return wrapper;
        }
        return null;
    }

    public float getValue() {
        return this.m_wrappers[0].getValue();
    }

    public boolean valueChanged(JComponent comp) {
        for (int i = 0; i < this.m_wrappers.length; ++i) {
            if (this.m_wrappers[i].m_delegate != comp) continue;
            return this.valueChanged(i);
        }
        SceneManager.log(Level.SEVERE, "Component " + comp + " not found!");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueChanged(int index) {
        if (!this.m_isUpdateInProgress) {
            try {
                this.m_isUpdateInProgress = true;
                float value = this.m_wrappers[index].getValue();
                for (int i = 0; i < this.m_wrappers.length; ++i) {
                    if (i == index) continue;
                    this.m_wrappers[i].setValue(value);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.m_isUpdateInProgress = false;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (this.valueChanged(comp)) {
            this.refresh(comp);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (this.valueChanged(comp)) {
            this.refresh(comp);
        }
    }

    protected void refresh(JComponent comp) {
    }

    public static class SliderWrapper
    extends ComponentWrapper {
        protected SliderWrapper(JSlider slider) {
            super(slider);
        }

        @Override
        public float getValue() {
            return (float)((JSlider)this.m_delegate).getValue() / 100.0f;
        }

        @Override
        public void setValue(float value) {
            ((JSlider)this.m_delegate).setValue(Math.round(value * 100.0f));
        }
    }

    public static abstract class ComponentWrapper {
        protected final JComponent m_delegate;

        public abstract float getValue();

        public abstract void setValue(float var1);

        protected ComponentWrapper(JComponent delegate) {
            this.m_delegate = delegate;
        }

        protected void addListener(ComponentGroup group) {
            if (this.m_delegate instanceof JSpinner) {
                ((JSpinner)this.m_delegate).addChangeListener(group);
            } else if (this.m_delegate instanceof JSlider) {
                ((JSlider)this.m_delegate).addChangeListener(group);
            } else if (this.m_delegate instanceof JComboBox) {
                ((JComboBox)this.m_delegate).addActionListener(group);
            }
        }

        public static ComponentWrapper wrap(JComponent comp) {
            if (comp instanceof JSpinner) {
                return ComponentWrapper.wrap((JSpinner)comp);
            }
            if (comp instanceof JSlider) {
                return ComponentWrapper.wrap((JSlider)comp);
            }
            throw new IllegalArgumentException("Could not wrap " + comp);
        }

        public static ComponentWrapper wrap(JSpinner spinner) {
            return new ComponentWrapper(spinner){

                @Override
                public float getValue() {
                    return ((Number)((JSpinner)this.m_delegate).getValue()).floatValue();
                }

                @Override
                public void setValue(float value) {
                    JSpinner spinner = (JSpinner)this.m_delegate;
                    Object prevValue = spinner.getValue();
                    if (prevValue instanceof Integer) {
                        spinner.setValue(new Integer(Math.round(value)));
                    } else {
                        spinner.setValue(new Double(value));
                    }
                }
            };
        }

        public static ComponentWrapper wrap(JSlider slider) {
            return new SliderWrapper(slider);
        }
    }
}

