/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ActionWrapper;
import org.netbeans.modules.mobility.svgcore.composer.ActionWrapperFactory;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.InputControlManager;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.ScreenManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.CursorPositionActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.DeleteActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.HighlightActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveBackwardActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveFocusActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveForwardActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveToBottomActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.MoveToTopActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.RotateActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleXActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleYActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectAction;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.SkewActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.actions.TranslateActionFactory;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGStatusBar;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.w3c.dom.svg.SVGLocatableElement;

public final class SceneManager {
    public static final int EVENT_ANIM_STARTED = 2533;
    public static final int EVENT_ANIM_STOPPED = 2534;
    public static final int EVENT_IMAGE_DISPLAYED = 2535;
    public static final String OPERATION_TOKEN = "operation";
    private static final Logger LOGGER;
    private static final String LOGGER_NAME = "mobility.svg";
    private static final boolean LOG_TIME;
    private static final boolean LOG_THREAD;
    private static int s_instanceCounter;
    private transient SVGDataObject m_dObj = null;
    private transient int m_instanceID;
    private transient InstanceContent m_lookupContent;
    private transient Lookup m_lookup;
    private transient PerseusController m_perseusController;
    private transient ScreenManager m_screenMgr;
    private transient InputControlManager m_inputControlMgr;
    private transient List<ComposerActionFactory> m_actionFactories;
    private transient Stack<ComposerAction> m_activeActions;
    private transient List<Action> m_registeredActions;
    public transient SelectActionFactory m_selectActionFactory;
    private transient List<SelectionListener> m_selectionListeners;
    private transient SVGImage m_svgImage;
    private transient SVGLocatableElement m_popupElement = null;
    private transient String m_selectedId = null;
    private transient String m_selectedTag = null;
    private float m_animationDuration = 30.0f;
    private final List<String> m_busyStates = new ArrayList<String>(4);
    private boolean m_busyCursorOn = false;
    private boolean m_isReadOnly = false;
    private boolean m_isLandscape = false;
    float m_zoomRatio = 1.0f;

    public static boolean isEnabled(Level level) {
        return LOGGER.isLoggable(level);
    }

    public static void log(Level level, String msg, Throwable thrown) {
        LOGGER.log(level, SceneManager.decorate(level, msg), thrown);
    }

    public static void log(Level level, String msg) {
        LOGGER.log(level, SceneManager.decorate(level, msg));
    }

    public static void error(String msg, Throwable thrown) {
        SceneManager.log(Level.SEVERE, msg, thrown);
        NotifyDescriptor.Exception e = new NotifyDescriptor.Exception(thrown);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
    }

    private static String decorate(Level level, String msg) {
        if (LOGGER.isLoggable(level) && (LOG_THREAD || LOG_TIME)) {
            StringBuilder sb = new StringBuilder();
            if (LOG_TIME) {
                sb.append(System.currentTimeMillis());
                sb.append(' ');
            }
            if (LOG_THREAD) {
                sb.append('[');
                sb.append(Thread.currentThread().toString());
                sb.append("] ");
            }
            sb.append(msg);
            msg = sb.toString();
        }
        return msg;
    }

    public static AWTEvent createEvent(Object source, int id) {
        return new AWTEvent(source, id){};
    }

    public SceneManager() {
        this.m_activeActions = new Stack();
    }

    public void initialize(SVGDataObject dObj) {
        assert (this.m_dObj == null) : "Scene manager cannot be initialized twice";
        this.m_dObj = dObj;
        this.m_instanceID = s_instanceCounter++;
        this.m_lookupContent = new InstanceContent();
        this.m_lookup = new AbstractLookup((AbstractLookup.Content)this.m_lookupContent);
        this.m_actionFactories = new ArrayList<ComposerActionFactory>();
        this.m_selectionListeners = new ArrayList<SelectionListener>();
        this.m_activeActions.clear();
        this.m_selectActionFactory = new SelectActionFactory(this);
        this.addSelectionListener(this.m_selectActionFactory);
        this.m_actionFactories.add(new HighlightActionFactory(this));
        this.m_actionFactories.add(this.m_selectActionFactory);
        this.m_actionFactories.add(new TranslateActionFactory(this));
        this.m_actionFactories.add(new ScaleXActionFactory(this));
        this.m_actionFactories.add(new ScaleYActionFactory(this));
        this.m_actionFactories.add(new ScaleActionFactory(this));
        this.m_actionFactories.add(new SkewActionFactory(this));
        this.m_actionFactories.add(new RotateActionFactory(this));
        this.m_actionFactories.add(new DeleteActionFactory(this));
        this.m_actionFactories.add(new MoveToTopActionFactory(this));
        this.m_actionFactories.add(new MoveToBottomActionFactory(this));
        this.m_actionFactories.add(new MoveForwardActionFactory(this));
        this.m_actionFactories.add(new MoveBackwardActionFactory(this));
        this.m_actionFactories.add(new CursorPositionActionFactory(this));
        this.m_actionFactories.add(new MoveFocusActionFactory(this));
        this.m_screenMgr = new ScreenManager(this);
        this.updateStatusBar();
        this.m_registeredActions = new ArrayList<Action>();
        for (ComposerActionFactory factory : this.m_actionFactories) {
            Action[] factoryActions = factory.getMenuActions();
            if (factoryActions == null) continue;
            for (Action action : factoryActions) {
                this.m_registeredActions.add(action);
            }
        }
    }

    public String toString() {
        return "SceneManager-" + this.m_instanceID + "-" + (this.m_dObj != null ? this.m_dObj.getPrimaryFile().toString() : "null");
    }

    public synchronized void setImage(SVGImage svgImage) {
        if (this.m_svgImage != null) {
            this.resetImage();
        }
        this.m_lookupContent.add((Object)svgImage);
        this.m_svgImage = svgImage;
        this.m_perseusController = new PerseusController(this);
        this.m_inputControlMgr = new InputControlManager(this);
        this.m_perseusController.initialize();
        this.m_screenMgr.initialize();
        this.m_inputControlMgr.initialize();
        this.m_screenMgr.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetImage() {
        if (this.m_svgImage != null) {
            this.m_lookupContent.remove((Object)this.m_svgImage);
            this.m_svgImage = null;
        }
        this.m_popupElement = null;
        this.m_perseusController = null;
        this.m_screenMgr.reset();
        this.m_inputControlMgr = null;
        Stack<ComposerAction> stack = this.m_activeActions;
        synchronized (stack) {
            this.m_activeActions.clear();
        }
    }

    public synchronized boolean isImageLoaded() {
        return this.m_svgImage != null;
    }

    public void saveSelection() {
        if (this.m_selectedId == null) {
            SVGObject[] selected = this.getSelected();
            if (selected != null && selected.length > 0 && selected[0] != null) {
                SVGLocatableElement elem = selected[0].getSVGElement();
                this.m_selectedId = elem.getId();
                this.m_selectedTag = elem.getLocalName();
            } else {
                this.m_selectedId = null;
                this.m_selectedTag = null;
            }
        }
    }

    public void restoreSelection() {
        if (this.m_selectedId != null) {
            SVGObject selectedObj = this.m_perseusController.getObjectById(this.m_selectedId);
            if (selectedObj != null && (this.m_selectedTag == null || this.m_selectedTag.equals(selectedObj.getSVGElement().getLocalName()))) {
                this.setSelection(this.m_selectedId, false);
            } else {
                this.setSelection(null, false);
            }
            this.m_selectedId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusyState(String key, boolean isBusy) {
        List<String> list = this.m_busyStates;
        synchronized (list) {
            boolean busyCursorOn;
            if (this.m_busyStates.contains(key)) {
                if (!isBusy) {
                    this.m_busyStates.remove(key);
                }
            } else if (isBusy) {
                this.m_busyStates.add(key);
            }
            boolean bl = busyCursorOn = !this.m_busyStates.isEmpty();
            if (this.m_busyCursorOn != busyCursorOn) {
                JComponent comp;
                if (this.m_screenMgr != null && (comp = this.m_screenMgr.getComponent()) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Cursor cursor = busyCursorOn ? Cursor.getPredefinedCursor(3) : null;
                            comp.setCursor(cursor);
                        }
                    });
                }
                this.m_busyCursorOn = busyCursorOn;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        List<String> list = this.m_busyStates;
        synchronized (list) {
            return !this.m_busyStates.isEmpty();
        }
    }

    public void serialize(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.m_isReadOnly);
        out.writeBoolean(this.m_isLandscape);
        out.writeFloat(this.m_zoomRatio);
    }

    public void deserialize(ObjectInputStream in) throws IOException {
        this.m_isReadOnly = in.readBoolean();
        this.m_isLandscape = in.readBoolean();
        this.m_zoomRatio = in.readFloat();
    }

    Action getAction(String actionID) {
        for (Action action : this.m_registeredActions) {
            String id = action instanceof AbstractSVGAction ? ((AbstractSVGAction)action).getActionID() : action.getClass().getName();
            if (id == null || !id.equals(actionID)) continue;
            return action;
        }
        SceneManager.log(Level.SEVERE, "Unknown action id " + actionID);
        return null;
    }

    public void registerPopupActions(Action[] guiActions, TopComponent tc, Lookup lookup) {
        for (Action action : guiActions) {
            this.m_registeredActions.add(action);
        }
        Lookup lkp = Lookups.forPath((String)"Editors/text/svg+xml/Popup");
        Collection wrapperCol = lkp.lookupAll(ActionWrapperFactory.class);
        Action[] popupActions = new Action[wrapperCol.size()];
        int i = 0;
        for (ActionWrapperFactory factory : wrapperCol) {
            ActionWrapper wrapper = factory.createWrapper(this);
            if (wrapper == null) continue;
            Action a = wrapper.getAction();
            popupActions[i++] = a;
            if (!(a instanceof AbstractSVGAction)) continue;
            ((AbstractSVGAction)a).registerAction(tc);
        }
        this.m_screenMgr.registerPopupMenu(popupActions, lookup);
    }

    public Action[] getToolbarActions(String ... actionIds) {
        Action[] actions = new Action[actionIds.length];
        for (int i = 0; i < actionIds.length; ++i) {
            if (actionIds[i] == null) continue;
            actions[i] = this.getAction(actionIds[i]);
        }
        return actions;
    }

    public void updateActionState() {
        for (ComposerActionFactory factory : this.m_actionFactories) {
            factory.updateActionState();
        }
    }

    public SVGDataObject getDataObject() {
        return this.m_dObj;
    }

    public Lookup getLoookup() {
        return this.m_lookup;
    }

    public synchronized PerseusController getPerseusController() {
        return this.m_perseusController;
    }

    public ScreenManager getScreenManager() {
        return this.m_screenMgr;
    }

    public SVGImage getSVGImage() {
        return this.m_svgImage;
    }

    public JComponent getComposerGUI() {
        return this.m_screenMgr.getComponent();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_selectionListeners.remove(listener);
    }

    public float getAnimationDuration() {
        return this.m_animationDuration;
    }

    public void updateAnimationDuration(float time) {
        if (time > this.m_animationDuration) {
            this.m_animationDuration = time;
        }
    }

    public boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (this.m_isReadOnly != isReadOnly) {
            this.m_isReadOnly = isReadOnly;
            this.updateStatusBar();
            if (!this.m_isReadOnly && this.m_perseusController != null) {
                this.m_perseusController.stopAnimator();
            }
            SVGObject[] selected = this.getSelected();
            this.notifySelectionChanged(selected, selected);
            if (this.m_perseusController != null) {
                this.m_screenMgr.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(String id, boolean isDelayed) {
        if (isDelayed) {
            this.m_selectedId = id;
        } else {
            SVGObject[] oldSelection = this.getSelected();
            SelectAction action = this.m_selectActionFactory.getActiveAction();
            if (action != null) {
                action.actionCompleted();
            }
            SVGObject[] newSelection = null;
            if (id != null) {
                SVGObject selectedObj = this.m_perseusController.getObjectById(id);
                if (selectedObj != null) {
                    Stack<ComposerAction> stack = this.m_activeActions;
                    synchronized (stack) {
                        this.m_activeActions.push(this.m_selectActionFactory.startAction(selectedObj));
                    }
                    ActionMouseCursor cursor = this.m_selectActionFactory.getMouseCursor(null, false);
                    this.m_screenMgr.setCursor(cursor != null ? cursor.getCursor() : null);
                    newSelection = this.getSelected();
                } else {
                    newSelection = null;
                }
            }
            if (!SVGObject.areSame(newSelection, oldSelection)) {
                this.selectionChanged(newSelection, oldSelection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAction(ComposerAction action) {
        Stack<ComposerAction> stack = this.m_activeActions;
        synchronized (stack) {
            this.m_activeActions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent event) {
        if (SceneManager.isEnabled(Level.FINEST)) {
            SceneManager.log(Level.FINEST, "Processing event: " + event);
        }
        if (!this.isBusy()) {
            ActionMouseCursor c;
            Object action;
            int i;
            boolean isOutsideEvent = event.getSource() != this.m_screenMgr.getAnimatorView();
            SVGObject[] oldSelection = this.getSelected();
            boolean consumed = false;
            ActionMouseCursor cursor = null;
            Stack<ComposerAction> stack = this.m_activeActions;
            synchronized (stack) {
                for (i = this.m_activeActions.size() - 1; i >= 0; --i) {
                    action = (ComposerAction)this.m_activeActions.get(i);
                    c = action.getMouseCursor(isOutsideEvent);
                    if (cursor == null && c != null) {
                        cursor = c;
                    }
                    if (action.consumeEvent(event, isOutsideEvent)) {
                        consumed = true;
                        break;
                    }
                    if (!action.isCompleted()) continue;
                    this.m_activeActions.remove(i);
                }
            }
            ComposerAction action2 = null;
            if (!consumed) {
                for (i = this.m_actionFactories.size() - 1; i >= 0; --i) {
                    action2 = this.m_actionFactories.get(i).startAction(event, isOutsideEvent);
                    if (action2 == null) continue;
                    action = this.m_activeActions;
                    synchronized (action) {
                        this.m_activeActions.push(action2);
                        break;
                    }
                }
            }
            if (event instanceof MouseEvent && cursor == null) {
                MouseEvent me = (MouseEvent)event;
                for (int i2 = this.m_actionFactories.size() - 1; i2 >= 0; --i2) {
                    c = this.m_actionFactories.get(i2).getMouseCursor(me, isOutsideEvent);
                    if (c == null || cursor != null && cursor.getPriority() >= c.getPriority()) continue;
                    cursor = c;
                }
            }
            this.m_screenMgr.setCursor(cursor != null ? cursor.getCursor() : null);
            SVGObject[] newSelection = this.getSelected();
            if (!SVGObject.areSame(newSelection, oldSelection)) {
                this.selectionChanged(newSelection, oldSelection);
            }
        }
    }

    public SVGObject[] getSelected() {
        SVGObject selected = null;
        SelectAction action = this.m_selectActionFactory.getActiveAction();
        if (action != null) {
            selected = action.getSelected();
        }
        if (selected != null) {
            return new SVGObject[]{selected};
        }
        return null;
    }

    public Stack<ComposerAction> getActiveActions() {
        return this.m_activeActions;
    }

    public boolean containsAction(Class clazz) {
        return this.findAction(clazz) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComposerAction findAction(Class clazz) {
        Stack<ComposerAction> stack = this.m_activeActions;
        synchronized (stack) {
            for (int i = this.m_activeActions.size() - 1; i >= 0; --i) {
                ComposerAction action = (ComposerAction)this.m_activeActions.get(i);
                if (!clazz.isInstance(action)) continue;
                return action;
            }
            return null;
        }
    }

    public void deleteObject(SVGObject svgObj) {
        SVGObject[] oldSelection = this.getSelected();
        svgObj.delete();
        SVGObject[] newSelection = null;
        if (!SVGObject.areSame(newSelection, oldSelection)) {
            this.selectionChanged(newSelection, oldSelection);
        }
    }

    void popupAt(int x, int y) {
        SVGLocatableElement elem = this.m_perseusController.findElementAt(x, y);
        if (this.m_popupElement != null) {
            this.m_lookupContent.remove((Object)this.m_popupElement);
        }
        this.m_popupElement = elem;
        if (this.m_popupElement != null) {
            this.m_lookupContent.add((Object)this.m_popupElement);
        }
        this.m_screenMgr.repaint();
    }

    protected void selectionChanged(SVGObject[] newSelection, SVGObject[] oldSelection) {
        int i;
        if (oldSelection != null) {
            for (i = 0; i < oldSelection.length; ++i) {
                this.m_lookupContent.remove((Object)oldSelection[i]);
            }
        }
        if (newSelection != null && newSelection.length > 0) {
            for (i = 0; i < newSelection.length; ++i) {
                this.m_lookupContent.add((Object)newSelection[i]);
            }
        }
        this.notifySelectionChanged(newSelection, oldSelection);
    }

    protected void notifySelectionChanged(SVGObject[] newSelection, SVGObject[] oldSelection) {
        for (SelectionListener listener : this.m_selectionListeners) {
            listener.selectionChanged(newSelection, oldSelection, this.m_isReadOnly);
        }
    }

    private void updateStatusBar() {
        this.m_screenMgr.getStatusBar().setText(1, this.m_isReadOnly ? SVGStatusBar.LOCKED : SVGStatusBar.UNLOCKED);
    }

    static {
        s_instanceCounter = 0;
        LOGGER = Logger.getLogger(LOGGER_NAME);
        if (LOGGER.getLevel() == null) {
            LOGGER.setLevel(Level.WARNING);
        }
        String str = "mobility.svg.logTime";
        LOG_TIME = Boolean.valueOf(System.getProperty(str));
        LOGGER.info(str + '=' + LOG_TIME);
        str = "mobility.svg.logThread";
        LOG_THREAD = Boolean.valueOf(System.getProperty(str));
        LOGGER.info(str + '=' + LOG_THREAD);
    }

    public static interface SelectionListener {
        public void selectionChanged(SVGObject[] var1, SVGObject[] var2, boolean var3);
    }
}

