/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.util.Exceptions;

class JdbcPostgreSQLAdapter
extends RailsDatabaseConfiguration {
    static final String GEM_NAME = "activerecord-jdbcpostgresql-adapter";

    JdbcPostgreSQLAdapter() {
    }

    @Override
    public String railsGenerationParam() {
        return "postgresql";
    }

    @Override
    public void editConfig(RailsProject project) {
        Document databaseYml = RailsAdapters.getDatabaseYml(project.getProjectDirectory());
        try {
            RailsAdapters.changeAttribute(databaseYml, "adapter:", "jdbcpostgresql", null);
            RailsAdapters.addProperty(databaseYml, "host:", "localhost", "encoding:");
            this.editComments(databaseYml);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editComments(Document databaseYml) throws BadLocationException {
        String text = databaseYml.getText(0, databaseYml.getLength());
        int offset = text.indexOf("development:");
        if (offset == -1) {
            return;
        }
        databaseYml.remove(0, offset);
        String comment = "# PostgreSQL. Versions 7.4 and 8.x are supported.\n";
        databaseYml.insertString(0, comment, null);
    }

    @Override
    public JdbcInfo getJdbcInfo() {
        return null;
    }

    @Override
    public boolean requiresJdbc() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "postgresql (jdbc)";
    }

    @Override
    public String getDatabaseName(String projectName) {
        return projectName + "_development";
    }

    @Override
    public String getTestDatabaseName(String developmentDbName) {
        return RailsAdapters.getTestDatabaseName(developmentDbName);
    }

    @Override
    public String getProductionDatabaseName(String developmentDbName) {
        return RailsAdapters.getProductionDatabaseName(developmentDbName);
    }
}

