/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.gems.GemAction;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GeneratorPanel
extends JPanel
implements Runnable {
    private static final String GENERATOR_SUFFIX = "_generator";
    private static final Logger LOGGER = Logger.getLogger(GeneratorPanel.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private ChangeListener changeListener;
    private List<Generator> generators = new ArrayList<Generator>();
    private final Project project;
    private final Future<RailsProjectUtil.RailsVersion> railsVersion;
    private ButtonGroup actionTypeButtonGroup;
    private JRadioButton destroyButton;
    private ButtonGroup forceGroup;
    private JLabel forceLabel;
    private JRadioButton generateButton;
    private JLabel generateLabel;
    private JButton installGeneratorsButton;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel nameLabel;
    private JTextField nameText;
    private JPanel optionsPanel;
    private JRadioButton overwriteRadio;
    private JLabel parameter1Label;
    private JTextField parameter1Text;
    private JLabel parameter2Label;
    private JTextField parameter2Text;
    private JCheckBox pretendCB;
    private JRadioButton skipRadio;
    private JComboBox typeCombo;
    private JTextArea usageText;

    public GeneratorPanel(Project project, Generator initialGenerator) {
        this.project = project;
        this.railsVersion = EXECUTOR.submit(new Callable<RailsProjectUtil.RailsVersion>(){

            @Override
            public RailsProjectUtil.RailsVersion call() throws Exception {
                return RailsProjectUtil.getRailsVersion(GeneratorPanel.this.project);
            }
        });
        this.initComponents();
        this.actionTypeButtonGroup.add(this.generateButton);
        this.actionTypeButtonGroup.add(this.destroyButton);
        this.generateButton.setSelected(true);
        if (initialGenerator != Generator.NONE) {
            this.typeCombo.setSelectedItem(initialGenerator.getName());
        }
        this.showGenerator(initialGenerator);
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String item = e.getItem().toString();
                    for (Generator generator : GeneratorPanel.this.generators) {
                        if (!generator.getName().equals(item)) continue;
                        GeneratorPanel.this.showGenerator(generator);
                    }
                    GeneratorPanel.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }
        });
        this.nameText.requestFocus();
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                if (GeneratorPanel.this.changeListener != null) {
                    GeneratorPanel.this.changeListener.stateChanged(new ChangeEvent(ev));
                }
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                if (GeneratorPanel.this.changeListener != null) {
                    GeneratorPanel.this.changeListener.stateChanged(new ChangeEvent(ev));
                }
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
    }

    void setInitialState(String name, String params) {
        assert (name != null);
        this.nameText.setText(name);
        if (params != null) {
            this.parameter1Text.setText(params);
        }
    }

    private RailsProjectUtil.RailsVersion getRailsVersion() {
        try {
            return this.railsVersion.get();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.FINE, null, ex);
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private Generator getSelectedGenerator() {
        String item = this.typeCombo.getSelectedItem().toString();
        for (Generator generator : this.generators) {
            if (!generator.getName().equals(item)) continue;
            return generator;
        }
        return Generator.NONE;
    }

    void setForcing(boolean forcing) {
        this.overwriteRadio.setSelected(forcing);
        this.skipRadio.setSelected(!forcing);
    }

    void setPretend(boolean pretend) {
        this.pretendCB.setSelected(pretend);
    }

    private ComboBoxModel getTypeModel() {
        this.generators = this.findGenerators();
        ArrayList<String> generatorNames = new ArrayList<String>();
        for (Generator generator : this.generators) {
            if (generator == Generator.NONE) continue;
            generatorNames.add(generator.getName());
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(generatorNames.toArray());
        return model;
    }

    private FileObject getRailsHome() {
        File f;
        String home = System.getenv("HOME");
        if (home == null) {
            home = System.getenv("USERPROFILE");
        }
        if (home == null) {
            String homedrive = System.getenv("HOMEDRIVE");
            String homepath = System.getenv("HOMEPATH");
            if (homedrive != null && homepath != null) {
                home = homedrive + ":" + homepath;
            }
        }
        if (home == null) {
            try {
                f = new File("~");
                f = f.getCanonicalFile().getAbsoluteFile();
                if (f.exists()) {
                    home = f.getAbsolutePath();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (home == null) {
            home = System.getProperty("user.home");
        }
        if (home != null && (f = new File(home)).exists()) {
            try {
                f = f.getCanonicalFile();
                return FileUtil.toFileObject((File)f);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return null;
    }

    private void findGeneratorDirs(List<FileObject> generatorDirs, FileObject dir, String subdir) {
        if (!dir.isFolder()) {
            return;
        }
        FileObject[] subdirs = dir.getChildren();
        if (subdirs == null) {
            return;
        }
        if (subdir == null || dir.getName().equals(subdir)) {
            for (FileObject child : subdirs) {
                if (!child.isFolder() || !VisibilityQuery.getDefault().isVisible(child)) continue;
                generatorDirs.add(child);
            }
        } else {
            for (FileObject child : subdirs) {
                if (!child.isFolder()) continue;
                this.findGeneratorDirs(generatorDirs, child, subdir);
            }
        }
    }

    private void scan(List<Generator> generators, FileObject root, String relative, String subdir, Set<String> added) {
        FileObject dir = root.getFileObject(relative);
        if (dir == null) {
            return;
        }
        ArrayList<FileObject> generatorDirs = new ArrayList<FileObject>();
        this.findGeneratorDirs(generatorDirs, dir, subdir);
        for (FileObject generatorDir : generatorDirs) {
            String name = generatorDir.getName();
            if (added.contains(name)) continue;
            int argsRequired = 0;
            Generator generator = new Generator(name, generatorDir, argsRequired);
            generators.add(generator);
            added.add(name);
        }
    }

    private List<Generator> findGenerators() {
        GemManager gemManager;
        HashSet<String> added = new HashSet<String>();
        FileObject dir = this.project.getProjectDirectory();
        ArrayList<Generator> generators = new ArrayList<Generator>();
        this.scan(generators, dir, "lib/generators", null, added);
        this.scan(generators, dir, "lib/rails_generators", null, added);
        this.scan(generators, dir, "vendor/generators", null, added);
        this.scan(generators, dir, "vendor/plugins", "generators", added);
        FileObject railsHome = this.getRailsHome();
        if (railsHome != null) {
            this.scan(generators, railsHome, ".rails/generators", null, added);
        }
        if ((gemManager = RubyPlatform.gemManagerFor((Project)this.project)) != null) {
            for (File repo : gemManager.getRepositories()) {
                File gemDir = new File(repo, "gems");
                if (!gemDir.exists()) continue;
                Set gems = gemManager.getInstalledGemsFiles();
                for (String gem : gems) {
                    File f;
                    String version;
                    if (added.contains(gem) || (version = gemManager.getLatestVersion(gem)) == null || !(f = new File(gemDir, gem + "-" + version)).exists()) continue;
                    FileObject fo = FileUtil.toFileObject((File)f);
                    FileObject generatorsDir = fo.getFileObject("generators/");
                    String name = null;
                    if (!gem.endsWith(GENERATOR_SUFFIX)) {
                        if (generatorsDir == null) continue;
                        generators.addAll(GeneratorPanel.collect(generatorsDir));
                        continue;
                    }
                    name = gem.substring(0, gem.length() - GENERATOR_SUFFIX.length());
                    int argsRequired = 0;
                    Generator generator = new Generator(name, fo, argsRequired);
                    generators.add(generator);
                    added.add(generator.getName());
                }
            }
        }
        ArrayList<Generator> foundBuiltins = new ArrayList<Generator>();
        FileObject railsInstall = this.project.getProjectDirectory().getFileObject("vendor/rails/railties");
        if (railsInstall != null) {
            this.scan(generators, railsInstall, "lib/rails_generator/generators/components", null, added);
        } else if (gemManager != null) {
            for (File repo : gemManager.getRepositories()) {
                String[] gemsToTry;
                File gemDir = new File(repo, "gems");
                if (!gemDir.exists()) continue;
                for (String gemToTry : gemsToTry = new String[]{"rails", "railties"}) {
                    String path = gemToTry + "-" + this.getRailsVersion().asString();
                    File railsDir = new File(gemDir, path);
                    if (!railsDir.exists()) continue;
                    railsInstall = FileUtil.toFileObject((File)railsDir);
                    this.scan(foundBuiltins, railsInstall, "lib/rails_generator/generators/components", null, added);
                    this.scan(foundBuiltins, railsInstall, "lib//generators/rails", null, added);
                }
            }
        }
        List<Generator> builtins = Generator.getBuiltinGenerators(this.getRailsVersion().asString(), foundBuiltins);
        for (Generator builtin : builtins) {
            GeneratorPanel.add(builtin, generators);
        }
        Collections.sort(generators, new Comparator<Generator>(){

            @Override
            public int compare(Generator o1, Generator o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return generators;
    }

    private static Set<Generator> collect(FileObject generatorsDir) {
        HashSet<Generator> result = new HashSet<Generator>();
        Enumeration children = generatorsDir.getChildren(true);
        while (children.hasMoreElements()) {
            FileObject each = (FileObject)children.nextElement();
            String name = each.getName();
            if (each.isFolder() || !name.endsWith(GENERATOR_SUFFIX)) continue;
            name = name.substring(0, name.length() - GENERATOR_SUFFIX.length());
            result.add(new Generator(name, each.getParent(), 0));
        }
        return result;
    }

    private static boolean add(Generator toAdd, List<Generator> result) {
        for (Generator each : result) {
            if (!each.getName().equals(toAdd.getName())) continue;
            return false;
        }
        return result.add(toAdd);
    }

    public String getGeneratedName() {
        return this.nameText.getText().trim();
    }

    public String getType() {
        Object o = this.typeCombo.getSelectedItem();
        return o != null ? o.toString() : "";
    }

    Generator.Script getScript() {
        String action;
        String string = action = this.destroyButton.isSelected() ? "destroy" : "generate";
        if (!this.getRailsVersion().isRails3OrHigher()) {
            return new Generator.Script(action);
        }
        return new Generator.Script("rails").addArgs(action);
    }

    public boolean isForce() {
        return this.overwriteRadio.isSelected();
    }

    public boolean isPretend() {
        return this.pretendCB.isSelected();
    }

    private void showGenerator(Generator generator) {
        this.setOptions(generator.getNameLabel(), generator.getArg1Label(), generator.getArg2Label());
        this.showUsage(generator);
    }

    private void showUsage(Generator generator) {
        String usage = generator.getUsage(this.project);
        if (usage != null) {
            this.usageText.setText(usage);
            this.usageText.getCaret().setDot(0);
        } else {
            this.usageText.setText("");
        }
    }

    private void setOptions(String name, String firstParameter, String secondParameter) {
        this.nameLabel.setText(name);
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)name);
        boolean visible = firstParameter != null;
        this.parameter1Label.setVisible(visible);
        this.parameter1Text.setVisible(visible);
        if (visible) {
            Mnemonics.setLocalizedText((JLabel)this.parameter1Label, (String)firstParameter);
            this.parameter1Label.setLabelFor(this.parameter1Text);
        }
        visible = secondParameter != null;
        this.parameter2Label.setVisible(visible);
        this.parameter2Text.setVisible(visible);
        if (visible) {
            Mnemonics.setLocalizedText((JLabel)this.parameter2Label, (String)secondParameter);
            this.parameter2Label.setLabelFor(this.parameter2Text);
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public String[] getFirstParameterList() {
        if (this.parameter1Text.isVisible()) {
            return this.parameter1Text.getText().replace(',', ' ').replace("  ", " ").trim().split(" ");
        }
        return null;
    }

    public String[] getSecondParameterList() {
        if (this.parameter2Text.isVisible()) {
            return this.parameter2Text.getText().replace(',', ' ').replace("  ", " ").trim().split(" ");
        }
        return null;
    }

    public void setChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public boolean isDataValid() {
        Generator generator = this.getSelectedGenerator();
        if (generator == Generator.NONE) {
            return false;
        }
        String name = this.getGeneratedName();
        if (name.length() > 0 || generator.getArgsRequired() < 1) {
            return true;
        }
        String msg = RubyUtils.getIdentifierWarning((String)name, (int)0);
        if (msg != null) {
            // empty if block
        }
        return false;
    }

    @Override
    public void run() {
        RubyPlatform.platformFor((Project)this.project).recomputeRoots();
        this.typeCombo.setModel(this.getTypeModel());
        this.typeCombo.invalidate();
        this.typeCombo.repaint();
        Generator generator = this.getSelectedGenerator();
        if (generator != Generator.NONE) {
            this.showGenerator(generator);
        }
    }

    private void initComponents() {
        this.forceGroup = new ButtonGroup();
        this.actionTypeButtonGroup = new ButtonGroup();
        this.generateLabel = new JLabel();
        this.pretendCB = new JCheckBox();
        this.typeCombo = new JComboBox();
        this.skipRadio = new JRadioButton();
        this.overwriteRadio = new JRadioButton();
        this.optionsPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.parameter1Label = new JLabel();
        this.parameter1Text = new JTextField();
        this.parameter2Label = new JLabel();
        this.parameter2Text = new JTextField();
        this.forceLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.usageText = new JTextArea();
        this.jSeparator2 = new JSeparator();
        this.installGeneratorsButton = new JButton();
        this.generateButton = new JRadioButton();
        this.destroyButton = new JRadioButton();
        FormListener formListener = new FormListener();
        this.generateLabel.setLabelFor(this.typeCombo);
        Mnemonics.setLocalizedText((JLabel)this.generateLabel, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.generateLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.pretendCB, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.pretendCB.text"));
        this.typeCombo.setMaximumRowCount(14);
        this.typeCombo.setModel(this.getTypeModel());
        this.forceGroup.add(this.skipRadio);
        this.skipRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.skipRadio, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.skipRadio.text"));
        this.forceGroup.add(this.overwriteRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.overwriteRadio, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.overwriteRadio.text"));
        this.optionsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.optionsPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_NameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.optionsPanel.add((Component)this.nameText, gridBagConstraints);
        this.nameText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_NameText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.optionsPanel.add((Component)this.parameter1Label, gridBagConstraints);
        this.parameter1Label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter1Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.optionsPanel.add((Component)this.parameter1Text, gridBagConstraints);
        this.parameter1Text.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter1Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.optionsPanel.add((Component)this.parameter2Label, gridBagConstraints);
        this.parameter2Label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter2Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.optionsPanel.add((Component)this.parameter2Text, gridBagConstraints);
        this.parameter2Text.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_Parameter2Text"));
        Mnemonics.setLocalizedText((JLabel)this.forceLabel, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.forceLabel.text"));
        this.usageText.setColumns(20);
        this.usageText.setEditable(false);
        this.usageText.setRows(5);
        this.jScrollPane1.setViewportView(this.usageText);
        this.usageText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_UsageText"));
        Mnemonics.setLocalizedText((AbstractButton)this.installGeneratorsButton, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.installGeneratorsButton.text"));
        this.installGeneratorsButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.generateButton, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.generateButton.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.destroyButton, (String)NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.destroyButton.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 644, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 644, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.forceLabel).addPreferredGap(0).add((Component)this.skipRadio).addPreferredGap(0).add((Component)this.overwriteRadio)).add((Component)this.optionsPanel, -1, 644, Short.MAX_VALUE).add(1, (Component)this.pretendCB).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.generateLabel).addPreferredGap(0).add((Component)this.typeCombo, -2, -1, -2).add(18, 18, 18).add((Component)this.generateButton).addPreferredGap(0).add((Component)this.destroyButton).addPreferredGap(0, 219, Short.MAX_VALUE).add((Component)this.installGeneratorsButton)).add(1, (Component)this.jSeparator2, -1, 644, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.generateLabel).add((Component)this.typeCombo, -2, -1, -2).add((Component)this.installGeneratorsButton).add((Component)this.generateButton).add((Component)this.destroyButton)).addPreferredGap(0).add((Component)this.optionsPanel, -2, 92, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.forceLabel, -2, 16, -2).add((Component)this.skipRadio).add((Component)this.overwriteRadio)).addPreferredGap(0).add((Component)this.pretendCB).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 207, Short.MAX_VALUE).addContainerGap()));
        this.generateLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_GenerateLabel"));
        this.pretendCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_PretendCB"));
        this.typeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_TypeCombo"));
        this.skipRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_SkipRadio"));
        this.overwriteRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_OverwriteRadio"));
        this.forceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_ForceLabel"));
        this.installGeneratorsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"AD_InstallGeneratorsButton"));
        this.generateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.generateButton.AccessibleContext.accessibleDescription"));
        this.destroyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorPanel.class, (String)"GeneratorPanel.destroyButton.AccessibleContext.accessibleDescription"));
    }

    private void installGeneratorsButtonActionPerformed(ActionEvent evt) {
        boolean changed = GemAction.showGemManager((RubyPlatform)RubyPlatform.platformFor((Project)this.project), (String)"generator$");
        if (changed) {
            this.run();
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == GeneratorPanel.this.installGeneratorsButton) {
                GeneratorPanel.this.installGeneratorsButtonActionPerformed(evt);
            }
        }
    }
}

