/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.SourceRoots;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubySourceRootsUi;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.openide.util.EditableProperties;

public class RubyProjectProperties
extends SharedRubyProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(RubyProjectProperties.class.getName());
    public static final String RUN_WORK_DIR = "work.dir";
    private static final String[] CONFIG_PROPS = new String[]{"main.file", "application.args", "ruby.options", "work.dir", "rake.args", "jvm.args", "platform.active"};
    private static final String[] CONFIG_PRIVATE_PROPS = new String[]{"application.args", "work.dir", "rake.args", "platform.active"};
    DefaultTableModel sourceRootsModel = RubySourceRootsUi.createModel(this.getRubyProject().getSourceRoots());
    DefaultTableModel testRootsModel = RubySourceRootsUi.createModel(this.getRubyProject().getTestSourceRoots());

    public RubyProjectProperties(RubyBaseProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper, GeneratedFilesHelper genFileHelper) {
        super(project, evaluator, updateHelper, genFileHelper, refHelper);
    }

    RubyProject getRubyProject() {
        return (RubyProject)this.getProject().getLookup().lookup(RubyProject.class);
    }

    @Override
    protected String[] getConfigProperties() {
        return CONFIG_PROPS;
    }

    @Override
    protected String[] getConfigPrivateProperties() {
        return CONFIG_PRIVATE_PROPS;
    }

    @Override
    protected void prePropertiesStore() throws IOException {
        this.storeRoots(this.getRubyProject().getSourceRoots(), this.sourceRootsModel);
        this.storeRoots(this.getRubyProject().getTestSourceRoots(), this.testRootsModel);
    }

    @Override
    protected void storeProperties(EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        RubyPlatform platform = this.getPlatform();
        if (platform == null) {
            LOGGER.fine("Project has invalid platform (null).");
            return;
        }
        RubyPlatform.Info info = platform.getInfo();
        Util.logUsage(RubyProjectProperties.class, "USG_PROJECT_CONFIG_RUBY", info.getKind(), info.getPlatformVersion(), info.getGemVersion());
    }

    private void storeRoots(SourceRoots roots, DefaultTableModel tableModel) throws MalformedURLException {
        Vector<Vector> data = tableModel.getDataVector();
        URL[] rootURLs = new URL[data.size()];
        String[] rootLabels = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            File f = (File)data.elementAt(i).elementAt(0);
            rootURLs[i] = RubyProjectUtil.getRootURL(f, null);
            rootLabels[i] = (String)data.elementAt(i).elementAt(1);
        }
        roots.putRoots(rootURLs, rootLabels);
    }
}

