/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RubyOptionsAdvancedPanel
extends AdvancedOption {
    public String getTooltip() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RubyOptionsAdvancedPanel.class, (String)"LBL_OptionsPanelName");
    }

    public OptionsPanelController create() {
        return new Controller();
    }

    private static final class Controller
    extends OptionsPanelController {
        private JPanel panel;
        private boolean initialized = false;
        private Map<String, AdvancedOption> categoryToOption = new HashMap<String, AdvancedOption>();
        private Map<String, JComponent> categoryToPanel = new HashMap<String, JComponent>();
        private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();
        private List<String> categoriesOrdered = new ArrayList<String>();

        private Controller() {
        }

        private void init(Lookup masterLookup) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            Lookup lookup = Lookups.forPath((String)"RubyOptionsDialog");
            for (AdvancedOption option : lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances()) {
                String category = option.getDisplayName();
                this.categoriesOrdered.add(category);
                this.categoryToOption.put(category, option);
                OptionsPanelController controller = option.create();
                this.categoryToController.put(category, controller);
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add(controller.getComponent(masterLookup));
                this.categoryToPanel.put(category, panel);
            }
        }

        public JComponent getComponent(Lookup masterLookup) {
            this.init(masterLookup);
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new GridBagLayout());
                for (String category : this.categoriesOrdered) {
                    JComponent component = this.categoryToPanel.get(category);
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.anchor = 18;
                    gbc.fill = 1;
                    gbc.weightx = 0.0;
                    gbc.weighty = 0.0;
                    gbc.gridwidth = 0;
                    this.panel.add((Component)component, gbc);
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.panel.add((Component)new JPanel(), gridBagConstraints);
            }
            return this.panel;
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void update() {
            Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
            while (it.hasNext()) {
                it.next().update();
            }
        }

        public void applyChanges() {
            Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
            while (it.hasNext()) {
                it.next().applyChanges();
            }
        }

        public void cancel() {
            Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
            while (it.hasNext()) {
                it.next().cancel();
            }
        }

        public boolean isValid() {
            Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
            while (it.hasNext()) {
                if (it.next().isValid()) continue;
                return false;
            }
            return true;
        }

        public boolean isChanged() {
            Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
            while (it.hasNext()) {
                if (!it.next().isChanged()) continue;
                return true;
            }
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.advanced.ruby");
        }
    }
}

