/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.wizards.TemplateClientPanel;
import org.netbeans.modules.web.jsf.wizards.TemplateIterator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class TemplateClientIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private TemplateClientPanel templateClientPanel;
    private transient SourceGroup[] sourceGroups;
    private static final String ENCODING = "UTF-8";
    private static String END_LINE = System.getProperty("line.separator");

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        final String string = Templates.getTargetName((WizardDescriptor)templateWizard);
        final DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        dataFolder.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                InputStream inputStream = TemplateClientIterator.this.templateClientPanel.getTemplateClient();
                String string4 = JSFFrameworkProvider.readResource(inputStream, TemplateClientIterator.ENCODING);
                FileObject fileObject = dataFolder.getPrimaryFile().createData(string, "xhtml");
                String string2 = JSFUtils.getRelativePath(fileObject, TemplateClientIterator.this.templateClientPanel.getTemplate());
                String string3 = TemplateClientIterator.this.createDefineTags(TemplateClientIterator.this.templateClientPanel.getTemplateData(), string4.indexOf("<html") == -1 ? 1 : 3);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TEMPLATE", string2);
                hashMap.put("DEFINE_TAGS", string3);
                MapFormat mapFormat = new MapFormat(hashMap);
                mapFormat.setLeftBrace("__");
                mapFormat.setRightBrace("__");
                mapFormat.setExactMatch(false);
                string4 = mapFormat.format((Object)string4);
                JSFFrameworkProvider.createFile(fileObject, string4, TemplateClientIterator.ENCODING);
            }
        });
        FileObject fileObject2 = dataFolder.getPrimaryFile().getFileObject(string, "xhtml");
        return Collections.singleton(DataObject.find((FileObject)fileObject2));
    }

    public void initialize(TemplateWizard templateWizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        this.panels = this.createPanels(project, templateWizard);
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(TemplateIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard templateWizard) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("doc_root");
        this.templateClientPanel = new TemplateClientPanel((WizardDescriptor)templateWizard);
        WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)this.templateClientPanel);
        return new WizardDescriptor.Panel[]{panel};
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    private String createDefineTags(Collection<String> collection, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            int n2;
            stringBuffer.append(END_LINE);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append("    ");
            }
            stringBuffer.append("<ui:define name=\"").append(string).append("\">");
            stringBuffer.append(END_LINE);
            for (n2 = 0; n2 < n + 1; ++n2) {
                stringBuffer.append("    ");
            }
            stringBuffer.append(string);
            stringBuffer.append(END_LINE);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append("    ");
            }
            stringBuffer.append("</ui:define>");
            stringBuffer.append(END_LINE);
        }
        return stringBuffer.toString();
    }
}

