/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;

public class FortranBracketCompletion {
    private FortranBracketCompletion() {
    }

    static void charInserted(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        if (!FortranBracketCompletion.completionSettingEnabled()) {
            return;
        }
        Token<FortranTokenId> token = FortranBracketCompletion.getToken(doc, dotPos);
        if (token == null) {
            return;
        }
        if (ch == ')' || ch == '(') {
            switch ((FortranTokenId)token.id()) {
                case RPAREN: {
                    FortranBracketCompletion.skipClosingBracket(doc, caret, ch);
                    break;
                }
                case LPAREN: {
                    FortranBracketCompletion.completeOpeningBracket(doc, dotPos, caret, ch);
                }
            }
        } else if (ch == '\"' || ch == '\'') {
            FortranBracketCompletion.completeQuote(doc, dotPos, caret, ch);
        }
    }

    private static Token<FortranTokenId> getToken(BaseDocument doc, int dotPos) {
        FortranCodeStyle.get((Document)doc).setupLexerAttributes((Document)doc);
        TokenSequence ts = CndLexerUtilities.getFortranTokenSequence((Document)doc, (int)dotPos);
        if (ts == null) {
            return null;
        }
        ts.move(dotPos);
        if (!ts.moveNext()) {
            return null;
        }
        return ts.token();
    }

    private static TokenSequence<FortranTokenId> getTokenSequence(BaseDocument doc, int dotPos) {
        FortranCodeStyle.get((Document)doc).setupLexerAttributes((Document)doc);
        TokenSequence ts = CndLexerUtilities.getFortranTokenSequence((Document)doc, (int)dotPos);
        if (ts == null) {
            return null;
        }
        ts.move(dotPos);
        if (!ts.moveNext()) {
            return null;
        }
        return ts;
    }

    private static void skipClosingBracket(BaseDocument doc, Caret caret, char theBracket) throws BadLocationException {
        int caretOffset = caret.getDot();
        if (FortranBracketCompletion.isSkipClosingBracket(doc, caretOffset, FortranTokenId.RPAREN)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, FortranTokenId bracketId) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenSequence<FortranTokenId> ts = FortranBracketCompletion.getTokenSequence(doc, caretOffset);
        if (ts == null) {
            return false;
        }
        if (ts.token().id() == bracketId) {
            FortranTokenId id;
            FortranTokenId leftBracketId = FortranTokenId.LPAREN;
            int lastRBracketIndex = ts.index();
            while (ts.moveNext() && ts.token().id() == bracketId) {
                lastRBracketIndex = ts.index();
            }
            boolean braceBalance = false;
            int bracketBalance = -1;
            boolean finished = false;
            while (!finished && ts.movePrevious()) {
                id = (FortranTokenId)ts.token().id();
                switch (id) {
                    case LPAREN: {
                        if (id != bracketId || ++bracketBalance != 0) break;
                        if (braceBalance) {
                            bracketBalance = 1;
                        }
                        finished = true;
                        break;
                    }
                    case RPAREN: {
                        if (id != bracketId) break;
                        --bracketBalance;
                    }
                }
            }
            if (bracketBalance != 0) {
                skipClosingBracket = true;
            } else {
                braceBalance = false;
                bracketBalance = 1;
                ts.moveIndex(lastRBracketIndex);
                ts.moveNext();
                ts.moveNext();
                finished = false;
                while (!finished && ts.movePrevious()) {
                    id = (FortranTokenId)ts.token().id();
                    switch (id) {
                        case LPAREN: {
                            if (id != leftBracketId) break;
                            ++bracketBalance;
                            break;
                        }
                        case RPAREN: {
                            if (id != bracketId || --bracketBalance != 0) break;
                            if (braceBalance) {
                                bracketBalance = -1;
                            }
                            finished = true;
                        }
                    }
                }
                skipClosingBracket = bracketBalance == 0;
            }
        }
        return skipClosingBracket;
    }

    private static void completeOpeningBracket(BaseDocument doc, int dotPos, Caret caret, char theBracket) throws BadLocationException {
        if (FortranBracketCompletion.isCompletablePosition(doc, dotPos + 1)) {
            String matchinBracket = "" + FortranBracketCompletion.matching(theBracket);
            doc.insertString(dotPos + 1, matchinBracket, null);
            caret.setDot(dotPos + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    private static void completeQuote(BaseDocument doc, int dotPos, Caret caret, char theBracket) throws BadLocationException {
        if (FortranBracketCompletion.isEscapeSequence(doc, dotPos)) {
            return;
        }
        FortranTokenId[] tokenIds = new FortranTokenId[]{FortranTokenId.STRING_LITERAL};
        if (FortranBracketCompletion.posWithinQuotes(doc, dotPos + 1, theBracket, tokenIds) && FortranBracketCompletion.isCompletablePosition(doc, dotPos + 1) && FortranBracketCompletion.isUnclosedStringAtLineEnd(doc, dotPos + 1, tokenIds) && (doc.getLength() == dotPos + 1 || doc.getLength() != dotPos + 1 && doc.getChars(dotPos + 1, 1)[0] != theBracket)) {
            doc.insertString(dotPos + 1, "" + theBracket, null);
            caret.setDot(dotPos + 1);
        } else {
            char[] charss = doc.getChars(dotPos + 1, 1);
            if (charss != null && charss[0] == theBracket) {
                doc.remove(dotPos + 1, 1);
            }
        }
    }

    private static boolean isCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(dotPos, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == '-' || chr == '+' || chr == '|' || chr == '&' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    private static boolean completionSettingEnabled() {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/x-fortran").lookup(Preferences.class);
        return prefs.getBoolean("pair-characters-completion", true);
    }

    private static char matching(char theBracket) {
        switch (theBracket) {
            case '(': {
                return ')';
            }
            case '\'': {
                return '\'';
            }
        }
        return ' ';
    }

    private static boolean posWithinQuotes(BaseDocument doc, int dotPos, char quote, FortranTokenId[] tokenIDs) {
        TokenSequence<FortranTokenId> cppTS = FortranBracketCompletion.getTokenSequence(doc, dotPos);
        if (cppTS != null && FortranBracketCompletion.matchIDs((FortranTokenId)cppTS.token().id(), tokenIDs)) {
            return dotPos - cppTS.offset() == 1 || DocumentUtilities.getText((Document)doc).charAt(dotPos - 1) != quote;
        }
        return false;
    }

    private static boolean isUnclosedStringAtLineEnd(BaseDocument doc, int dotPos, FortranTokenId[] tokenIDs) {
        int lastNonWhiteOffset;
        try {
            lastNonWhiteOffset = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)dotPos);
        }
        catch (BadLocationException e) {
            return false;
        }
        TokenSequence<FortranTokenId> cppTS = FortranBracketCompletion.getTokenSequence(doc, lastNonWhiteOffset);
        if (cppTS != null) {
            return FortranBracketCompletion.matchIDs((FortranTokenId)cppTS.token().id(), tokenIDs);
        }
        return false;
    }

    static boolean matchIDs(FortranTokenId toCheck, FortranTokenId[] checkWith) {
        for (int i = checkWith.length - 1; i >= 0; --i) {
            if (toCheck != checkWith[i]) continue;
            return true;
        }
        return false;
    }
}

