/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.api;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.openide.util.NbBundle;

public final class CodeStyle {
    private static CodeStyle INSTANCE_C;
    private static CodeStyle INSTANCE_H;
    private static CodeStyle INSTANCE_CPP;
    private Language language;
    private Preferences preferences;
    private final boolean useOverrideOptions;

    private CodeStyle(Language language, Preferences preferences, boolean useOverrideOptions) {
        this.language = language;
        this.preferences = preferences;
        this.useOverrideOptions = useOverrideOptions;
    }

    public static synchronized CodeStyle getDefault(Language language) {
        switch (language) {
            case C: {
                if (INSTANCE_C == null) {
                    INSTANCE_C = CodeStyle.create(language);
                    CodeStyle.setSimplePreferences(language, INSTANCE_C);
                }
                return INSTANCE_C;
            }
            case HEADER: {
                if (INSTANCE_H == null) {
                    INSTANCE_H = CodeStyle.create(language);
                    CodeStyle.setSimplePreferences(language, INSTANCE_H);
                }
                return INSTANCE_H;
            }
        }
        if (INSTANCE_CPP == null) {
            INSTANCE_CPP = CodeStyle.create(language);
            CodeStyle.setSimplePreferences(language, INSTANCE_CPP);
        }
        return INSTANCE_CPP;
    }

    private static void setSimplePreferences(Language language, CodeStyle codeStyle) {
        EditorOptions.updateSimplePreferences(language, codeStyle);
    }

    public static synchronized CodeStyle getDefault(Document doc) {
        String mimeType = (String)doc.getProperty("mimeType");
        if (mimeType == null) {
            System.out.println("Undefined MIME type of document " + doc);
        } else {
            if (mimeType.equals("text/x-c")) {
                return CodeStyle.getDefault(Language.C);
            }
            if (mimeType.equals("text/x-h")) {
                return CodeStyle.getDefault(Language.HEADER);
            }
        }
        return CodeStyle.getDefault(Language.CPP);
    }

    private static CodeStyle create(Language language) {
        return new CodeStyle(language, EditorOptions.getPreferences(language, EditorOptions.getCurrentProfileId(language)), true);
    }

    private boolean isOverideTabIndents() {
        if (this.useOverrideOptions) {
            return EditorOptions.getOverideTabIndents(this.language);
        }
        return true;
    }

    public int indentSize() {
        if (this.isOverideTabIndents()) {
            return this.getOption("indentSize", 4);
        }
        return EditorOptions.getGlobalIndentSize();
    }

    public boolean expandTabToSpaces() {
        if (this.isOverideTabIndents()) {
            return this.getOption("expandTabToSpaces", true);
        }
        return EditorOptions.getGlobalExpandTabs();
    }

    public int getTabSize() {
        if (this.isOverideTabIndents()) {
            return this.getOption("tabSize", 8);
        }
        return EditorOptions.getGlobalTabSize();
    }

    public int getFormatStatementContinuationIndent() {
        return this.getOption("statementContinuationIndent", 8);
    }

    public int getConstructorInitializerListContinuationIndent() {
        return this.getOption("constructorListContinuationIndent", 0);
    }

    public PreprocessorIndent indentPreprocessorDirectives() {
        return PreprocessorIndent.valueOf(this.getOption("indentPreprocessorDirectives", EditorOptions.indentPreprocessorDirectivesDefault));
    }

    public VisibilityIndent indentVisibility() {
        return VisibilityIndent.valueOf(this.getOption("indentVisibility", EditorOptions.indentVisibilityDefault));
    }

    public boolean indentNamespace() {
        return this.getOption("indentNamespace", true);
    }

    public boolean indentCasesFromSwitch() {
        return this.getOption("indentCasesFromSwitch", true);
    }

    public boolean absoluteLabelIndent() {
        return this.getOption("absoluteLabelIndent", true);
    }

    public boolean sharpAtStartLine() {
        return this.getOption("sharpAtStartLine", true);
    }

    public boolean spaceKeepExtra() {
        return this.getOption("spaceKeepExtra", false);
    }

    public boolean spaceBeforeMethodDeclParen() {
        return this.getOption("spaceBeforeMethodDeclParen", false);
    }

    public boolean spaceBeforeMethodCallParen() {
        return this.getOption("spaceBeforeMethodCallParen", false);
    }

    public boolean spaceBeforeIfParen() {
        return this.getOption("spaceBeforeIfParen", true);
    }

    public boolean spaceBeforeForParen() {
        return this.getOption("spaceBeforeForParen", true);
    }

    public boolean spaceBeforeWhileParen() {
        return this.getOption("spaceBeforeWhileParen", true);
    }

    public boolean spaceBeforeCatchParen() {
        return this.getOption("spaceBeforeCatchParen", true);
    }

    public boolean spaceBeforeSwitchParen() {
        return this.getOption("spaceBeforeSwitchParen", true);
    }

    public boolean spaceBeforeKeywordParen() {
        return this.getOption("spaceBeforeKeywordParen", true);
    }

    public BracePlacement getFormatNewlineBeforeBraceNamespace() {
        return BracePlacement.valueOf(this.getOption("newLineBeforeBraceNamespace", EditorOptions.newLineBeforeBraceNamespaceDefault));
    }

    public BracePlacement getFormatNewlineBeforeBraceClass() {
        return BracePlacement.valueOf(this.getOption("newLineBeforeBraceClass", EditorOptions.newLineBeforeBraceClassDefault));
    }

    public BracePlacement getFormatNewlineBeforeBraceDeclaration() {
        return BracePlacement.valueOf(this.getOption("newLineBeforeBraceDeclaration", EditorOptions.newLineBeforeBraceDeclarationDefault));
    }

    public boolean ignoreEmptyFunctionBody() {
        return this.getOption("ignoreEmptyFunctionBody", false);
    }

    public BracePlacement getFormatNewLineBeforeBraceSwitch() {
        return BracePlacement.valueOf(this.getOption("newLineBeforeBraceSwitch", EditorOptions.newLineBeforeBraceSwitchDefault));
    }

    public BracePlacement getFormatNewlineBeforeBrace() {
        return BracePlacement.valueOf(this.getOption("newLineBeforeBrace", EditorOptions.newLineBeforeBraceDefault));
    }

    public boolean newLineCatch() {
        return this.getOption("newLineCatch", false);
    }

    public boolean newLineElse() {
        return this.getOption("newLineElse", false);
    }

    public boolean newLineWhile() {
        return this.getOption("newLineWhile", false);
    }

    public boolean newLineFunctionDefinitionName() {
        return this.getOption("newLineFunctionDefinitionName", false);
    }

    public boolean getFormatLeadingStarInComment() {
        return this.getOption("addLeadingStarInComment", EditorOptions.addLeadingStarInCommentDefault);
    }

    public boolean alignMultilineCallArgs() {
        return this.getOption("alignMultilineCallArgs", false);
    }

    public boolean alignMultilineMethodParams() {
        return this.getOption("alignMultilineMethodParams", false);
    }

    public boolean alignMultilineFor() {
        return this.getOption("alignMultilineFor", false);
    }

    public boolean alignMultilineIfCondition() {
        return this.getOption("alignMultilineIfCondition", false);
    }

    public boolean alignMultilineWhileCondition() {
        return this.getOption("alignMultilineWhileCondition", false);
    }

    public boolean alignMultilineParen() {
        return this.getOption("alignMultilineParen", false);
    }

    public boolean alignMultilineArrayInit() {
        return this.getOption("alignMultilineArrayInit", false);
    }

    public boolean spaceAroundUnaryOps() {
        return this.getOption("spaceAroundUnaryOps", false);
    }

    public boolean spaceAroundBinaryOps() {
        return this.getOption("spaceAroundBinaryOps", true);
    }

    public boolean spaceAroundAssignOps() {
        return this.getOption("spaceAroundAssignOps", true);
    }

    public boolean spaceAroundTernaryOps() {
        return this.getOption("spaceAroundTernaryOps", true);
    }

    public boolean spaceBeforeWhile() {
        return this.getOption("spaceBeforeWhile", true);
    }

    public boolean spaceBeforeElse() {
        return this.getOption("spaceBeforeElse", true);
    }

    public boolean spaceBeforeCatch() {
        return this.getOption("spaceBeforeCatch", true);
    }

    public boolean spaceBeforeComma() {
        return this.getOption("spaceBeforeComma", false);
    }

    public boolean spaceAfterComma() {
        return this.getOption("spaceAfterComma", true);
    }

    public boolean spaceBeforeSemi() {
        return this.getOption("spaceBeforeSemi", false);
    }

    public boolean spaceAfterSemi() {
        return this.getOption("spaceAfterSemi", true);
    }

    public boolean spaceBeforeColon() {
        return this.getOption("spaceBeforeColon", true);
    }

    public boolean spaceAfterColon() {
        return this.getOption("spaceAfterColon", true);
    }

    public boolean spaceAfterTypeCast() {
        return this.getOption("spaceAfterTypeCast", true);
    }

    public boolean spaceBeforeClassDeclLeftBrace() {
        return this.getOption("spaceBeforeClassDeclLeftBrace", true);
    }

    public boolean spaceBeforeMethodDeclLeftBrace() {
        return this.getOption("spaceBeforeMethodDeclLeftBrace", true);
    }

    public boolean spaceBeforeIfLeftBrace() {
        return this.getOption("spaceBeforeIfLeftBrace", true);
    }

    public boolean spaceBeforeElseLeftBrace() {
        return this.getOption("spaceBeforeElseLeftBrace", true);
    }

    public boolean spaceBeforeWhileLeftBrace() {
        return this.getOption("spaceBeforeWhileLeftBrace", true);
    }

    public boolean spaceBeforeForLeftBrace() {
        return this.getOption("spaceBeforeForLeftBrace", true);
    }

    public boolean spaceBeforeDoLeftBrace() {
        return this.getOption("spaceBeforeDoLeftBrace", true);
    }

    public boolean spaceBeforeSwitchLeftBrace() {
        return this.getOption("spaceBeforeSwitchLeftBrace", true);
    }

    public boolean spaceBeforeTryLeftBrace() {
        return this.getOption("spaceBeforeTryLeftBrace", true);
    }

    public boolean spaceBeforeCatchLeftBrace() {
        return this.getOption("spaceBeforeCatchLeftBrace", true);
    }

    public boolean spaceBeforeArrayInitLeftBrace() {
        return this.getOption("spaceBeforeArrayInitLeftBrace", false);
    }

    public boolean spaceWithinParens() {
        return this.getOption("spaceWithinParens", false);
    }

    public boolean spaceWithinMethodDeclParens() {
        return this.getOption("spaceWithinMethodDeclParens", false);
    }

    public boolean spaceWithinMethodCallParens() {
        return this.getOption("spaceWithinMethodCallParens", false);
    }

    public boolean spaceWithinIfParens() {
        return this.getOption("spaceWithinIfParens", false);
    }

    public boolean spaceWithinForParens() {
        return this.getOption("spaceWithinForParens", false);
    }

    public boolean spaceWithinWhileParens() {
        return this.getOption("spaceWithinWhileParens", false);
    }

    public boolean spaceWithinSwitchParens() {
        return this.getOption("spaceWithinSwitchParens", false);
    }

    public boolean spaceWithinCatchParens() {
        return this.getOption("spaceWithinCatchParens", false);
    }

    public boolean spaceWithinTypeCastParens() {
        return this.getOption("spaceWithinTypeCastParens", false);
    }

    public boolean spaceWithinBraces() {
        return this.getOption("spaceWithinBraces", false);
    }

    public int blankLinesBeforeClass() {
        return this.getOption("blankLinesBeforeClass", 1);
    }

    public int blankLinesAfterClassHeader() {
        return this.getOption("blankLinesAfterClassHeader", 0);
    }

    public int blankLinesBeforeMethods() {
        return this.getOption("blankLinesBeforeMethods", 1);
    }

    private boolean getOption(String key, boolean defaultValue) {
        defaultValue = (Boolean)EditorOptions.getDefault(this.language, EditorOptions.getCurrentProfileId(this.language), key);
        return this.getPreferences().getBoolean(key, defaultValue);
    }

    private int getOption(String key, int defaultValue) {
        defaultValue = (Integer)EditorOptions.getDefault(this.language, EditorOptions.getCurrentProfileId(this.language), key);
        return this.getPreferences().getInt(key, defaultValue);
    }

    private String getOption(String key, String defaultValue) {
        defaultValue = (String)EditorOptions.getDefault(this.language, EditorOptions.getCurrentProfileId(this.language), key);
        return this.getPreferences().get(key, defaultValue);
    }

    private Preferences getPreferences() {
        return this.preferences;
    }

    private void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public String toString() {
        return "Code style for language " + (Object)((Object)this.language) + ". Preferences " + this.preferences;
    }

    static {
        EditorOptions.codeStyleFactory = new FactoryImpl();
    }

    private static class FactoryImpl
    implements EditorOptions.CodeStyleFactory {
        private FactoryImpl() {
        }

        @Override
        public CodeStyle create(Language language, Preferences preferences, boolean useOverrideOptions) {
            return new CodeStyle(language, preferences, useOverrideOptions);
        }

        @Override
        public Preferences getPreferences(CodeStyle codeStyle) {
            return codeStyle.getPreferences();
        }

        @Override
        public void setPreferences(CodeStyle codeStyle, Preferences preferences) {
            codeStyle.setPreferences(preferences);
        }
    }

    public static enum VisibilityIndent {
        NO_INDENT,
        HALF_INDENT;


        public String toString() {
            return NbBundle.getMessage(CodeStyle.class, (String)("LBL_vi_" + this.name()));
        }
    }

    public static enum PreprocessorIndent {
        START_LINE,
        CODE_INDENT,
        PREPROCESSOR_INDENT;


        public String toString() {
            return NbBundle.getMessage(CodeStyle.class, (String)("LBL_pi_" + this.name()));
        }
    }

    public static enum BracePlacement {
        SAME_LINE,
        NEW_LINE,
        NEW_LINE_HALF_INDENTED;


        public String toString() {
            return NbBundle.getMessage(CodeStyle.class, (String)("LBL_bp_" + this.name()));
        }
    }

    public static enum Language {
        C,
        CPP,
        HEADER;


        public String toString() {
            return NbBundle.getMessage(CodeStyle.class, (String)("LBL_Language_" + this.name()));
        }
    }
}

