/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.IOException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.taskdefs.WebdavMatchingTask;

public class Move
extends WebdavMatchingTask {
    private String destination;
    private boolean overwrite;
    private HttpURL destinationURL;

    public void execute() throws BuildException {
        this.validate();
        try {
            this.log("Moving " + this.getUrl(), this.ifVerbose());
            Utils.moveResource(this.getHttpClient(), this.getUrl(), this.destinationURL.getURI(), this.overwrite);
        }
        catch (IOException e) {
            throw Utils.makeBuildException("Can't move!", e);
        }
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setOverwrite(boolean value) {
        this.overwrite = value;
    }

    protected void validate() {
        super.validate();
        if (this.destination == null) {
            throw new BuildException("Missing required attribute destination");
        }
        try {
            this.destinationURL = Utils.createHttpURL(this.getUrl(), this.destination);
            this.destinationURL.setPath(Move.removeDoubleSlashes(this.destinationURL.getPath()));
        }
        catch (URIException e) {
            throw new BuildException("Invalid destination uri!", (Throwable)e);
        }
    }
}

