/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.properties.GetLastModifiedProperty;
import org.apache.webdav.lib.properties.ResourceTypeProperty;

public class ResourceProperties {
    private Map resourceMap = new HashMap();

    public void storeProperties(PropFindMethod propFind) throws URIException {
        Enumeration e = propFind.getAllResponseURLs();
        while (e.hasMoreElements()) {
            String href = (String)e.nextElement();
            URI uri = new URI(propFind.getURI(), href);
            String key = uri.toString();
            ArrayList<Property> properties = (ArrayList<Property>)this.resourceMap.get(key);
            if (properties == null) {
                properties = new ArrayList<Property>();
                this.resourceMap.put(key, properties);
            }
            Enumeration f = propFind.getResponseProperties(href);
            while (f.hasMoreElements()) {
                properties.add((Property)f.nextElement());
            }
        }
    }

    public Property getProperty(HttpURL baseUrl, String relative, PropertyName propertyName) throws URIException {
        HttpURL url = Utils.createHttpURL(baseUrl, relative);
        return this.getProperty(url.getURI(), propertyName);
    }

    public Property getProperty(String uri, PropertyName propertyName) {
        List properties = (List)this.resourceMap.get(uri);
        if (properties != null) {
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                Property p = (Property)i.next();
                if (!p.getLocalName().equals(propertyName.getLocalName()) || !p.getNamespaceURI().equals(propertyName.getNamespaceURI())) continue;
                return p;
            }
        }
        return null;
    }

    public long getLastModified(String uri) {
        GetLastModifiedProperty p = (GetLastModifiedProperty)this.getProperty(uri, Utils.GETLASTMODIFIED);
        if (p != null) {
            return p.getDate().getTime();
        }
        return 0L;
    }

    public ResourceTypeProperty getResourceType(HttpURL baseUrl, String relative) throws URIException {
        HttpURL url = Utils.createHttpURL(baseUrl, relative);
        return this.getResourceType(url.toString());
    }

    public ResourceTypeProperty getResourceType(String uri) {
        ResourceTypeProperty p = (ResourceTypeProperty)this.getProperty(uri, Utils.RESOURCETYPE);
        return p;
    }
}

