/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class ArrayTypeSerializer
implements JavonSerializer {
    private Set<ClassData> arrayTypes = new HashSet<ClassData>();

    @Override
    public String getName() {
        return "Array type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        return TypeKind.ARRAY == typeMirror.getKind();
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror typeMirror, Map<String, ClassData> map) {
        ArrayType arrayType;
        TypeMirror typeMirror2;
        ClassData classData;
        if (TypeKind.ARRAY == typeMirror.getKind() && (classData = traversable.traverseType(typeMirror2 = (arrayType = (ArrayType)typeMirror).getComponentType(), map)) != null) {
            ClassData classData2 = new ClassData(classData.getPackage(), classData.getClassName(), false, true, (JavonSerializer)this);
            classData2.setComponentType(classData);
            traversable.registerType(classData);
            this.arrayTypes.add(classData2);
            return classData2;
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping javonMapping, ClassData classData) {
        ClassData classData2 = classData.getComponentType();
        return classData2.getSerializer().instanceOf(javonMapping, classData2) + "[]";
    }

    @Override
    public String toObject(JavonMapping javonMapping, ClassData classData, String string) {
        if (this.arrayTypes.contains(classData)) {
            return string;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String fromObject(JavonMapping javonMapping, ClassData classData, String string) {
        if (this.arrayTypes.contains(classData)) {
            return "(" + javonMapping.getRegistry().getTypeSerializer(classData).instanceOf(javonMapping, classData) + ")" + string;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String toStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        if (this.arrayTypes.contains(classData)) {
            String string3 = "";
            String string4 = "" + javonMapping.getRegistry().getRegisteredTypeId(classData);
            String string5 = classData.getSerializer().instanceOf(javonMapping, classData);
            string3 = string3 + string5 + " a_result_" + string4 + " = (" + string5 + ") o;\n";
            string3 = string3 + string + ".writeInt( a_result_" + string4 + ".length );\n";
            string3 = string3 + "for( int i  = 0; i < a_result_" + string4 + ".length; i++ ) {\n";
            ClassData classData2 = classData.getComponentType();
            string3 = classData2.isPrimitive() ? string3 + "writeObject( " + string + ", " + classData2.getSerializer().toObject(javonMapping, classData2, "a_result_" + string4 + "[i]") + " , " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n" : string3 + "writeObject( " + string + ", a_result_" + string4 + "[i], " + javonMapping.getRegistry().getRegisteredTypeId(classData2) + " );\n";
            string3 = string3 + "}\n";
            return string3;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public String fromStream(JavonMapping javonMapping, ClassData classData, String string, String string2) {
        if (this.arrayTypes.contains(classData)) {
            String string3 = "";
            String string4 = "" + javonMapping.getRegistry().getRegisteredTypeId(classData);
            ClassData classData2 = classData;
            int n = 0;
            while ((classData2 = classData2.getComponentType()).isArray()) {
                ++n;
            }
            String string5 = "";
            for (int i = 0; i < n; ++i) {
                string5 = string5 + "[]";
            }
            string3 = string3 + "int a_size_" + string4 + " = " + string + ".readInt();\n";
            String string6 = classData.getSerializer().instanceOf(javonMapping, classData);
            String string7 = classData2.getSerializer().instanceOf(javonMapping, classData2);
            string3 = string3 + string6 + " a_result_" + string4 + " = new " + string7 + "[ a_size_" + string4 + " ]" + string5 + ";\n";
            String string8 = "a_i_" + string4;
            string3 = string3 + "for( int " + string8 + " = 0; " + string8 + " < a_size_" + string4 + "; " + string8 + "++ ) {\n";
            ClassData classData3 = classData.getComponentType();
            string3 = classData3.isPrimitive() ? string3 + "a_result_" + string4 + "[" + string8 + "] = " + classData3.getSerializer().fromObject(javonMapping, classData3, "readObject( " + string + " )") + ";\n" : string3 + "a_result_" + string4 + "[" + string8 + "] = (" + classData.getComponentType().getSerializer().instanceOf(javonMapping, classData.getComponentType()) + ")readObject( " + string + " );\n";
            string3 = string3 + "}\n";
            string3 = string3 + (string2 == null ? "" : string2 + " = a_result_" + string4 + ";\n");
            return string3;
        }
        throw new IllegalArgumentException("Invalid type: " + classData.getName());
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData classData, Set<ClassData> set) {
        HashSet<ClassData> hashSet = new HashSet<ClassData>();
        hashSet.add(classData);
        hashSet.addAll(classData.getComponentType().getSerializer().getReferencedTypes(classData.getComponentType(), set));
        return hashSet;
    }
}

