/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.FindDialogPanel;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.OutputPane;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOContainer;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

final class OutputTab
extends AbstractOutputTab
implements IOContainer.CallBacks {
    private final NbIO io;
    private OutWriter outWriter;
    private boolean hasOutputListeners = false;
    boolean ignoreCaretChanges = false;
    int[] lastCaretListenerRange;
    private static String lastDir = null;
    FilteredOutput filtOut;
    AbstractOutputPane origPane;
    private static final int ACTION_COPY = 0;
    private static final int ACTION_WRAP = 1;
    private static final int ACTION_SAVEAS = 2;
    private static final int ACTION_CLOSE = 3;
    private static final int ACTION_NEXTERROR = 4;
    private static final int ACTION_PREVERROR = 5;
    private static final int ACTION_SELECTALL = 6;
    private static final int ACTION_FIND = 7;
    private static final int ACTION_FINDNEXT = 8;
    private static final int ACTION_NAVTOLINE = 9;
    private static final int ACTION_POSTMENU = 10;
    private static final int ACTION_FINDPREVIOUS = 11;
    private static final int ACTION_CLEAR = 12;
    private static final int ACTION_NEXTTAB = 13;
    private static final int ACTION_PREVTAB = 14;
    private static final int ACTION_LARGERFONT = 15;
    private static final int ACTION_SMALLERFONT = 16;
    private static final int ACTION_FONTTYPE = 17;
    private static final int ACTION_FILTER = 18;
    private static final int ACTION_PASTE = 19;
    Action copyAction = new TabAction(0, "ACTION_COPY");
    Action pasteAction = new TabAction(19, "ACTION_PASTE");
    Action wrapAction = new TabAction(1, "ACTION_WRAP");
    Action saveAsAction = new TabAction(2, "ACTION_SAVEAS");
    Action closeAction = new TabAction(3, "ACTION_CLOSE");
    Action nextErrorAction = new TabAction(4, "ACTION_NEXT_ERROR");
    Action prevErrorAction = new TabAction(5, "ACTION_PREV_ERROR");
    Action selectAllAction = new TabAction(6, "ACTION_SELECT_ALL");
    Action findAction = new TabAction(7, "ACTION_FIND");
    Action findNextAction = new TabAction(8, "ACTION_FIND_NEXT");
    Action findPreviousAction = new TabAction(11, "ACTION_FIND_PREVIOUS");
    Action filterAction = new TabAction(18, "ACTION_FILTER");
    Action largerFontAction = new TabAction(15, "ACTION_LARGER_FONT");
    Action smallerFontAction = new TabAction(16, "ACTION_SMALLER_FONT");
    Action fontTypeAction = new TabAction(17, "ACTION_FONT_TYPE");
    Action navToLineAction = new TabAction(9, "navToLine", KeyStroke.getKeyStroke(10, 0));
    Action postMenuAction = new TabAction(10, "postMenu", KeyStroke.getKeyStroke(121, 64));
    Action clearAction = new TabAction(12, "ACTION_CLEAR");
    Action nextTabAction = new TabAction(13, "NextViewAction", null);
    Action prevTabAction = new TabAction(14, "PreviousViewAction", null);
    private Object[] popupItems = new Object[]{this.copyAction, this.pasteAction, new JSeparator(), this.findAction, this.findNextAction, this.findPreviousAction, this.filterAction, new JSeparator(), this.wrapAction, this.largerFontAction, this.smallerFontAction, this.fontTypeAction, new JSeparator(), this.saveAsAction, this.clearAction, this.closeAction};

    OutputTab(NbIO io) {
        this.io = io;
        if (Controller.LOG) {
            Controller.log("Created an output component for " + io);
        }
        this.outWriter = ((NbWriter)io.getOut()).out();
        OutputDocument doc = new OutputDocument(this.outWriter);
        this.setDocument(doc);
        this.installKBActions();
        this.getActionMap().put("jumpPrev", this.prevErrorAction);
        this.getActionMap().put("jumpNext", this.nextErrorAction);
        this.getActionMap().put(FindAction.class.getName(), this.findAction);
        this.getActionMap().put("copy-to-clipboard", this.copyAction);
    }

    private void installKBActions() {
        this.installKeyboardAction(this.copyAction);
        this.installKeyboardAction(this.selectAllAction);
        this.installKeyboardAction(this.findAction);
        this.installKeyboardAction(this.findNextAction);
        this.installKeyboardAction(this.findPreviousAction);
        this.installKeyboardAction(this.wrapAction);
        this.installKeyboardAction(this.largerFontAction);
        this.installKeyboardAction(this.smallerFontAction);
        this.installKeyboardAction(this.saveAsAction);
        this.installKeyboardAction(this.closeAction);
        this.installKeyboardAction(this.copyAction);
        this.installKeyboardAction(this.navToLineAction);
        this.installKeyboardAction(this.postMenuAction);
        this.installKeyboardAction(this.clearAction);
        this.installKeyboardAction(this.filterAction);
    }

    @Override
    public void setDocument(Document doc) {
        if (Controller.LOG) {
            Controller.log("Set document on " + this + " with " + this.io);
        }
        assert (SwingUtilities.isEventDispatchThread());
        OutputDocument old = this.getDocument();
        this.hasOutputListeners = false;
        super.setDocument(doc);
        if (old != null && old instanceof OutputDocument) {
            old.dispose();
        }
    }

    public void reset() {
        if (this.origPane != null) {
            this.setFilter(null, false, false);
        }
        this.outWriter = this.io.out();
        this.setDocument(new OutputDocument(this.outWriter));
    }

    public OutputDocument getDocument() {
        Document d = this.getOutputPane().getDocument();
        if (d instanceof OutputDocument) {
            return (OutputDocument)d;
        }
        return null;
    }

    @Override
    protected AbstractOutputPane createOutputPane() {
        return new OutputPane(this);
    }

    @Override
    protected void inputSent(String txt) {
        if (Controller.LOG) {
            Controller.log("Input sent on OutputTab: " + txt);
        }
        this.getOutputPane().lockScroll();
        NbIO.IOReader in = this.io.in();
        if (in != null) {
            if (Controller.LOG) {
                Controller.log("Sending input to " + in);
            }
            in.pushText(txt + "\n");
            this.outWriter.println(txt);
        }
    }

    @Override
    protected void inputEof() {
        NbIO.IOReader in;
        if (Controller.LOG) {
            Controller.log("Input EOF");
        }
        if ((in = this.io.in()) != null) {
            in.eof();
        }
    }

    @Override
    public void hasSelectionChanged(boolean val) {
        if (this.isShowing()) {
            this.copyAction.setEnabled(val);
            this.selectAllAction.setEnabled(!this.getOutputPane().isAllSelected());
        }
    }

    public NbIO getIO() {
        return this.io;
    }

    void requestActive() {
        this.io.getIOContainer().requestActive();
    }

    public void lineClicked(int line, int pos) {
        OutWriter out = this.getOut();
        int[] range = new int[2];
        OutputListener l = out.getLines().getListener(pos, range);
        if (l != null) {
            int size = out.getLines().getCharCount();
            assert (range[1] < size) : "Size: " + size + " range: " + range[0] + " " + range[1];
            Controller.ControllerOutputEvent oe = new Controller.ControllerOutputEvent(this.io, out, line);
            l.outputLineAction((OutputEvent)oe);
            this.getOutputPane().sendCaretToPos(range[0], range[1], true);
        }
    }

    @Override
    public String toString() {
        return "OutputTab@" + System.identityHashCode(this) + " for " + this.io;
    }

    public void documentChanged(OutputPane pane) {
        if (this.filtOut != null && pane == this.origPane) {
            this.filtOut.readFrom(this.outWriter);
        }
        boolean hadOutputListeners = this.hasOutputListeners;
        boolean bl = this.hasOutputListeners = this.getOut() != null && this.getOut().getLines().firstListenerLine() >= 0;
        if (this.hasOutputListeners != hadOutputListeners) {
            this.hasOutputListenersChanged(this.hasOutputListeners);
        }
        IOContainer ioContainer = this.io.getIOContainer();
        if (this.io.isFocusTaken()) {
            ioContainer.open();
            ioContainer.select((JComponent)this);
            ioContainer.requestVisible();
        }
        Controller.getDefault().updateName(this);
        if (this == ioContainer.getSelected() && ioContainer.isActivated()) {
            this.updateActions();
        }
    }

    private void navigateToFirstErrorLine() {
        OutWriter out = this.getOut();
        if (out != null) {
            int line = out.getLines().firstImportantListenerLine();
            if (Controller.LOG) {
                Controller.log("NAV TO FIRST LISTENER LINE: " + line);
            }
            if (line >= 0) {
                this.getOutputPane().sendCaretToLine(line, false);
                if (this.isSDI()) {
                    this.requestActive();
                }
            }
        }
    }

    private boolean isSDI() {
        Container c = this.getTopLevelAncestor();
        return c != WindowManager.getDefault().getMainWindow();
    }

    void hasOutputListenersChanged(boolean hasOutputListeners) {
        if (hasOutputListeners && this.getOutputPane().isScrollLocked()) {
            this.navigateToFirstErrorLine();
        }
    }

    public void activated() {
        this.updateActions();
    }

    public void closed() {
        this.io.setClosed(true);
        this.io.setStreamClosed(true);
        Controller.getDefault().removeTab(this.io);
        NbWriter w = this.io.writer();
        if (w != null && w.isClosed()) {
            this.setDocument(null);
        } else if (w != null) {
            this.getDocument().disposeQuietly();
        }
    }

    public void deactivated() {
    }

    public void selected() {
    }

    public boolean shouldRelock(int dot) {
        OutWriter w = this.getOut();
        if (w != null && !w.isClosed()) {
            int dist = Math.abs(w.getLines().getCharCount() - dot);
            return dist < 100;
        }
        return false;
    }

    void caretPosChanged(int pos) {
        if (!this.ignoreCaretChanges) {
            if (this.lastCaretListenerRange != null && pos >= this.lastCaretListenerRange[0] && pos < this.lastCaretListenerRange[1]) {
                return;
            }
            OutWriter out = this.getOut();
            if (out != null) {
                int[] range = new int[2];
                OutputListener l = out.getLines().getListener(pos, range);
                if (l != null) {
                    Controller.ControllerOutputEvent oe = new Controller.ControllerOutputEvent(this.io, out.getLines().getLineAt(pos));
                    l.outputLineSelected((OutputEvent)oe);
                    this.lastCaretListenerRange = range;
                } else {
                    this.lastCaretListenerRange = null;
                }
            }
        }
    }

    private void sendCaretToError(boolean backward) {
        OutWriter out = this.getOut();
        if (out != null) {
            AbstractOutputPane op = this.getOutputPane();
            int selStart = op.getSelectionStart();
            int selEnd = op.getSelectionEnd();
            int pos = op.getCaretPos();
            if (selStart != selEnd && pos == selStart && out.getLines().isListener(selStart, selEnd)) {
                pos = backward ? selStart - 1 : selEnd + 1;
            }
            int[] lpos = new int[2];
            OutputListener l = out.getLines().nearestListener(pos, backward, lpos);
            if (l != null) {
                op.sendCaretToPos(lpos[0], lpos[1], true);
                if (!this.io.getIOContainer().isActivated()) {
                    Controller.ControllerOutputEvent ce = new Controller.ControllerOutputEvent(this.io, out.getLines().getLineAt(lpos[0]));
                    l.outputLineAction((OutputEvent)ce);
                }
            }
        }
    }

    private boolean find(boolean reversed) {
        OutWriter out = this.getOut();
        if (out != null) {
            String msg;
            int pos;
            String lastPattern = FindDialogPanel.result();
            if (lastPattern == null) {
                return false;
            }
            int n = pos = reversed ? this.getOutputPane().getSelectionStart() : this.getOutputPane().getCaretPos();
            if (pos > this.getOutputPane().getLength() || pos < 0) {
                pos = 0;
            }
            boolean regExp = FindDialogPanel.regExp();
            boolean matchCase = FindDialogPanel.matchCase();
            int[] sel = reversed ? out.getLines().rfind(pos, lastPattern, regExp, matchCase) : out.getLines().find(pos, lastPattern, regExp, matchCase);
            String appendMsg = null;
            if (sel == null) {
                int[] nArray = sel = reversed ? out.getLines().rfind(out.getLines().getCharCount(), lastPattern, regExp, matchCase) : out.getLines().find(0, lastPattern, regExp, matchCase);
                if (sel != null) {
                    appendMsg = NbBundle.getMessage(OutputTab.class, (String)(reversed ? "MSG_SearchFromEnd" : "MSG_SearchFromBeg"));
                }
            }
            if (sel != null) {
                this.getOutputPane().unlockScroll();
                this.getOutputPane().setSelection(sel[0], sel[1]);
                int line = out.getLines().getLineAt(sel[0]);
                int col = sel[0] - out.getLines().getLineStart(line);
                msg = NbBundle.getMessage(OutputTab.class, (String)"MSG_Found", (Object)lastPattern, (Object)(line + 1), (Object)(col + 1));
                if (appendMsg != null) {
                    msg = msg + "; " + appendMsg;
                }
            } else {
                msg = NbBundle.getMessage(OutputTab.class, (String)"MSG_NotFound", (Object)lastPattern);
            }
            StatusDisplayer.getDefault().setStatusText(msg);
            return sel != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAs() {
        OutWriter out = this.getOut();
        if (out == null) {
            return;
        }
        File f = OutputTab.showFileChooser(this);
        if (f != null) {
            try {
                OutWriter outWriter = out;
                synchronized (outWriter) {
                    out.getLines().saveAs(f.getPath());
                }
            }
            catch (IOException ioe) {
                NotifyDescriptor notifyDesc = new NotifyDescriptor((Object)NbBundle.getMessage(OutputTab.class, (String)"MSG_SaveAsFailed", (Object)f.getPath()), NbBundle.getMessage(OutputTab.class, (String)"LBL_SaveAsFailedTitle"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(notifyDesc);
            }
        }
    }

    private static File showFileChooser(JComponent owner) {
        File f = null;
        String dlgTtl = NbBundle.getMessage(Controller.class, (String)"TITLE_SAVE_DLG");
        boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        if (isAqua) {
            FileDialog fd = new FileDialog((Frame)owner.getTopLevelAncestor(), dlgTtl, 1);
            if (lastDir != null && new File(lastDir).exists()) {
                fd.setDirectory(lastDir);
            }
            fd.setModal(true);
            fd.setVisible(true);
            String s = fd.getDirectory() + fd.getFile();
            f = new File(s);
            if (f.exists() && f.isDirectory()) {
                f = null;
            }
        } else {
            File dir;
            JFileChooser jfc = new JFileChooser();
            if (lastDir != null && new File(lastDir).exists() && (dir = new File(lastDir)).exists()) {
                jfc.setCurrentDirectory(dir);
            }
            jfc.setName(dlgTtl);
            jfc.setDialogTitle(dlgTtl);
            if (jfc.showSaveDialog(owner.getTopLevelAncestor()) == 0) {
                f = jfc.getSelectedFile();
            }
        }
        if (f != null && f.exists() && !isAqua) {
            String msg = NbBundle.getMessage(Controller.class, (String)"FMT_FILE_EXISTS", (Object[])new Object[]{f.getName()});
            String title = NbBundle.getMessage(Controller.class, (String)"TITLE_FILE_EXISTS");
            if (JOptionPane.showConfirmDialog(owner.getTopLevelAncestor(), msg, title, 2) != 0) {
                f = null;
            }
        }
        if (f != null) {
            lastDir = f.getParent();
        }
        return f;
    }

    private void openHyperlink() {
        OutWriter out = this.getOut();
        if (out != null) {
            int pos = this.getOutputPane().getCaretPos();
            int[] range = new int[2];
            OutputListener l = out.getLines().getListener(pos, range);
            if (l != null) {
                this.ignoreCaretChanges = true;
                this.getOutputPane().sendCaretToPos(range[0], range[1], true);
                this.ignoreCaretChanges = false;
                Controller.ControllerOutputEvent coe = new Controller.ControllerOutputEvent(this.io, out.getLines().getLineAt(pos));
                l.outputLineAction((OutputEvent)coe);
            }
        }
    }

    void postPopupMenu(Point p, Component src) {
        int i;
        JPopupMenu popup = new JPopupMenu();
        Action[] a = this.getToolbarActions();
        if (a.length > 0) {
            boolean added = false;
            for (i = 0; i < a.length; ++i) {
                if (a[i].getValue("Name") == null) continue;
                popup.add(new ProxyAction(a[i]));
                added = true;
            }
            if (added) {
                popup.add(new JSeparator());
            }
        }
        ArrayList<TabAction> activeActions = new ArrayList<TabAction>(this.popupItems.length);
        for (i = 0; i < this.popupItems.length; ++i) {
            JMenuItem item;
            if (this.popupItems[i] instanceof JSeparator) {
                popup.add((JSeparator)this.popupItems[i]);
                continue;
            }
            if (this.popupItems[i] == this.wrapAction) {
                item = new JCheckBoxMenuItem((Action)this.popupItems[i]);
                item.setSelected(this.getOutputPane().isWrapped());
                activeActions.add((TabAction)this.popupItems[i]);
                popup.add(item);
                continue;
            }
            if (this.popupItems[i] == this.filterAction) {
                item = new JCheckBoxMenuItem((Action)this.popupItems[i]);
                item.setSelected(this.origPane != null);
                activeActions.add((TabAction)this.popupItems[i]);
                popup.add(item);
                continue;
            }
            if (this.popupItems[i] == this.closeAction && !this.io.getIOContainer().isCloseable((JComponent)this) || this.popupItems[i] == this.fontTypeAction && this.getOutputPane().isWrapped()) continue;
            item = popup.add((Action)this.popupItems[i]);
            activeActions.add((TabAction)this.popupItems[i]);
            if (this.popupItems[i] != this.findAction) continue;
            item.setMnemonic(70);
        }
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        JTextComponent c = this.getOutputPane().getTextView();
        Object escHandle = c.getInputMap().get(esc);
        c.getInputMap().remove(esc);
        this.getInputMap(1).remove(esc);
        popup.addPopupMenuListener(new PMListener(activeActions, escHandle));
        popup.show(src, p.x, p.y);
    }

    void updateActions() {
        OutputPane pane = (OutputPane)this.getOutputPane();
        int len = pane.getLength();
        boolean enable = len > 0;
        OutWriter out = this.getOut();
        this.saveAsAction.setEnabled(enable);
        this.selectAllAction.setEnabled(enable);
        this.copyAction.setEnabled(pane.hasSelection());
        boolean hasErrors = out == null ? false : out.getLines().hasListeners();
        this.nextErrorAction.setEnabled(hasErrors);
        this.prevErrorAction.setEnabled(hasErrors);
    }

    private void showFontChooser() {
        PropertyEditor pe = PropertyEditorManager.findEditor(Font.class);
        if (pe != null) {
            pe.setValue(this.getOutputPane().getViewFont());
            DialogDescriptor dd = new DialogDescriptor((Object)pe.getCustomEditor(), NbBundle.getMessage(OutputTab.class, (String)"LBL_Font_Chooser_Title"));
            String defaultFont = NbBundle.getMessage(OutputTab.class, (String)"BTN_Defaul_Font");
            dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION, defaultFont, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                Font f = (Font)pe.getValue();
                Controller.getDefault().changeFont(f);
            } else if (dd.getValue() == defaultFont) {
                Controller.getDefault().changeFont(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFilter(String pattern, boolean regExp, boolean matchCase) {
        if (pattern == null) {
            assert (this.origPane != null);
            this.setOutputPane(this.origPane);
            this.origPane = null;
            this.filtOut.dispose();
            this.filtOut = null;
        } else {
            assert (this.origPane == null);
            this.origPane = this.getOutputPane();
            this.filtOut = new FilteredOutput(pattern, regExp, matchCase);
            this.setOutputPane(this.filtOut.getPane());
            try {
                this.waitCursor(true);
                this.filtOut.readFrom(this.outWriter);
                this.installKBActions();
            }
            finally {
                this.waitCursor(false);
            }
        }
        this.validate();
        this.getOutputPane().repaint();
        this.requestFocus();
    }

    private void waitCursor(boolean enable) {
        RootPaneContainer root = (RootPaneContainer)((Object)this.getTopLevelAncestor());
        Cursor cursor = Cursor.getPredefinedCursor(enable ? 3 : 0);
        root.getGlassPane().setCursor(cursor);
        root.getGlassPane().setVisible(enable);
    }

    OutWriter getOut() {
        return this.origPane != null ? this.filtOut.getWriter() : this.outWriter;
    }

    private void disableHtmlName() {
        String escaped;
        Controller.getDefault().removeFromUpdater(this);
        try {
            escaped = XMLUtil.toAttributeValue((String)(this.io.getName() + " "));
        }
        catch (CharConversionException e) {
            escaped = this.io.getName() + " ";
        }
        this.io.getIOContainer().setTitle((JComponent)this, escaped.replace("&apos;", "'"));
    }

    @Override
    public void setInputVisible(boolean val) {
        super.setInputVisible(val);
        this.pasteAction.setEnabled(val);
    }

    private boolean validRegExp(String pattern) {
        try {
            Pattern.compile(pattern);
            return true;
        }
        catch (PatternSyntaxException ex) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), NbBundle.getMessage(OutputTab.class, (String)"FMT_Invalid_RegExp", (Object)pattern), NbBundle.getMessage(OutputTab.class, (String)"LBL_Invalid_RegExp"), 0);
            return false;
        }
    }

    private String getFindDlgResult(String selection, String title, String label, String button) {
        String pattern = FindDialogPanel.getResult(selection, title, label, button);
        while (pattern != null && FindDialogPanel.regExp() && !this.validRegExp(pattern)) {
            pattern = FindDialogPanel.getResult(pattern, title, label, button);
        }
        return pattern;
    }

    private class FilteredOutput {
        String pattern;
        OutWriter out;
        OutputPane pane;
        OutputDocument doc;
        int readCount;
        Pattern compPattern;
        boolean regExp;
        boolean matchCase;

        public FilteredOutput(String pattern, boolean regExp, boolean matchCase) {
            this.pattern = regExp || matchCase ? pattern : pattern.toLowerCase();
            this.regExp = regExp;
            this.matchCase = matchCase;
            this.out = new OutWriter();
            this.pane = new OutputPane(OutputTab.this);
            this.doc = new OutputDocument(this.out);
            this.pane.setDocument(this.doc);
        }

        boolean passFilter(String str) {
            if (this.regExp) {
                if (this.compPattern == null) {
                    this.compPattern = this.matchCase ? Pattern.compile(this.pattern) : Pattern.compile(this.pattern, 2);
                }
                return this.compPattern.matcher(str).find();
            }
            return this.matchCase ? str.contains(this.pattern) : str.toLowerCase().contains(this.pattern);
        }

        OutputPane getPane() {
            return this.pane;
        }

        OutWriter getWriter() {
            return this.out;
        }

        synchronized void readFrom(OutWriter orig) {
            AbstractLines lines = (AbstractLines)orig.getLines();
            while (this.readCount < lines.getLineCount()) {
                try {
                    int line;
                    ++this.readCount;
                    String str = lines.getLine(line);
                    if (!this.passFilter(str)) continue;
                    LineInfo info = lines.getExistingLineInfo(line);
                    this.out.print(str, info, lines.isImportantLine(line));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        void dispose() {
            this.out.dispose();
        }
    }

    private class PMListener
    implements PopupMenuListener {
        private List<TabAction> popupItems;
        private Object handle;

        PMListener(List<TabAction> popupItems, Object escHandle) {
            this.popupItems = popupItems;
            this.handle = escHandle;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            popup.removeAll();
            popup.setInvoker(null);
            KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
            JTextComponent c = OutputTab.this.getOutputPane().getTextView();
            c.getInputMap().put(esc, this.handle);
            OutputTab.this.getInputMap(1).put(esc, this.handle);
            popup.removePopupMenuListener(this);
            for (TabAction action : this.popupItems) {
                action.clearListeners();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.popupMenuWillBecomeInvisible(e);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private static class ProxyAction
    implements Action {
        private Action orig;

        ProxyAction(Action original) {
            this.orig = original;
        }

        @Override
        public Object getValue(String key) {
            if ("SmallIcon".equals(key)) {
                return null;
            }
            return this.orig.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.orig.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
            this.orig.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            return this.orig.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.orig.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.orig.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.orig.actionPerformed(e);
        }
    }

    class TabAction
    extends AbstractAction {
        private int id;

        TabAction(int id, String bundleKey) {
            if (bundleKey != null) {
                String name = NbBundle.getMessage(OutputTab.class, (String)bundleKey);
                KeyStroke accelerator = this.getAcceleratorFor(bundleKey);
                this.id = id;
                this.putValue("Name", name);
                this.putValue("AcceleratorKey", accelerator);
            }
        }

        TabAction(int id, String name, KeyStroke stroke) {
            this.id = id;
            this.putValue("Name", name);
            this.putValue("AcceleratorKey", stroke);
        }

        void clearListeners() {
            PropertyChangeListener[] l = this.changeSupport.getPropertyChangeListeners();
            for (int i = 0; i < l.length; ++i) {
                this.removePropertyChangeListener(l[i]);
            }
        }

        private KeyStroke getAcceleratorFor(String name) {
            String key = name + ".accel";
            if (Utilities.isMac()) {
                key = key + ".mac";
            }
            return Utilities.stringToKey((String)NbBundle.getMessage(OutputTab.class, (String)key));
        }

        public int getID() {
            return this.id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.id) {
                case 0: {
                    OutputTab.this.getOutputPane().copy();
                    break;
                }
                case 19: {
                    OutputTab.this.getOutputPane().paste();
                    break;
                }
                case 1: {
                    boolean wrapped = OutputTab.this.getOutputPane().isWrapped();
                    OutputTab.this.getOutputPane().setWrapped(!wrapped);
                    break;
                }
                case 2: {
                    OutputTab.this.saveAs();
                    break;
                }
                case 3: {
                    OutputTab.this.io.getIOContainer().remove((JComponent)OutputTab.this);
                    break;
                }
                case 4: {
                    OutputTab.this.sendCaretToError(false);
                    break;
                }
                case 5: {
                    OutputTab.this.sendCaretToError(true);
                    break;
                }
                case 6: {
                    OutputTab.this.getOutputPane().selectAll();
                    break;
                }
                case 7: {
                    String pattern = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Find_Title", "LBL_Find_What", "BTN_Find");
                    if (pattern == null || !OutputTab.this.find(false)) break;
                    OutputTab.this.findNextAction.setEnabled(true);
                    OutputTab.this.findPreviousAction.setEnabled(true);
                    OutputTab.this.requestFocus();
                    break;
                }
                case 8: {
                    OutputTab.this.find(false);
                    break;
                }
                case 11: {
                    OutputTab.this.find(true);
                    break;
                }
                case 9: {
                    OutputTab.this.openHyperlink();
                    break;
                }
                case 10: {
                    OutputTab.this.postPopupMenu(new Point(0, 0), OutputTab.this);
                    break;
                }
                case 12: {
                    NbWriter writer = OutputTab.this.io.writer();
                    if (writer == null) break;
                    try {
                        boolean vis = OutputTab.this.isInputVisible();
                        boolean closed = OutputTab.this.io.isStreamClosed();
                        writer.reset();
                        OutputTab.this.setInputVisible(vis);
                        OutputTab.this.io.setStreamClosed(closed);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    break;
                }
                case 16: {
                    Controller.getDefault().changeFontSizeBy(-1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case 15: {
                    Controller.getDefault().changeFontSizeBy(1, OutputTab.this.getOutputPane().isWrapped());
                    break;
                }
                case 17: {
                    OutputTab.this.showFontChooser();
                    break;
                }
                case 18: {
                    if (OutputTab.this.origPane != null) {
                        OutputTab.this.setFilter(null, false, false);
                        break;
                    }
                    String pattern = OutputTab.this.getFindDlgResult(OutputTab.this.getOutputPane().getSelectedText(), "LBL_Filter_Title", "LBL_Filter_What", "BTN_Filter");
                    if (pattern == null) break;
                    OutputTab.this.setFilter(pattern, FindDialogPanel.regExp(), FindDialogPanel.matchCase());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }
}

