/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.CRC32;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.api.jaxws.project.JAXWSVersionProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class TransformerUtils {
    public static final String JAX_WS_XML_PATH = "nbproject/jax-ws.xml";
    public static final String JAXWS_BUILD_XML_PATH = "nbproject/jaxws-build.xml";
    static final String GENFILES_PROPERTIES_PATH = "nbproject/genfiles.properties";
    static final String KEY_SUFFIX_JAXWS_BUILD_CRC = ".stylesheet.CRC32";
    static final String JAXWS_20_LIB = "jaxws20lib";
    static final String JAXWS_VERSION = "jaxwsversion";

    public static void transformClients(FileObject fileObject, String string) throws IOException {
        TransformerUtils.transformClients(fileObject, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformClients(FileObject fileObject, String string, boolean bl) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        final FileObject fileObject2 = fileObject.getFileObject(JAX_WS_XML_PATH);
        final FileObject fileObject3 = FileUtil.createData((FileObject)fileObject, (String)JAXWS_BUILD_XML_PATH);
        try {
            byArray3 = (byte[])ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<byte[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public byte[] run() throws IOException {
                    InputStream inputStream = fileObject2.getInputStream();
                    try {
                        byte[] byArray = TransformerUtils.load(inputStream);
                        return byArray;
                    }
                    finally {
                        inputStream.close();
                    }
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        URL uRL = TransformerUtils.class.getResource(string);
        InputStream inputStream = uRL.openStream();
        try {
            byArray2 = TransformerUtils.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byArray2), uRL.toExternalForm());
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            if (bl && !TransformerUtils.isJAXWS21(fileObject)) {
                transformer.setParameter(JAXWS_VERSION, JAXWS_20_LIB);
            }
            File file = FileUtil.toFile((FileObject)fileObject2);
            assert (file != null);
            StreamSource streamSource2 = new StreamSource(new ByteArrayInputStream(byArray3), file.toURI().toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.transform(streamSource2, new StreamResult(byteArrayOutputStream));
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (TransformerException transformerException) {
            throw (IOException)new IOException(transformerException.toString()).initCause(transformerException);
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Boolean run() throws IOException {
                    FileLock fileLock = fileObject3.lock();
                    OutputStream outputStream = null;
                    try {
                        outputStream = fileObject3.getOutputStream(fileLock);
                        outputStream.write(byArray);
                    }
                    finally {
                        fileLock.releaseLock();
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    return Boolean.TRUE;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    static byte[] load(InputStream inputStream) throws IOException {
        int n;
        int n2 = Math.max(1024, inputStream.available());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean isJAXWS21(FileObject fileObject) {
        String string;
        JAXWSVersionProvider jAXWSVersionProvider;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return project == null || (jAXWSVersionProvider = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class)) == null || (string = jAXWSVersionProvider.getJAXWSVersion()) == null || TransformerUtils.isVersionOK(string, "2.1");
    }

    static String getCrc32(InputStream inputStream) throws IOException {
        return TransformerUtils.computeCrc32(inputStream);
    }

    private static String computeCrc32(InputStream inputStream) throws IOException {
        int n;
        CRC32 cRC32 = new CRC32();
        int n2 = -1;
        while ((n = inputStream.read()) != -1) {
            if (n != 10 && n2 == 13) {
                cRC32.update(10);
            }
            if (n != 13) {
                cRC32.update(n);
            }
            n2 = n;
        }
        if (n2 == 13) {
            cRC32.update(10);
        }
        int n3 = (int)cRC32.getValue();
        String string = Integer.toHexString(n3);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return string;
    }

    private static boolean isVersionOK(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i < Math.min(n, n2); ++i) {
            if (string.charAt(i) < string2.charAt(i)) {
                return false;
            }
            if (string.charAt(i) <= string2.charAt(i)) continue;
            return true;
        }
        if (n > n2) {
            return true;
        }
        return n >= n2;
    }
}

