/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api.ui;

import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.api.project.Project;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactViewerFactory;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public final class ArtifactViewer {
    public static final String HINT_ARTIFACT = "art";
    public static final String HINT_PROJECT = "prj";
    public static final String HINT_DEPENDENCIES = "dep";
    public static final String HINT_GRAPH = "grf";

    private ArtifactViewer() {
    }

    public static void showArtifactViewer(NBVersionInfo info, String panelHint) {
        ArtifactViewer.showArtifactViewer(null, info, null, null, panelHint);
    }

    public static void showArtifactViewer(NBVersionInfo info) {
        ArtifactViewer.showArtifactViewer(null, info, null, null, null);
    }

    public static void showArtifactViewer(Artifact artifact, List<ArtifactRepository> repos, String panelHint) {
        ArtifactViewer.showArtifactViewer(null, null, artifact, repos, panelHint);
    }

    public static void showArtifactViewer(Artifact artifact, List<ArtifactRepository> repos) {
        ArtifactViewer.showArtifactViewer(null, null, artifact, repos, null);
    }

    public static void showArtifactViewer(Project project, String panelHint) {
        ArtifactViewer.showArtifactViewer(project, null, null, null, panelHint);
    }

    private static void showArtifactViewer(Project project, NBVersionInfo info, Artifact artifact, List<ArtifactRepository> repos, String panelHint) {
        ArtifactViewerFactory fact = (ArtifactViewerFactory)Lookup.getDefault().lookup(ArtifactViewerFactory.class);
        if (fact == null) {
            Logger.getLogger(ArtifactViewer.class.getName()).info("No implementation of ArtifactViewerFactory available.");
            return;
        }
        TopComponent tc = project != null ? fact.createTopComponent(project) : (info != null ? fact.createTopComponent(info) : fact.createTopComponent(artifact, repos));
        tc.open();
        tc.requestActive();
        if (panelHint != null) {
            MultiViewHandler hand = MultiViews.findMultiViewHandler((TopComponent)tc);
            if (hand == null) {
                return;
            }
            for (MultiViewPerspective pers : hand.getPerspectives()) {
                if (!panelHint.equals(pers.preferredID())) continue;
                hand.requestVisible(pers);
                return;
            }
        }
    }
}

