/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import hidden.org.codehaus.plexus.util.Base64;
import hidden.org.codehaus.plexus.util.FileUtils;
import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PluginIndexManager {
    private static final String ZIP_LOCATION = "org/netbeans/modules/maven/indexer/pluginz.zip";
    private static final String INDEX_PATH = "maven-plugins-index";
    private static IndexReader indexReader;
    private static String FIELD_ID;
    private static String FIELD_MVN_VERSION;
    private static String FIELD_GOALS;
    private static String FIELD_PREFIX;
    private static String PREFIX_FIELD_GOAL;
    private static String FIELD_CYCLES;
    private static String PREFIX_FIELD_CYCLE;
    static final int BUFFER = 2048;

    private static synchronized IndexSearcher getIndexSearcher() throws Exception {
        if (indexReader == null) {
            FSDirectory dir = FSDirectory.getDirectory((File)PluginIndexManager.getDefaultIndexLocation());
            indexReader = IndexReader.open((Directory)dir);
        }
        return new IndexSearcher(indexReader);
    }

    public static Set<String> getPluginGoalNames(Set<String> groups) throws Exception {
        IndexSearcher searcher = PluginIndexManager.getIndexSearcher();
        BooleanQuery bq = new BooleanQuery();
        for (String grp : groups) {
            PrefixQuery pq = new PrefixQuery(new Term(FIELD_ID, grp));
            bq.add(new BooleanClause((Query)pq, BooleanClause.Occur.SHOULD));
        }
        Hits hits = searcher.search((Query)bq);
        Iterator it = hits.iterator();
        TreeSet<String> toRet = new TreeSet<String>();
        while (it.hasNext()) {
            String[] gls;
            Hit hit = (Hit)it.next();
            Document doc = hit.getDocument();
            String prefix = doc.getField(FIELD_PREFIX).stringValue();
            String goals = doc.getField(FIELD_GOALS).stringValue();
            for (String goal : gls = StringUtils.split((String)goals, (String)" ")) {
                toRet.add(prefix + ":" + goal);
            }
        }
        return toRet;
    }

    public static Set<String> getPluginGoals(String groupId, String artifactId, String version) throws Exception {
        String id;
        TermQuery tq;
        assert (groupId != null && artifactId != null && version != null);
        IndexSearcher searcher = PluginIndexManager.getIndexSearcher();
        Hits hits = searcher.search((Query)(tq = new TermQuery(new Term(FIELD_ID, id = groupId + "|" + artifactId + "|" + version))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator it = hits.iterator();
        TreeSet<String> toRet = new TreeSet<String>();
        while (it.hasNext()) {
            String[] gls;
            Hit hit = (Hit)it.next();
            Document doc = hit.getDocument();
            String goals = doc.getField(FIELD_GOALS).stringValue();
            for (String goal : gls = StringUtils.split((String)goals, (String)" ")) {
                toRet.add(goal);
            }
        }
        return toRet;
    }

    public static Set<String> getPluginParameterNames(String groupId, String artifactId, String version, String mojo) throws Exception {
        String id;
        TermQuery tq;
        assert (groupId != null && artifactId != null && version != null);
        IndexSearcher searcher = PluginIndexManager.getIndexSearcher();
        Hits hits = searcher.search((Query)(tq = new TermQuery(new Term(FIELD_ID, id = groupId + "|" + artifactId + "|" + version))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator it = hits.iterator();
        TreeSet<String> toRet = new TreeSet<String>();
        while (it.hasNext()) {
            String[] gls;
            Hit hit = (Hit)it.next();
            Document doc = hit.getDocument();
            String goals = doc.getField(FIELD_GOALS).stringValue();
            for (String goal : gls = StringUtils.split((String)goals, (String)" ")) {
                String[] lines;
                if (mojo != null && !mojo.equals(goal)) continue;
                String params = doc.getField(PREFIX_FIELD_GOAL + goal).stringValue();
                for (String line : lines = StringUtils.split((String)params, (String)"\n")) {
                    String[] paramDet = StringUtils.split((String)line, (String)"|");
                    String name = paramDet[0];
                    String editable = paramDet[1];
                    if (!"true".equals(editable)) continue;
                    toRet.add(name);
                }
            }
        }
        return toRet;
    }

    public static Set<ParameterDetail> getPluginParameters(String groupId, String artifactId, String version, String mojo) throws Exception {
        String id;
        TermQuery tq;
        assert (groupId != null && artifactId != null && version != null);
        IndexSearcher searcher = PluginIndexManager.getIndexSearcher();
        Hits hits = searcher.search((Query)(tq = new TermQuery(new Term(FIELD_ID, id = groupId + "|" + artifactId + "|" + version))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator it = hits.iterator();
        TreeSet<ParameterDetail> toRet = new TreeSet<ParameterDetail>(new PComparator());
        while (it.hasNext()) {
            String[] gls;
            Hit hit = (Hit)it.next();
            Document doc = hit.getDocument();
            String goals = doc.getField(FIELD_GOALS).stringValue();
            for (String goal : gls = StringUtils.split((String)goals, (String)" ")) {
                String[] lines;
                if (mojo != null && !mojo.equals(goal)) continue;
                String params = doc.getField(PREFIX_FIELD_GOAL + goal).stringValue();
                for (String line : lines = StringUtils.split((String)params, (String)"\n")) {
                    String desc;
                    String defVal;
                    String[] paramDet = StringUtils.split((String)line, (String)"|");
                    String name = paramDet[0];
                    String editable = paramDet[1];
                    String required = paramDet[2];
                    boolean req = "true".equals(required);
                    if (!"true".equals(editable)) continue;
                    String expr = paramDet[3];
                    if (expr != null && "null".equals(expr)) {
                        expr = null;
                    }
                    if ((defVal = paramDet[4]) != null && "null".equals(defVal)) {
                        defVal = null;
                    }
                    if (paramDet.length > 5) {
                        desc = paramDet[5];
                        byte[] dec = Base64.decodeBase64((byte[])desc.getBytes());
                        desc = new String(dec, "UTF-8");
                    } else {
                        desc = null;
                    }
                    ParameterDetail pm = new ParameterDetail(name, expr, defVal, req, desc);
                    toRet.add(pm);
                }
            }
        }
        return toRet;
    }

    public static Set<String> getPluginsForGoalPrefix(String prefix) throws Exception {
        TermQuery tq;
        assert (prefix != null);
        IndexSearcher searcher = PluginIndexManager.getIndexSearcher();
        Hits hits = searcher.search((Query)(tq = new TermQuery(new Term(FIELD_PREFIX, prefix))));
        if (hits.length() == 0) {
            return null;
        }
        Iterator it = hits.iterator();
        TreeSet<String> toRet = new TreeSet<String>();
        while (it.hasNext()) {
            Hit hit = (Hit)it.next();
            Document doc = hit.getDocument();
            String id = doc.getField(FIELD_ID).stringValue();
            toRet.add(id);
        }
        return toRet;
    }

    public static Map<String, List<String>> getLifecyclePlugins(String packaging, String mvnVersion, String[] extensionPlugins) throws Exception {
        assert (packaging != null);
        IndexSearcher searcher = PluginIndexManager.getIndexSearcher();
        BooleanQuery bq = new BooleanQuery();
        TermQuery tq = new TermQuery(new Term(FIELD_CYCLES, packaging));
        bq.add((Query)tq, BooleanClause.Occur.MUST);
        if (mvnVersion == null) {
            mvnVersion = "2.0.9";
        }
        BooleanQuery bq2 = new BooleanQuery();
        tq = new TermQuery(new Term(FIELD_MVN_VERSION, mvnVersion));
        bq2.add((Query)tq, BooleanClause.Occur.SHOULD);
        for (String ext : extensionPlugins) {
            tq = new TermQuery(new Term(FIELD_ID, ext));
            bq2.add((Query)tq, BooleanClause.Occur.SHOULD);
        }
        bq.add((Query)bq2, BooleanClause.Occur.SHOULD);
        Hits hits = searcher.search((Query)bq);
        if (hits.length() == 0) {
            return null;
        }
        Iterator it = hits.iterator();
        LinkedHashMap<String, List<String>> toRet = new LinkedHashMap<String, List<String>>();
        while (it.hasNext()) {
            String[] phases;
            Hit hit = (Hit)it.next();
            Document doc = hit.getDocument();
            Field prefixed = doc.getField(PREFIX_FIELD_CYCLE + packaging);
            if (prefixed == null) continue;
            String mapping = prefixed.stringValue();
            for (String phase : phases = StringUtils.split((String)mapping, (String)"\n")) {
                String[] ph = StringUtils.split((String)phase, (String)"=");
                String[] plugins = StringUtils.split((String)ph[1], (String)",");
                ArrayList<String> plgs = new ArrayList<String>(Arrays.asList(plugins));
                toRet.put(ph[0], plgs);
            }
        }
        return toRet;
    }

    private static int checkLocalVersion(File[] fls) {
        for (File fl : fls) {
            try {
                int intVersion = Integer.parseInt(fl.getName());
                return intVersion;
            }
            catch (NumberFormatException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return fls.length > 0 ? Integer.MAX_VALUE : 0;
    }

    /*
     * Exception decompiling
     */
    private static int checkZipVersion(File cacheDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getDefaultIndexLocation() {
        File cacheDir;
        block10: {
            int local;
            File[] fls;
            block11: {
                String userdir = System.getProperty("netbeans.user");
                if (userdir != null) {
                    cacheDir = new File(new File(new File(userdir, "var"), "cache"), INDEX_PATH);
                } else {
                    File root = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
                    cacheDir = new File(root, INDEX_PATH);
                }
                cacheDir.mkdirs();
                fls = cacheDir.listFiles();
                if (fls != null && fls.length != 0) break block11;
                InputStream is = null;
                try {
                    is = PluginIndexManager.class.getClassLoader().getResourceAsStream(ZIP_LOCATION);
                    ZipInputStream zis = new ZipInputStream(is);
                    PluginIndexManager.unzip(zis, cacheDir);
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    throw throwable;
                }
                IOUtil.close((InputStream)is);
                break block10;
            }
            int zipped = PluginIndexManager.checkZipVersion(cacheDir);
            if (zipped > (local = PluginIndexManager.checkLocalVersion(fls)) && local > 0) {
                try {
                    FileUtils.deleteDirectory((File)new File(cacheDir, "" + local));
                    InputStream is = null;
                    try {
                        is = PluginIndexManager.class.getClassLoader().getResourceAsStream(ZIP_LOCATION);
                        ZipInputStream zis = new ZipInputStream(is);
                        PluginIndexManager.unzip(zis, cacheDir);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(is);
                        throw throwable;
                    }
                    IOUtil.close((InputStream)is);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        File[] files = cacheDir.listFiles();
        assert (files != null && files.length == 1);
        cacheDir = files[0];
        return cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(ZipInputStream zis, File cacheDir) {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                File fl = new File(cacheDir, entry.getName());
                fl.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(fl);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtil.close((InputStream)zis);
        }
    }

    static {
        FIELD_ID = "id";
        FIELD_MVN_VERSION = "mvn";
        FIELD_GOALS = "gls";
        FIELD_PREFIX = "prfx";
        PREFIX_FIELD_GOAL = "mj_";
        FIELD_CYCLES = "ccls";
        PREFIX_FIELD_CYCLE = "ccl_";
    }

    public static class ParameterDetail {
        private String name;
        private String expression;
        private String defaultValue;
        private boolean required;
        private String description;

        public ParameterDetail(String name, String expression, String defaultValue, boolean required, String description) {
            this.name = name;
            this.expression = expression;
            this.defaultValue = defaultValue;
            this.required = required;
            this.description = description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getHtmlDetails(boolean includeName) {
            return "<html><body>" + (includeName ? "<h4>" + NbBundle.getMessage(PluginIndexManager.class, (String)"TXT_LBL_PARAMETER") + this.getName() + "</h4>" : "") + "<b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Expression") + "</b>" + (this.getExpression() != null ? "${" + this.getExpression() + "}" : NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Undefined")) + "<br>" + "<b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_DefaultValue") + "</b>" + (this.getDefaultValue() != null ? this.getDefaultValue() : NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Undefined")) + "<br><b>" + NbBundle.getMessage(PluginIndexManager.class, (String)"LBL_Description") + "</b><br>" + this.getDescription() + "</body></html>";
        }
    }

    private static class PComparator
    implements Comparator<ParameterDetail> {
        private PComparator() {
        }

        @Override
        public int compare(ParameterDetail o1, ParameterDetail o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

