/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.io.File;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.profiler.MavenProjectTypeProfiler;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.util.RequestProcessor;

public class RunCheckerImpl
implements LateBoundPrerequisitesChecker {
    private static final String ACTION_PROFILE = "profile";
    private static final String ACTION_PROFILE_SINGLE = "profile-single";
    private static final String ACTION_PROFILE_TESTS = "profile-tests";
    private static final String PROFILER_ARGS = "${profiler.args}";
    private static final String PROFILER_JAVA = "${profiler.java}";
    private Project project;

    public RunCheckerImpl(Project project) {
        this.project = project;
    }

    public boolean checkRunConfig(RunConfig runConfig, ExecutionContext executionContext) {
        Properties properties = runConfig.getProperties();
        if (ACTION_PROFILE.equals(runConfig.getActionName()) || ACTION_PROFILE_TESTS.equals(runConfig.getActionName()) || runConfig.getActionName() != null && runConfig.getActionName().startsWith(ACTION_PROFILE_SINGLE)) {
            final ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler((Project)this.project);
            if (!(projectTypeProfiler instanceof MavenProjectTypeProfiler)) {
                return false;
            }
            Properties properties2 = ((MavenProjectTypeProfiler)projectTypeProfiler).getLastSessionProperties();
            for (Object object : properties.keySet()) {
                String string;
                String string2 = (String)object;
                String string3 = properties.getProperty(string2);
                if (string3.contains(PROFILER_ARGS)) {
                    string = this.fixAgentArg(properties2.getProperty("profiler.info.jvmargs.agent"));
                    string3 = string3.replace(PROFILER_ARGS, properties2.getProperty("profiler.info.jvmargs") + " " + string);
                    properties.setProperty(string2, string3.trim());
                }
                if (!string3.contains(PROFILER_JAVA)) continue;
                string = properties2.getProperty("profiler.info.jvm");
                string3 = string3.replace(PROFILER_JAVA, string != null && new File(string).isFile() ? string : "java");
                properties.setProperty(string2, string3.trim());
            }
            runConfig.setProperties(properties);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    Profiler.getDefault().connectToStartedApp(((MavenProjectTypeProfiler)projectTypeProfiler).getLastProfilingSettings(), ((MavenProjectTypeProfiler)projectTypeProfiler).getLastSessionSettings());
                }
            });
        }
        return true;
    }

    private String fixAgentArg(String string) {
        if ((string = string.replace("\\", "/")).indexOf(32) != -1) {
            return "\"" + string + "\"";
        }
        return string;
    }
}

