/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.toolchain.execution.OutputListenerFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputListenerImpl
implements OutputListener {
    private static final String CC_compiler_errors = "C/C++ compiler errors";
    private final OutputListenerFactory manager;
    private final FileObject file;
    private final int line;
    private final boolean isError;
    private final String description;

    public OutputListenerImpl(OutputListenerFactory manager, FileObject file, int line, boolean isError, String description) {
        this.manager = manager;
        this.file = file;
        this.line = line;
        this.isError = isError;
        this.description = description;
    }

    public void outputLineSelected(OutputEvent ev) {
        this.showLine(false);
    }

    public void outputLineAction(OutputEvent ev) {
        this.showLine(true);
    }

    public void outputLineCleared(OutputEvent ev) {
        try {
            EditorCookie ec;
            DataObject dob = DataObject.find((FileObject)this.file);
            StyledDocument doc = null;
            if (dob.isValid() && (ec = (EditorCookie)dob.getCookie(EditorCookie.class)) != null) {
                doc = ec.getDocument();
            }
            if (doc != null) {
                HintsController.setErrors(doc, (String)CC_compiler_errors, Collections.emptyList());
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    public boolean isError() {
        return this.isError;
    }

    private void showLine(boolean openTab) {
        block13: {
            try {
                DataObject dob = DataObject.find((FileObject)this.file);
                LineCookie lc = (LineCookie)dob.getCookie(LineCookie.class);
                if (lc == null) break block13;
                try {
                    Line l = lc.getLineSet().getOriginal(this.line);
                    if (!l.isDeleted()) {
                        EditorCookie ec;
                        if (openTab) {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        } else {
                            l.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE);
                        }
                        StyledDocument doc = null;
                        if (dob.isValid() && (ec = (EditorCookie)dob.getCookie(EditorCookie.class)) != null) {
                            doc = ec.getDocument();
                        }
                        if (doc != null) {
                            ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
                            for (OutputListenerImpl impl : this.manager.getFileListeners(this.file)) {
                                String aDescription = impl.description;
                                if (impl.isError) {
                                    if (aDescription == null) {
                                        aDescription = NbBundle.getMessage(OutputListenerImpl.class, (String)"HINT_CompilerError");
                                    }
                                    errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)impl.description, (Document)doc, (int)(impl.line + 1)));
                                    continue;
                                }
                                if (aDescription == null) {
                                    aDescription = NbBundle.getMessage(OutputListenerImpl.class, (String)"HINT_CompilerWarning");
                                }
                                errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)impl.description, (Document)doc, (int)(impl.line + 1)));
                            }
                            HintsController.setErrors((Document)doc, (String)CC_compiler_errors, errors);
                        }
                    }
                }
                catch (IndexOutOfBoundsException ex) {}
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }
}

