/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.Hk2OptionalFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.AntDeploymentProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class AntDeploymentProviderImpl
implements AntDeploymentProvider {
    private final File propFile;
    private final Properties props;

    AntDeploymentProviderImpl(Hk2DeploymentManager hk2DeploymentManager, Hk2OptionalFactory hk2OptionalFactory) {
        GlassfishModule glassfishModule = hk2DeploymentManager.getCommonServerSupport();
        this.propFile = this.computeFile(glassfishModule);
        this.props = this.computeProps(glassfishModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeploymentScript(OutputStream outputStream, Object object) throws IOException {
        InputStream inputStream = AntDeploymentProviderImpl.class.getResourceAsStream("ant-deploy.xml");
        try {
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDeploymentPropertiesFile() {
        if (!this.propFile.exists()) {
            try {
                FileObject fileObject = FileUtil.createData((File)this.propFile);
                FileLock fileLock = null;
                try {
                    fileLock = fileObject.lock();
                    OutputStream outputStream = fileObject.getOutputStream(fileLock);
                    try {
                        this.props.store(outputStream, "");
                    }
                    finally {
                        if (null != outputStream) {
                            outputStream.close();
                        }
                    }
                }
                finally {
                    if (null != fileLock) {
                        fileLock.releaseLock();
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, null, iOException);
            }
        }
        return this.propFile;
    }

    private File computeFile(GlassfishModule glassfishModule) {
        String string = (String)glassfishModule.getInstanceProperties().get("url");
        String string2 = (String)glassfishModule.getInstanceProperties().get("domainsfolder");
        String string3 = (String)glassfishModule.getInstanceProperties().get("domainname");
        String string4 = (String)glassfishModule.getInstanceProperties().get("username");
        String string5 = "gfv3" + (string + string2 + string3 + string4).hashCode() + "";
        return new File(System.getProperty("netbeans.user"), string5 + ".properties");
    }

    private Properties computeProps(GlassfishModule glassfishModule) {
        Properties properties = new Properties();
        properties.setProperty("gfv3.root", (String)glassfishModule.getInstanceProperties().get("homefolder"));
        String string = "http://" + (String)glassfishModule.getInstanceProperties().get("host") + ":" + (String)glassfishModule.getInstanceProperties().get("httpportnumber");
        properties.setProperty("gfv3.url", string);
        string = "http://" + (String)glassfishModule.getInstanceProperties().get("host") + ":" + (String)glassfishModule.getInstanceProperties().get("adminPort");
        properties.setProperty("gfv3.admin.url", string);
        properties.setProperty("gfv3.username", (String)glassfishModule.getInstanceProperties().get("username"));
        properties.setProperty("gfv3.host", (String)glassfishModule.getInstanceProperties().get("host"));
        properties.setProperty("gfv3.port", (String)glassfishModule.getInstanceProperties().get("adminPort"));
        return properties;
    }
}

